/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.connector;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.commons.pipe.task.DecoratingLock;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.metric.PipeConnectorMetrics;
import org.apache.iotdb.db.pipe.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.task.subtask.PipeDataNodeSubtask;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConnectorSubtask
extends PipeDataNodeSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConnectorSubtask.class);
    private final BoundedBlockingPendingQueue<Event> inputPendingQueue;
    private final PipeConnector outputPipeConnector;
    protected final DecoratingLock callbackDecoratingLock = new DecoratingLock();
    protected ExecutorService subtaskCallbackListeningExecutor;
    protected volatile boolean isSubmitted = false;
    private final String attributeSortedString;
    private final int connectorIndex;
    private static final PipeHeartbeatEvent CRON_HEARTBEAT_EVENT = new PipeHeartbeatEvent("cron", false);
    private static final long CRON_HEARTBEAT_EVENT_INJECT_INTERVAL_SECONDS = PipeConfig.getInstance().getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds();
    private long lastHeartbeatEventInjectTime = System.currentTimeMillis();

    public PipeConnectorSubtask(String taskID, long creationTime, String attributeSortedString, int connectorIndex, BoundedBlockingPendingQueue<Event> inputPendingQueue, PipeConnector outputPipeConnector) {
        super(taskID, creationTime);
        this.attributeSortedString = attributeSortedString;
        this.connectorIndex = connectorIndex;
        this.inputPendingQueue = inputPendingQueue;
        this.outputPipeConnector = outputPipeConnector;
        PipeConnectorMetrics.getInstance().register(this);
    }

    public void bindExecutors(ListeningExecutorService subtaskWorkerThreadPoolExecutor, ExecutorService subtaskCallbackListeningExecutor, PipeSubtaskScheduler subtaskScheduler) {
        this.subtaskWorkerThreadPoolExecutor = subtaskWorkerThreadPoolExecutor;
        this.subtaskCallbackListeningExecutor = subtaskCallbackListeningExecutor;
        this.subtaskScheduler = subtaskScheduler;
    }

    public Boolean call() throws Exception {
        boolean hasAtLeastOneEventProcessed = super.call();
        this.callbackDecoratingLock.waitForDecorated();
        return hasAtLeastOneEventProcessed;
    }

    protected boolean executeOnce() {
        if (this.isClosed.get()) {
            return false;
        }
        Event event = this.lastEvent != null ? this.lastEvent : this.inputPendingQueue.waitedPoll();
        this.setLastEvent(event);
        try {
            if (event == null) {
                if (System.currentTimeMillis() - this.lastHeartbeatEventInjectTime > CRON_HEARTBEAT_EVENT_INJECT_INTERVAL_SECONDS) {
                    this.transferHeartbeatEvent(CRON_HEARTBEAT_EVENT);
                }
                return false;
            }
            if (event instanceof TabletInsertionEvent) {
                this.outputPipeConnector.transfer((TabletInsertionEvent)event);
                PipeConnectorMetrics.getInstance().markTabletEvent(this.taskID);
            } else if (event instanceof TsFileInsertionEvent) {
                this.outputPipeConnector.transfer((TsFileInsertionEvent)event);
                PipeConnectorMetrics.getInstance().markTsFileEvent(this.taskID);
            } else if (event instanceof PipeHeartbeatEvent) {
                this.transferHeartbeatEvent((PipeHeartbeatEvent)event);
            } else {
                this.outputPipeConnector.transfer(event);
            }
            this.releaseLastEvent(true);
        }
        catch (PipeConnectionException e) {
            if (!this.isClosed.get()) {
                throw e;
            }
            LOGGER.info("PipeConnectionException in pipe transfer, ignored because pipe is dropped.", (Throwable)e);
            this.releaseLastEvent(false);
        }
        catch (Exception e) {
            if (!this.isClosed.get()) {
                throw new PipeException(String.format("Exception in pipe transfer, subtask: %s, last event: %s, root cause: %s", this.taskID, this.lastEvent, ErrorHandlingUtils.getRootCause(e).getMessage()), (Throwable)e);
            }
            LOGGER.info("Exception in pipe transfer, ignored because pipe is dropped.", (Throwable)e);
            this.releaseLastEvent(false);
        }
        return true;
    }

    private void transferHeartbeatEvent(PipeHeartbeatEvent event) {
        try {
            this.outputPipeConnector.heartbeat();
            this.outputPipeConnector.transfer((Event)event);
        }
        catch (Exception e) {
            throw new PipeConnectionException("PipeConnector: " + this.outputPipeConnector.getClass().getName() + " heartbeat failed, or encountered failure when transferring generic event.", (Throwable)e);
        }
        this.lastHeartbeatEventInjectTime = System.currentTimeMillis();
        event.onTransferred();
        PipeConnectorMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
    }

    public synchronized void onSuccess(Boolean hasAtLeastOneEventProcessed) {
        this.isSubmitted = false;
        super.onSuccess(hasAtLeastOneEventProcessed);
    }

    @Override
    public synchronized void onFailure(@NotNull Throwable throwable) {
        this.isSubmitted = false;
        if (this.isClosed.get()) {
            LOGGER.info("onFailure in pipe transfer, ignored because pipe is dropped.", throwable);
            this.releaseLastEvent(false);
            return;
        }
        if (throwable instanceof PipeConnectionException && this.onPipeConnectionException(throwable)) {
            return;
        }
        super.onFailure((Throwable)new PipeRuntimeConnectorCriticalException(throwable.getMessage()));
    }

    private boolean onPipeConnectionException(Throwable throwable) {
        LOGGER.warn("PipeConnectionException occurred, {} retries to handshake with the target system.", (Object)this.outputPipeConnector.getClass().getName(), (Object)throwable);
        int retry = 0;
        while (retry < 5) {
            try {
                this.outputPipeConnector.handshake();
                LOGGER.info("{} handshakes with the target system successfully.", (Object)this.outputPipeConnector.getClass().getName());
                break;
            }
            catch (Exception e) {
                LOGGER.warn("{} failed to handshake with the target system for {} times, will retry at most {} times.", new Object[]{this.outputPipeConnector.getClass().getName(), ++retry, 5, e});
                try {
                    Thread.sleep((long)retry * PipeConfig.getInstance().getPipeConnectorRetryIntervalMs());
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.info("Interrupted while sleeping, will retry to handshake with the target system.", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (retry == 5 && this.lastEvent instanceof EnrichedEvent) {
            ((EnrichedEvent)this.lastEvent).reportException((PipeRuntimeException)new PipeRuntimeConnectorCriticalException(throwable.getMessage() + ", root cause: " + ErrorHandlingUtils.getRootCause(throwable).getMessage()));
            LOGGER.warn("{} failed to handshake with the target system after {} times, stopping current subtask {} (creation time: {}, simple class: {}). Status shown when query the pipe will be 'STOPPED'. Please restart the task by executing 'START PIPE' manually if needed.", new Object[]{this.outputPipeConnector.getClass().getName(), 5, this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName(), throwable});
            return true;
        }
        return false;
    }

    public synchronized void submitSelf() {
        if (this.shouldStopSubmittingSelf.get() || this.isSubmitted) {
            return;
        }
        this.callbackDecoratingLock.markAsDecorating();
        try {
            ListenableFuture nextFuture = this.subtaskWorkerThreadPoolExecutor.submit((Callable)((Object)this));
            Futures.addCallback((ListenableFuture)nextFuture, (FutureCallback)this, (Executor)this.subtaskCallbackListeningExecutor);
            this.isSubmitted = true;
        }
        finally {
            this.callbackDecoratingLock.markAsDecorated();
        }
    }

    public void close() {
        PipeConnectorMetrics.getInstance().deregister(this.taskID);
        this.isClosed.set(true);
        try {
            this.outputPipeConnector.close();
        }
        catch (Exception e) {
            LOGGER.info("Exception occurred when closing pipe connector subtask {}, root cause: {}", new Object[]{this.taskID, ErrorHandlingUtils.getRootCause(e).getMessage(), e});
        }
        finally {
            this.inputPendingQueue.forEach(event -> {
                if (event instanceof EnrichedEvent) {
                    ((EnrichedEvent)event).clearReferenceCount(PipeEventCollector.class.getName());
                }
            });
            this.inputPendingQueue.clear();
            super.close();
        }
    }

    public void discardEventsOfPipe(String pipeNameToDrop) {
        if (this.outputPipeConnector instanceof IoTDBThriftAsyncConnector) {
            ((IoTDBThriftAsyncConnector)this.outputPipeConnector).discardEventsOfPipe(pipeNameToDrop);
        }
    }

    public String getAttributeSortedString() {
        return this.attributeSortedString;
    }

    public int getConnectorIndex() {
        return this.connectorIndex;
    }

    public int getTsFileInsertionEventCount() {
        return this.inputPendingQueue.getTsFileInsertionEventCount();
    }

    public int getTabletInsertionEventCount() {
        return this.inputPendingQueue.getTabletInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.inputPendingQueue.getPipeHeartbeatEventCount();
    }

    public int getAsyncConnectorRetryEventQueueSize() {
        return this.outputPipeConnector instanceof IoTDBThriftAsyncConnector ? ((IoTDBThriftAsyncConnector)this.outputPipeConnector).getRetryEventQueueSize() : 0;
    }
}

