/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.extractor.IoTDBDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeExtractorMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeExtractorMetrics.class);
    private AbstractMetricService metricService;
    private final Map<String, IoTDBDataRegionExtractor> extractorMap = new ConcurrentHashMap<String, IoTDBDataRegionExtractor>();
    private final Map<String, Rate> tabletRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> tsFileRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> pipeHeartbeatRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Gauge> recentProcessedTsFileEpochStateMap = new ConcurrentHashMap<String, Gauge>();

    public Map<String, IoTDBDataRegionExtractor> getExtractorMap() {
        return this.extractorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        PipeExtractorMetrics pipeExtractorMetrics = this;
        synchronized (pipeExtractorMetrics) {
            for (String taskID : this.extractorMap.keySet()) {
                this.createMetrics(taskID);
            }
        }
    }

    private void createMetrics(String taskID) {
        this.createAutoGauge(taskID);
        this.createRate(taskID);
        this.createGauge(taskID);
    }

    private void createAutoGauge(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.metricService.createAutoGauge(Metric.UNPROCESSED_HISTORICAL_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)extractor, IoTDBDataRegionExtractor::getHistoricalTsFileInsertionEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNPROCESSED_REALTIME_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)extractor, IoTDBDataRegionExtractor::getRealtimeTsFileInsertionEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNPROCESSED_TABLET_COUNT.toString(), MetricLevel.IMPORTANT, (Object)extractor, IoTDBDataRegionExtractor::getTabletInsertionEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNPROCESSED_HEARTBEAT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)extractor, IoTDBDataRegionExtractor::getPipeHeartbeatEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    private void createRate(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.tabletRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_EXTRACTOR_TABLET_SUPPLY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())}));
        this.tsFileRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_EXTRACTOR_TSFILE_SUPPLY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())}));
        this.pipeHeartbeatRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_EXTRACTOR_HEARTBEAT_SUPPLY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())}));
    }

    private void createGauge(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.recentProcessedTsFileEpochStateMap.put(taskID, this.metricService.getOrCreateGauge(Metric.PIPE_EXTRACTOR_TSFILE_EPOCH_STATE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())}));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet taskIDs = ImmutableSet.copyOf(this.extractorMap.keySet());
        for (String taskID : taskIDs) {
            this.deregister(taskID);
        }
        if (!this.extractorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe extractor metrics, extractor map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeAutoGauge(taskID);
        this.removeRate(taskID);
        this.removeGauge(taskID);
    }

    private void removeAutoGauge(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNPROCESSED_HISTORICAL_TSFILE_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNPROCESSED_REALTIME_TSFILE_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNPROCESSED_TABLET_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNPROCESSED_HEARTBEAT_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    private void removeRate(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.metricService.remove(MetricType.RATE, Metric.PIPE_EXTRACTOR_TABLET_SUPPLY.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_EXTRACTOR_TSFILE_SUPPLY.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_EXTRACTOR_HEARTBEAT_SUPPLY.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.tabletRateMap.remove(taskID);
        this.tsFileRateMap.remove(taskID);
        this.pipeHeartbeatRateMap.remove(taskID);
    }

    private void removeGauge(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.metricService.remove(MetricType.GAUGE, Metric.PIPE_EXTRACTOR_TSFILE_EPOCH_STATE.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getDataRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull IoTDBDataRegionExtractor extractor) {
        String taskID = extractor.getTaskID();
        PipeExtractorMetrics pipeExtractorMetrics = this;
        synchronized (pipeExtractorMetrics) {
            this.extractorMap.putIfAbsent(taskID, extractor);
            if (Objects.nonNull(this.metricService)) {
                this.createMetrics(taskID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String taskID) {
        PipeExtractorMetrics pipeExtractorMetrics = this;
        synchronized (pipeExtractorMetrics) {
            if (!this.extractorMap.containsKey(taskID)) {
                LOGGER.warn("Failed to deregister pipe extractor metrics, IoTDBDataRegionExtractor({}) does not exist", (Object)taskID);
                return;
            }
            if (Objects.nonNull(this.metricService)) {
                this.removeMetrics(taskID);
            }
            this.extractorMap.remove(taskID);
        }
    }

    public void markTabletEvent(String taskID) {
        Rate rate = this.tabletRateMap.get(taskID);
        if (rate == null) {
            LOGGER.warn("Failed to mark pipe extractor tablet event, IoTDBDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markTsFileEvent(String taskID) {
        Rate rate = this.tsFileRateMap.get(taskID);
        if (rate == null) {
            LOGGER.warn("Failed to mark pipe extractor tsfile event, IoTDBDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markPipeHeartbeatEvent(String taskID) {
        Rate rate = this.pipeHeartbeatRateMap.get(taskID);
        if (rate == null) {
            LOGGER.warn("Failed to mark pipe extractor heartbeat event, IoTDBDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void setRecentProcessedTsFileEpochState(String taskID, TsFileEpoch.State state) {
        Gauge gauge = this.recentProcessedTsFileEpochStateMap.get(taskID);
        if (gauge == null) {
            LOGGER.warn("Failed to set recent processed tsfile epoch state, PipeRealtimeDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        gauge.set((long)state.getId());
    }

    public static PipeExtractorMetrics getInstance() {
        return PipeExtractorMetricsHolder.INSTANCE;
    }

    private PipeExtractorMetrics() {
    }

    private static class PipeExtractorMetricsHolder {
        private static final PipeExtractorMetrics INSTANCE = new PipeExtractorMetrics();

        private PipeExtractorMetricsHolder() {
        }
    }
}

