/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.task.subtask.connector.PipeConnectorSubtask;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConnectorMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConnectorMetrics.class);
    private AbstractMetricService metricService;
    private final Map<String, PipeConnectorSubtask> connectorMap = new HashMap<String, PipeConnectorSubtask>();
    private final Map<String, Rate> tabletRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> tsFileRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> pipeHeartbeatRateMap = new ConcurrentHashMap<String, Rate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        PipeConnectorMetrics pipeConnectorMetrics = this;
        synchronized (pipeConnectorMetrics) {
            for (String taskID : this.connectorMap.keySet()) {
                this.createMetrics(taskID);
            }
        }
    }

    private void createMetrics(String taskID) {
        this.createAutoGauge(taskID);
        this.createRate(taskID);
    }

    private void createAutoGauge(String taskID) {
        PipeConnectorSubtask connector = this.connectorMap.get(taskID);
        this.metricService.createAutoGauge(Metric.UNTRANSFERRED_TABLET_COUNT.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeConnectorSubtask::getTabletInsertionEventCount, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNTRANSFERRED_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeConnectorSubtask::getTsFileInsertionEventCount, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNTRANSFERRED_HEARTBEAT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeConnectorSubtask::getPipeHeartbeatEventCount, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_ASYNC_CONNECTOR_RETRY_EVENT_QUEUE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeConnectorSubtask::getAsyncConnectorRetryEventQueueSize, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
    }

    private void createRate(String taskID) {
        PipeConnectorSubtask connector = this.connectorMap.get(taskID);
        this.tabletRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_CONNECTOR_TABLET_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())}));
        this.tsFileRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_CONNECTOR_TSFILE_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())}));
        this.pipeHeartbeatRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_CONNECTOR_HEARTBEAT_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())}));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet taskIDs = ImmutableSet.copyOf(this.connectorMap.keySet());
        for (String taskID : taskIDs) {
            this.deregister(taskID);
        }
        if (!this.connectorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe connector metrics, connector map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeAutoGauge(taskID);
        this.removeRate(taskID);
    }

    private void removeAutoGauge(String taskID) {
        PipeConnectorSubtask connector = this.connectorMap.get(taskID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNTRANSFERRED_TABLET_COUNT.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNTRANSFERRED_TSFILE_COUNT.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNTRANSFERRED_HEARTBEAT_COUNT.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_ASYNC_CONNECTOR_RETRY_EVENT_QUEUE_SIZE.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
    }

    private void removeRate(String taskID) {
        PipeConnectorSubtask connector = this.connectorMap.get(taskID);
        this.metricService.remove(MetricType.RATE, Metric.PIPE_CONNECTOR_TABLET_TRANSFER.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_CONNECTOR_TSFILE_TRANSFER.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_CONNECTOR_HEARTBEAT_TRANSFER.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.tabletRateMap.remove(taskID);
        this.tsFileRateMap.remove(taskID);
        this.pipeHeartbeatRateMap.remove(taskID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull PipeConnectorSubtask pipeConnectorSubtask) {
        String taskID = pipeConnectorSubtask.getTaskID();
        PipeConnectorMetrics pipeConnectorMetrics = this;
        synchronized (pipeConnectorMetrics) {
            this.connectorMap.putIfAbsent(taskID, pipeConnectorSubtask);
            if (Objects.nonNull(this.metricService)) {
                this.createMetrics(taskID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String taskID) {
        PipeConnectorMetrics pipeConnectorMetrics = this;
        synchronized (pipeConnectorMetrics) {
            if (!this.connectorMap.containsKey(taskID)) {
                LOGGER.warn("Failed to deregister pipe connector metrics, PipeConnectorSubtask({}) does not exist", (Object)taskID);
                return;
            }
            if (Objects.nonNull(this.metricService)) {
                this.removeMetrics(taskID);
            }
            this.connectorMap.remove(taskID);
        }
    }

    public void markTabletEvent(String taskID) {
        Rate rate = this.tabletRateMap.get(taskID);
        if (rate == null) {
            LOGGER.warn("Failed to mark pipe connector tablet event, PipeConnectorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markTsFileEvent(String taskID) {
        Rate rate = this.tsFileRateMap.get(taskID);
        if (rate == null) {
            LOGGER.warn("Failed to mark pipe connector tsfile event, PipeConnectorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markPipeHeartbeatEvent(String taskID) {
        Rate rate = this.pipeHeartbeatRateMap.get(taskID);
        if (rate == null) {
            LOGGER.warn("Failed to mark pipe connector heartbeat event, PipeConnectorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public static PipeConnectorMetrics getInstance() {
        return PipeConnectorMetricsHolder.INSTANCE;
    }

    private PipeConnectorMetrics() {
    }

    private static class PipeConnectorMetricsHolder {
        private static final PipeConnectorMetrics INSTANCE = new PipeConnectorMetrics();

        private PipeConnectorMetricsHolder() {
        }
    }
}

