/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.heartbeat;

import com.lmax.disruptor.RingBuffer;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionHybridExtractor;
import org.apache.iotdb.db.pipe.metric.PipeHeartbeatEventMetrics;
import org.apache.iotdb.db.pipe.task.connection.EnrichedDeque;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatEvent
extends EnrichedEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatEvent.class);
    private final String dataRegionId;
    private String pipeName;
    private PipeRealtimeDataRegionExtractor extractor = null;
    private long timePublished;
    private long timeAssigned;
    private long timeProcessed;
    private long timeTransferred;
    private int disruptorSize;
    private int extractorQueueTabletSize;
    private int extractorQueueTsFileSize;
    private int extractorQueueSize;
    private int bufferQueueTabletSize;
    private int bufferQueueTsFileSize;
    private int bufferQueueSize;
    private int connectorQueueTabletSize;
    private int connectorQueueTsFileSize;
    private int connectorQueueSize;
    private final boolean shouldPrintMessage;

    public PipeHeartbeatEvent(String dataRegionId, boolean shouldPrintMessage) {
        super(null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
        this.dataRegionId = dataRegionId;
        this.shouldPrintMessage = shouldPrintMessage;
    }

    public PipeHeartbeatEvent(String pipeName, PipeTaskMeta pipeTaskMeta, String dataRegionId, long timePublished, boolean shouldPrintMessage) {
        super(pipeName, pipeTaskMeta, null, Long.MIN_VALUE, Long.MAX_VALUE);
        this.dataRegionId = dataRegionId;
        this.timePublished = timePublished;
        this.shouldPrintMessage = shouldPrintMessage;
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        if (this.shouldPrintMessage && this.pipeName != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.toString());
        }
        return true;
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return MinimumProgressIndex.INSTANCE;
    }

    @Override
    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        return new PipeHeartbeatEvent(pipeName, pipeTaskMeta, this.dataRegionId, this.timePublished, this.shouldPrintMessage);
    }

    @Override
    public boolean isGeneratedByPipe() {
        return false;
    }

    @Override
    public boolean mayEventTimeOverlappedWithTimeRange() {
        return true;
    }

    public boolean isShouldPrintMessage() {
        return this.shouldPrintMessage;
    }

    public void bindPipeName(String pipeName) {
        if (this.shouldPrintMessage) {
            this.pipeName = pipeName;
        }
    }

    public void onPublished() {
        if (this.shouldPrintMessage) {
            this.timePublished = System.currentTimeMillis();
        }
    }

    public void onAssigned() {
        if (this.shouldPrintMessage) {
            this.timeAssigned = System.currentTimeMillis();
            if (this.timePublished != 0L) {
                PipeHeartbeatEventMetrics.getInstance().recordPublishedToAssignedTime(this.timeAssigned - this.timePublished);
            }
        }
    }

    public void onProcessed() {
        if (this.shouldPrintMessage) {
            this.timeProcessed = System.currentTimeMillis();
            if (this.timeAssigned != 0L) {
                PipeHeartbeatEventMetrics.getInstance().recordAssignedToProcessedTime(this.timeProcessed - this.timeAssigned);
            }
        }
    }

    public void onTransferred() {
        if (this.shouldPrintMessage) {
            this.timeTransferred = System.currentTimeMillis();
            if (this.timeProcessed != 0L) {
                PipeHeartbeatEventMetrics.getInstance().recordProcessedToTransferredTime(this.timeTransferred - this.timeProcessed);
            }
        }
    }

    public void recordDisruptorSize(RingBuffer<?> ringBuffer) {
        if (this.shouldPrintMessage) {
            this.disruptorSize = ringBuffer.getBufferSize() - (int)ringBuffer.remainingCapacity();
        }
    }

    public void recordExtractorQueueSize(UnboundedBlockingPendingQueue<Event> pendingQueue) {
        if (this.shouldPrintMessage) {
            this.extractorQueueTabletSize = pendingQueue.getTabletInsertionEventCount();
            this.extractorQueueTsFileSize = pendingQueue.getTsFileInsertionEventCount();
            this.extractorQueueSize = pendingQueue.size();
        }
    }

    public void recordBufferQueueSize(EnrichedDeque<Event> bufferQueue) {
        if (this.shouldPrintMessage) {
            this.bufferQueueTabletSize = bufferQueue.getTabletInsertionEventCount();
            this.bufferQueueTsFileSize = bufferQueue.getTsFileInsertionEventCount();
            this.bufferQueueSize = bufferQueue.size();
        }
        if (this.extractor instanceof PipeRealtimeDataRegionHybridExtractor) {
            ((PipeRealtimeDataRegionHybridExtractor)this.extractor).informProcessorEventCollectorQueueTsFileSize(bufferQueue.getTsFileInsertionEventCount());
        }
    }

    public void recordConnectorQueueSize(BoundedBlockingPendingQueue<Event> pendingQueue) {
        if (this.shouldPrintMessage) {
            this.connectorQueueTabletSize = pendingQueue.getTabletInsertionEventCount();
            this.connectorQueueTsFileSize = pendingQueue.getTsFileInsertionEventCount();
            this.connectorQueueSize = pendingQueue.size();
        }
        if (this.extractor instanceof PipeRealtimeDataRegionHybridExtractor) {
            ((PipeRealtimeDataRegionHybridExtractor)this.extractor).informConnectorInputPendingQueueTsFileSize(pendingQueue.getTsFileInsertionEventCount());
        }
    }

    public void bindExtractor(PipeRealtimeDataRegionExtractor extractor) {
        this.extractor = extractor;
    }

    @Override
    public String toString() {
        String unknownMessage = "Unknown";
        String startTimeMessage = this.timePublished != 0L ? DateTimeUtils.convertLongToDate(this.timePublished, "ms") : "Unknown";
        String publishedToAssignedMessage = this.timeAssigned != 0L && this.timePublished != 0L ? this.timeAssigned - this.timePublished + "ms" : "Unknown";
        String assignedToProcessedMessage = this.timeProcessed != 0L && this.timeAssigned != 0L ? this.timeProcessed - this.timeAssigned + "ms" : "Unknown";
        String processedToTransferredMessage = this.timeTransferred != 0L && this.timeProcessed != 0L ? this.timeTransferred - this.timeProcessed + "ms" : "Unknown";
        String totalTimeMessage = this.timeTransferred != 0L && this.timePublished != 0L ? this.timeTransferred - this.timePublished + "ms" : "Unknown";
        String disruptorSizeMessage = Integer.toString(this.disruptorSize);
        String extractorQueueTabletSizeMessage = this.timeAssigned != 0L ? Integer.toString(this.extractorQueueTabletSize) : "Unknown";
        String extractorQueueTsFileSizeMessage = this.timeAssigned != 0L ? Integer.toString(this.extractorQueueTsFileSize) : "Unknown";
        String extractorQueueSizeMessage = this.timeAssigned != 0L ? Integer.toString(this.extractorQueueSize) : "Unknown";
        String bufferQueueTabletSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.bufferQueueTabletSize) : "Unknown";
        String bufferQueueTsFileSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.bufferQueueTsFileSize) : "Unknown";
        String bufferQueueSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.bufferQueueSize) : "Unknown";
        String connectorQueueTabletSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.connectorQueueTabletSize) : "Unknown";
        String connectorQueueTsFileSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.connectorQueueTsFileSize) : "Unknown";
        String connectorQueueSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.connectorQueueSize) : "Unknown";
        return "PipeHeartbeatEvent{pipeName='" + this.pipeName + "', dataRegionId=" + this.dataRegionId + ", startTime=" + startTimeMessage + ", publishedToAssigned=" + publishedToAssignedMessage + ", assignedToProcessed=" + assignedToProcessedMessage + ", processedToTransferred=" + processedToTransferredMessage + ", totalTimeCost=" + totalTimeMessage + ", disruptorSize=" + disruptorSizeMessage + ", extractorQueueTabletSize=" + extractorQueueTabletSizeMessage + ", extractorQueueTsFileSize=" + extractorQueueTsFileSizeMessage + ", extractorQueueSize=" + extractorQueueSizeMessage + ", bufferQueueTabletSize=" + bufferQueueTabletSizeMessage + ", bufferQueueTsFileSize=" + bufferQueueTsFileSizeMessage + ", bufferQueueSize=" + bufferQueueSizeMessage + ", connectorQueueTabletSize=" + connectorQueueTabletSizeMessage + ", connectorQueueTsFileSize=" + connectorQueueTsFileSizeMessage + ", connectorQueueSize=" + connectorQueueSizeMessage + "}";
    }
}

