/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.airgap;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.IoTDBConnector;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.airgap.AirGapELanguageConstant;
import org.apache.iotdb.db.pipe.connector.payload.airgap.AirGapOneByteResponse;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferFileSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferHandshakeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBAirGapConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBAirGapConnector.class);
    private static final PipeConfig PIPE_CONFIG = PipeConfig.getInstance();
    private final List<Socket> sockets = new ArrayList<Socket>();
    private final List<Boolean> isSocketAlive = new ArrayList<Boolean>();
    private int handshakeTimeoutMs;
    private boolean eLanguageEnable;
    private long currentClientIndex = 0L;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        IoTDBConfig ioTDBConfig = IoTDBDescriptor.getInstance().getConfig();
        PipeConfig pipeConfig = PipeConfig.getInstance();
        Set givenNodeUrls = this.parseNodeUrls(validator.getParameters());
        validator.validate(empty -> {
            try {
                return !pipeConfig.getPipeAirGapReceiverEnabled() || !NodeUrlUtils.containsLocalAddress(givenNodeUrls.stream().filter(tEndPoint -> tEndPoint.getPort() == pipeConfig.getPipeAirGapReceiverPort()).map(TEndPoint::getIp).collect(Collectors.toList()));
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Unknown host when checking pipe sink IP.", (Throwable)e);
                return false;
            }
        }, String.format("One of the endpoints %s of the receivers is pointing back to the air gap receiver %s on sender itself, or unknown host when checking pipe sink IP.", givenNodeUrls, new TEndPoint(ioTDBConfig.getRpcAddress(), pipeConfig.getPipeAirGapReceiverPort())), new Object[0]);
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        if (this.isTabletBatchModeEnabled) {
            LOGGER.warn("Batch mode is enabled by the given parameters. IoTDBAirGapConnector does not support batch mode. Disable batch mode.");
        }
        for (int i = 0; i < this.nodeUrls.size(); ++i) {
            this.isSocketAlive.add(false);
            this.sockets.add(null);
        }
        this.handshakeTimeoutMs = parameters.getIntOrDefault(Arrays.asList("connector.air-gap.handshake-timeout-ms", "sink.air-gap.handshake-timeout-ms"), 5000);
        LOGGER.info("IoTDBAirGapConnector is customized with handshakeTimeoutMs: {}.", (Object)this.handshakeTimeoutMs);
        this.eLanguageEnable = parameters.getBooleanOrDefault(Arrays.asList("connector.air-gap.e-language.enable", "sink.air-gap.e-language.enable"), false);
        LOGGER.info("IoTDBAirGapConnector is customized with eLanguageEnable: {}.", (Object)this.eLanguageEnable);
    }

    public void handshake() throws Exception {
        int i;
        for (i = 0; i < this.sockets.size(); ++i) {
            if (Boolean.TRUE.equals(this.isSocketAlive.get(i))) continue;
            String ip = ((TEndPoint)this.nodeUrls.get(i)).getIp();
            int port = ((TEndPoint)this.nodeUrls.get(i)).getPort();
            if (this.sockets.get(i) != null) {
                try {
                    ((Socket)this.sockets.set(i, null)).close();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close socket with target server ip: {}, port: {}, because: {}. Ignore it.", new Object[]{ip, port, e.getMessage()});
                }
            }
            Socket socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(ip, port), this.handshakeTimeoutMs);
                socket.setKeepAlive(true);
                socket.setSoTimeout(this.handshakeTimeoutMs);
                this.sockets.set(i, socket);
                LOGGER.info("Successfully connected to target server ip: {}, port: {}.", (Object)ip, (Object)port);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to connect to target server ip: {}, port: {}, because: {}. Ignore it.", new Object[]{ip, port, e.getMessage()});
                continue;
            }
            if (!this.send(socket, PipeTransferHandshakeReq.toTransferHandshakeBytes(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()))) {
                throw new PipeException("Handshake error with target server ip: " + ip + ", port: " + port);
            }
            this.isSocketAlive.set(i, true);
            socket.setSoTimeout((int)PIPE_CONFIG.getPipeConnectorTransferTimeoutMs());
            LOGGER.info("Handshake success. Target server ip: {}, port: {}", (Object)ip, (Object)port);
        }
        for (i = 0; i < this.sockets.size(); ++i) {
            if (!Boolean.TRUE.equals(this.isSocketAlive.get(i))) continue;
            return;
        }
        throw new PipeConnectionException(String.format("All target servers %s are not available.", this.nodeUrls));
    }

    public void heartbeat() {
        try {
            this.handshake();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to reconnect to target server, because: {}. Try to reconnect later.", (Object)e.getMessage(), (Object)e);
        }
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBAirGapConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Ignore {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (((EnrichedEvent)tabletInsertionEvent).shouldParsePatternOrTime()) {
            if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.transfer(((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).parseEventWithPatternOrTime());
            } else {
                this.transfer(((PipeRawTabletInsertionEvent)tabletInsertionEvent).parseEventWithPatternOrTime());
            }
            return;
        }
        if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent && ((PipeRawTabletInsertionEvent)tabletInsertionEvent).hasNoNeedParsingAndIsEmpty()) {
            return;
        }
        int socketIndex = this.nextSocketIndex();
        Socket socket = this.sockets.get(socketIndex);
        try {
            if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.doTransfer(socket, (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
            } else {
                this.doTransfer(socket, (PipeRawTabletInsertionEvent)tabletInsertionEvent);
            }
        }
        catch (IOException e) {
            this.isSocketAlive.set(socketIndex, false);
            throw new PipeConnectionException(String.format("Network error when transfer tablet insertion event %s, because %s.", tabletInsertionEvent, e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBAirGapConnector only support PipeTsFileInsertionEvent. Ignore {}.", (Object)tsFileInsertionEvent);
            return;
        }
        if (!((PipeTsFileInsertionEvent)tsFileInsertionEvent).waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)((PipeTsFileInsertionEvent)tsFileInsertionEvent).getTsFile());
            return;
        }
        if (((EnrichedEvent)tsFileInsertionEvent).shouldParsePatternOrTime()) {
            try {
                for (TabletInsertionEvent event : tsFileInsertionEvent.toTabletInsertionEvents()) {
                    this.transfer(event);
                }
            }
            finally {
                tsFileInsertionEvent.close();
            }
            return;
        }
        int socketIndex = this.nextSocketIndex();
        Socket socket = this.sockets.get(socketIndex);
        try {
            this.doTransfer(socket, (PipeTsFileInsertionEvent)tsFileInsertionEvent);
        }
        catch (IOException e) {
            this.isSocketAlive.set(socketIndex, false);
            throw new PipeConnectionException(String.format("Network error when transfer tsfile insertion event %s, because %s.", tsFileInsertionEvent, e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(Event event) {
        if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("IoTDBAirGapConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    private void doTransfer(Socket socket, PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException, WALPipeException, IOException {
        byte[] bytes;
        InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
        byte[] byArray = bytes = Objects.isNull(insertNode) ? PipeTransferTabletBinaryReq.toTransferInsertNodeBytes(pipeInsertNodeTabletInsertionEvent.getByteBuffer()) : PipeTransferTabletInsertNodeReq.toTransferInsertNodeBytes(insertNode);
        if (!this.send(socket, bytes)) {
            throw new PipeException(String.format("Transfer PipeInsertNodeTabletInsertionEvent %s error. Socket: %s", pipeInsertNodeTabletInsertionEvent, socket));
        }
    }

    private void doTransfer(Socket socket, PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException, IOException {
        if (!this.send(socket, PipeTransferTabletRawReq.toTPipeTransferTabletBytes(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned()))) {
            throw new PipeException(String.format("Transfer PipeRawTabletInsertionEvent %s error. Socket: %s.", pipeRawTabletInsertionEvent, socket));
        }
    }

    private void doTransfer(Socket socket, PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, IOException {
        File tsFile = pipeTsFileInsertionEvent.getTsFile();
        int readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
        byte[] readBuffer = new byte[readFileBufferSize];
        long position = 0L;
        try (RandomAccessFile reader = new RandomAccessFile(tsFile, "r");){
            int readLength;
            while ((readLength = reader.read(readBuffer)) != -1) {
                if (!this.send(socket, PipeTransferFilePieceReq.toTPipeTransferBytes(tsFile.getName(), position, readLength == readFileBufferSize ? readBuffer : Arrays.copyOfRange(readBuffer, 0, readLength)))) {
                    throw new PipeException(String.format("Transfer file %s error. Socket %s.", tsFile, socket));
                }
                position += (long)readLength;
            }
        }
        if (!this.send(socket, PipeTransferFileSealReq.toTPipeTransferFileSealBytes(tsFile.getName(), tsFile.length()))) {
            throw new PipeException(String.format("Seal file %s error. Socket %s.", tsFile, socket));
        }
        LOGGER.info("Successfully transferred file {}.", (Object)tsFile);
    }

    private int nextSocketIndex() {
        int socketSize = this.sockets.size();
        for (int tryCount = 0; tryCount < socketSize; ++tryCount) {
            int clientIndex;
            if (!Boolean.TRUE.equals(this.isSocketAlive.get(clientIndex = (int)(this.currentClientIndex++ % (long)socketSize)))) continue;
            return clientIndex;
        }
        throw new PipeConnectionException("All sockets are dead, please check the connection to the receiver.");
    }

    private boolean send(Socket socket, byte[] bytes) throws IOException {
        if (!socket.isConnected()) {
            return false;
        }
        BufferedOutputStream outputStream = new BufferedOutputStream(socket.getOutputStream());
        bytes = this.enrichWithLengthAndChecksum(bytes);
        outputStream.write(this.eLanguageEnable ? this.enrichWithELanguage(bytes) : bytes);
        outputStream.flush();
        byte[] response = new byte[1];
        int size = socket.getInputStream().read(response);
        return size > 0 && Arrays.equals(AirGapOneByteResponse.OK, response);
    }

    private byte[] enrichWithLengthAndChecksum(byte[] bytes) {
        byte[] length = BytesUtils.intToBytes((int)(bytes.length + 8));
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, bytes.length);
        return BytesUtils.concatByteArrayList(Arrays.asList(length, length, BytesUtils.longToBytes((long)crc32.getValue()), bytes));
    }

    private byte[] enrichWithELanguage(byte[] bytes) {
        return BytesUtils.concatByteArrayList(Arrays.asList(AirGapELanguageConstant.E_LANGUAGE_PREFIX, bytes, AirGapELanguageConstant.E_LANGUAGE_SUFFIX));
    }

    public void close() {
        for (int i = 0; i < this.sockets.size(); ++i) {
            try {
                if (this.sockets.get(i) == null) continue;
                ((Socket)this.sockets.set(i, null)).close();
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close client {}.", (Object)i, (Object)e);
                continue;
            }
            finally {
                this.isSocketAlive.set(i, false);
            }
        }
    }
}

