/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.datastructure.BackAlignedTVList;
import org.apache.iotdb.db.utils.datastructure.QuickAlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.utils.datastructure.TimAlignedTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public abstract class AlignedTVList
extends TVList {
    protected List<TSDataType> dataTypes;
    protected long[] memoryBinaryChunkSize;
    protected List<List<Object>> values;
    protected List<int[]> indices;
    protected List<List<BitMap>> bitMaps;
    boolean reachMaxChunkSizeFlag;
    BitMap rowBitMap;

    AlignedTVList(List<TSDataType> types) {
        this.indices = new ArrayList<int[]>(types.size());
        this.dataTypes = types;
        this.memoryBinaryChunkSize = new long[this.dataTypes.size()];
        this.reachMaxChunkSizeFlag = false;
        this.values = new ArrayList<List<Object>>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            this.values.add(new ArrayList());
        }
    }

    public static AlignedTVList newAlignedList(List<TSDataType> dataTypes) {
        switch (PrimitiveArrayManager.TVLIST_SORT_ALGORITHM) {
            case QUICK: {
                return new QuickAlignedTVList(dataTypes);
            }
            case BACKWARD: {
                return new BackAlignedTVList(dataTypes);
            }
        }
        return new TimAlignedTVList(dataTypes);
    }

    @Override
    public TVList getTvListByColumnIndex(List<Integer> columnIndex, List<TSDataType> dataTypeList) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        ArrayList<List<BitMap>> bitMaps = null;
        for (int i = 0; i < columnIndex.size(); ++i) {
            if (columnIndex.get(i) == -1) {
                values.add(null);
                continue;
            }
            values.add(this.values.get(columnIndex.get(i)));
            if (this.bitMaps == null || this.bitMaps.get(columnIndex.get(i)) == null) continue;
            if (bitMaps == null) {
                bitMaps = new ArrayList<List<BitMap>>(columnIndex.size());
                for (int j = 0; j < columnIndex.size(); ++j) {
                    bitMaps.add(null);
                }
            }
            bitMaps.set(i, this.bitMaps.get(columnIndex.get(i)));
        }
        AlignedTVList alignedTvList = AlignedTVList.newAlignedList(dataTypeList);
        alignedTvList.timestamps = this.timestamps;
        alignedTvList.indices = this.indices;
        alignedTvList.values = values;
        alignedTvList.bitMaps = bitMaps;
        alignedTvList.rowCount = this.rowCount;
        alignedTvList.rowBitMap = this.getRowBitMap();
        return alignedTvList;
    }

    @Override
    public AlignedTVList clone() {
        AlignedTVList cloneList = AlignedTVList.newAlignedList(this.dataTypes);
        this.cloneAs(cloneList);
        System.arraycopy(this.memoryBinaryChunkSize, 0, cloneList.memoryBinaryChunkSize, 0, this.dataTypes.size());
        for (int[] indicesArray : this.indices) {
            cloneList.indices.add(this.cloneIndex(indicesArray));
        }
        for (int i = 0; i < this.values.size(); ++i) {
            List<Object> columnValues = this.values.get(i);
            for (Object valueArray : columnValues) {
                cloneList.values.get(i).add(this.cloneValue(this.dataTypes.get(i), valueArray));
            }
            if (this.bitMaps == null || this.bitMaps.get(i) == null) continue;
            List<BitMap> columnBitMaps = this.bitMaps.get(i);
            if (cloneList.bitMaps == null) {
                cloneList.bitMaps = new ArrayList<List<BitMap>>(this.dataTypes.size());
                for (int j = 0; j < this.dataTypes.size(); ++j) {
                    cloneList.bitMaps.add(null);
                }
            }
            if (cloneList.bitMaps.get(i) != null) continue;
            ArrayList<BitMap> cloneColumnBitMaps = new ArrayList<BitMap>();
            for (BitMap bitMap : columnBitMaps) {
                cloneColumnBitMaps.add(bitMap == null ? null : bitMap.clone());
            }
            cloneList.bitMaps.set(i, cloneColumnBitMaps);
        }
        return cloneList;
    }

    @Override
    public void putAlignedValue(long timestamp, Object[] value) {
        this.checkExpansion();
        int arrayIndex = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
        this.maxTime = Math.max(this.maxTime, timestamp);
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        block8: for (int i = 0; i < this.values.size(); ++i) {
            Object columnValue = value[i];
            List<Object> columnValues = this.values.get(i);
            if (columnValue == null) {
                this.markNullValue(i, arrayIndex, elementIndex);
            }
            switch (this.dataTypes.get(i)) {
                case TEXT: {
                    ((Binary[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? (Binary)columnValue : Binary.EMPTY_VALUE;
                    int n = i;
                    this.memoryBinaryChunkSize[n] = this.memoryBinaryChunkSize[n] + (columnValue != null ? MemUtils.getBinarySize((Binary)columnValue) : MemUtils.getBinarySize(Binary.EMPTY_VALUE));
                    if (this.memoryBinaryChunkSize[i] < targetChunkSize) continue block8;
                    this.reachMaxChunkSizeFlag = true;
                    continue block8;
                }
                case FLOAT: {
                    ((float[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? ((Float)columnValue).floatValue() : Float.MIN_VALUE;
                    continue block8;
                }
                case INT32: {
                    ((int[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? (Integer)columnValue : Integer.MIN_VALUE;
                    continue block8;
                }
                case INT64: {
                    ((long[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? (Long)columnValue : Long.MIN_VALUE;
                    continue block8;
                }
                case DOUBLE: {
                    ((double[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? (Double)columnValue : Double.MIN_VALUE;
                    continue block8;
                }
                case BOOLEAN: {
                    ((boolean[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null && (Boolean)columnValue != false;
                    continue block8;
                }
            }
        }
        this.indices.get((int)arrayIndex)[elementIndex] = this.rowCount++;
        if (this.sorted && this.rowCount > 1 && timestamp < this.getTime(this.rowCount - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public Object getAlignedValue(int index) {
        return this.getAlignedValueForQuery(index, null, null);
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        throw new UnsupportedOperationException("DataType not consistent");
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), (TsPrimitiveType)this.getAlignedValueForQuery(index, null, null));
    }

    private Object getAlignedValueForQuery(int index, Integer floatPrecision, List<TSEncoding> encodingList) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        int valueIndex = this.indices.get(arrayIndex)[elementIndex];
        return this.getAlignedValueByValueIndex(valueIndex, null, floatPrecision, encodingList);
    }

    private TsPrimitiveType getAlignedValueByValueIndex(int valueIndex, int[] validIndexesForTimeDuplicatedRows, Integer floatPrecision, List<TSEncoding> encodingList) {
        if (valueIndex >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(valueIndex);
        }
        TsPrimitiveType[] vector = new TsPrimitiveType[this.values.size()];
        block8: for (int columnIndex = 0; columnIndex < this.values.size(); ++columnIndex) {
            List<Object> columnValues = this.values.get(columnIndex);
            int validValueIndex = validIndexesForTimeDuplicatedRows != null ? validIndexesForTimeDuplicatedRows[columnIndex] : valueIndex;
            int arrayIndex = validValueIndex / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIndex = validValueIndex % PrimitiveArrayManager.ARRAY_SIZE;
            if (columnValues == null || this.isNullValue(validValueIndex, columnIndex)) continue;
            switch (this.dataTypes.get(columnIndex)) {
                case TEXT: {
                    Binary valueT = ((Binary[])columnValues.get(arrayIndex))[elementIndex];
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)valueT);
                    continue block8;
                }
                case FLOAT: {
                    float valueF = ((float[])columnValues.get(arrayIndex))[elementIndex];
                    if (!(floatPrecision == null || encodingList == null || Float.isNaN(valueF) || encodingList.get(columnIndex) != TSEncoding.RLE && encodingList.get(columnIndex) != TSEncoding.TS_2DIFF)) {
                        valueF = MathUtils.roundWithGivenPrecision(valueF, (int)floatPrecision);
                    }
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(valueF));
                    continue block8;
                }
                case INT32: {
                    int valueI = ((int[])columnValues.get(arrayIndex))[elementIndex];
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)valueI);
                    continue block8;
                }
                case INT64: {
                    long valueL = ((long[])columnValues.get(arrayIndex))[elementIndex];
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)valueL);
                    continue block8;
                }
                case DOUBLE: {
                    double valueD = ((double[])columnValues.get(arrayIndex))[elementIndex];
                    if (!(floatPrecision == null || encodingList == null || Double.isNaN(valueD) || encodingList.get(columnIndex) != TSEncoding.RLE && encodingList.get(columnIndex) != TSEncoding.TS_2DIFF)) {
                        valueD = MathUtils.roundWithGivenPrecision(valueD, (int)floatPrecision);
                    }
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)valueD);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean valueB = ((boolean[])columnValues.get(arrayIndex))[elementIndex];
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.BOOLEAN, (Object)valueB);
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("DataType not consistent");
                }
            }
        }
        return TsPrimitiveType.getByType((TSDataType)TSDataType.VECTOR, (Object)vector);
    }

    public void extendColumn(TSDataType dataType) {
        if (this.bitMaps == null) {
            this.bitMaps = new ArrayList<List<BitMap>>(this.values.size());
            for (int i = 0; i < this.values.size(); ++i) {
                this.bitMaps.add(null);
            }
        }
        ArrayList<Object> columnValue = new ArrayList<Object>();
        ArrayList<BitMap> columnBitMaps = new ArrayList<BitMap>();
        for (int i = 0; i < this.timestamps.size(); ++i) {
            switch (dataType) {
                case TEXT: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.TEXT));
                    break;
                }
                case FLOAT: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.FLOAT));
                    break;
                }
                case INT32: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.INT32));
                    break;
                }
                case INT64: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.INT64));
                    break;
                }
                case DOUBLE: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.DOUBLE));
                    break;
                }
                case BOOLEAN: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.BOOLEAN));
                    break;
                }
            }
            BitMap bitMap = new BitMap(PrimitiveArrayManager.ARRAY_SIZE);
            if (i == this.timestamps.size() - 1 && this.rowCount % PrimitiveArrayManager.ARRAY_SIZE != 0) {
                for (int j = 0; j < this.rowCount % PrimitiveArrayManager.ARRAY_SIZE; ++j) {
                    bitMap.mark(j);
                }
            } else {
                bitMap.markAll();
            }
            columnBitMaps.add(bitMap);
        }
        this.bitMaps.add(columnBitMaps);
        this.values.add(columnValue);
        this.dataTypes.add(dataType);
        long[] tmpValueChunkRawSize = this.memoryBinaryChunkSize;
        this.memoryBinaryChunkSize = new long[this.dataTypes.size()];
        System.arraycopy(tmpValueChunkRawSize, 0, this.memoryBinaryChunkSize, 0, tmpValueChunkRawSize.length);
    }

    public int getIntByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((int[])columnValues.get(arrayIndex))[elementIndex];
    }

    public long getLongByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((long[])columnValues.get(arrayIndex))[elementIndex];
    }

    public float getFloatByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((float[])columnValues.get(arrayIndex))[elementIndex];
    }

    public double getDoubleByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((double[])columnValues.get(arrayIndex))[elementIndex];
    }

    public Binary getBinaryByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((Binary[])columnValues.get(arrayIndex))[elementIndex];
    }

    public boolean getBooleanByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((boolean[])columnValues.get(arrayIndex))[elementIndex];
    }

    public boolean isNullValue(int rowIndex, int columnIndex) {
        if (rowIndex >= this.rowCount) {
            return false;
        }
        if (this.values.get(columnIndex) == null) {
            return true;
        }
        if (this.bitMaps == null || this.bitMaps.get(columnIndex) == null || this.bitMaps.get(columnIndex).get(rowIndex / PrimitiveArrayManager.ARRAY_SIZE) == null) {
            return false;
        }
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<BitMap> columnBitMaps = this.bitMaps.get(columnIndex);
        return columnBitMaps.get(arrayIndex).isMarked(elementIndex);
    }

    public List<List<Object>> getValues() {
        return this.values;
    }

    public List<TSDataType> getTsDataTypes() {
        return this.dataTypes;
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        int deletedNumber = 0;
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            deletedNumber += ((Integer)this.delete((long)lowerBound, (long)upperBound, (int)i).left).intValue();
        }
        return deletedNumber;
    }

    public Pair<Integer, Boolean> delete(long lowerBound, long upperBound, int columnIndex) {
        int deletedNumber = 0;
        boolean deleteColumn = true;
        for (int i = 0; i < this.rowCount; ++i) {
            long time = this.getTime(i);
            if (time >= lowerBound && time <= upperBound) {
                Binary value;
                int originRowIndex = this.getValueIndex(i);
                int arrayIndex = originRowIndex / PrimitiveArrayManager.ARRAY_SIZE;
                int elementIndex = originRowIndex % PrimitiveArrayManager.ARRAY_SIZE;
                if (this.dataTypes.get(columnIndex) == TSDataType.TEXT && (value = ((Binary[])this.values.get(columnIndex).get(arrayIndex))[elementIndex]) != null) {
                    int n = columnIndex;
                    this.memoryBinaryChunkSize[n] = this.memoryBinaryChunkSize[n] - MemUtils.getBinarySize(value);
                }
                this.markNullValue(columnIndex, arrayIndex, elementIndex);
                ++deletedNumber;
                continue;
            }
            deleteColumn = false;
        }
        return new Pair((Object)deletedNumber, (Object)deleteColumn);
    }

    public void deleteColumn(int columnIndex) {
        this.dataTypes.remove(columnIndex);
        long[] tmpValueChunkRawSize = this.memoryBinaryChunkSize;
        this.memoryBinaryChunkSize = new long[this.dataTypes.size()];
        int copyIndex = 0;
        for (int i = 0; i < tmpValueChunkRawSize.length; ++i) {
            if (i == columnIndex) continue;
            this.memoryBinaryChunkSize[copyIndex++] = tmpValueChunkRawSize[i];
        }
        for (Object array : this.values.get(columnIndex)) {
            PrimitiveArrayManager.release(array);
        }
        this.values.remove(columnIndex);
        this.bitMaps.remove(columnIndex);
    }

    protected void set(int index, long timestamp, int value) {
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.indices.get((int)arrayIndex)[elementIndex] = value;
    }

    protected int[] cloneIndex(int[] array) {
        int[] cloneArray = new int[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    protected Object cloneValue(TSDataType type, Object value) {
        switch (type) {
            case TEXT: {
                Binary[] valueT = (Binary[])value;
                Binary[] cloneT = new Binary[valueT.length];
                System.arraycopy(valueT, 0, cloneT, 0, valueT.length);
                return cloneT;
            }
            case FLOAT: {
                float[] valueF = (float[])value;
                float[] cloneF = new float[valueF.length];
                System.arraycopy(valueF, 0, cloneF, 0, valueF.length);
                return cloneF;
            }
            case INT32: {
                int[] valueI = (int[])value;
                int[] cloneI = new int[valueI.length];
                System.arraycopy(valueI, 0, cloneI, 0, valueI.length);
                return cloneI;
            }
            case INT64: {
                long[] valueL = (long[])value;
                long[] cloneL = new long[valueL.length];
                System.arraycopy(valueL, 0, cloneL, 0, valueL.length);
                return cloneL;
            }
            case DOUBLE: {
                double[] valueD = (double[])value;
                double[] cloneD = new double[valueD.length];
                System.arraycopy(valueD, 0, cloneD, 0, valueD.length);
                return cloneD;
            }
            case BOOLEAN: {
                boolean[] valueB = (boolean[])value;
                boolean[] cloneB = new boolean[valueB.length];
                System.arraycopy(valueB, 0, cloneB, 0, valueB.length);
                return cloneB;
            }
        }
        return null;
    }

    @Override
    public void clearValue() {
        if (this.indices != null) {
            for (int[] dataArray : this.indices) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.indices.clear();
        }
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            List<BitMap> columnBitMaps;
            List<Object> columnValues = this.values.get(i);
            if (columnValues != null) {
                for (Object dataArray : columnValues) {
                    PrimitiveArrayManager.release(dataArray);
                }
                columnValues.clear();
            }
            if (this.bitMaps != null && (columnBitMaps = this.bitMaps.get(i)) != null) {
                columnBitMaps.clear();
            }
            this.memoryBinaryChunkSize[i] = 0L;
        }
    }

    @Override
    protected void expandValues() {
        this.indices.add((int[])this.getPrimitiveArraysByType(TSDataType.INT32));
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            this.values.get(i).add(this.getPrimitiveArraysByType(this.dataTypes.get(i)));
            if (this.bitMaps == null || this.bitMaps.get(i) == null) continue;
            this.bitMaps.get(i).add(null);
        }
    }

    @Override
    public int getValueIndex(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.indices.get(arrayIndex)[elementIndex];
    }

    public int getValidRowIndexForTimeDuplicatedRows(List<Integer> timeDuplicatedOriginRowIndexList, int columnIndex) {
        int validRowIndex = timeDuplicatedOriginRowIndexList.get(0);
        for (int originRowIndex : timeDuplicatedOriginRowIndexList) {
            if (this.isNullValue(originRowIndex, columnIndex)) continue;
            validRowIndex = originRowIndex;
        }
        return validRowIndex;
    }

    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, List<TSEncoding> encodingList) {
        return new TimeValuePair(time, (TsPrimitiveType)this.getAlignedValueForQuery(index, floatPrecision, encodingList));
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayManager.release(this.indices.remove(this.indices.size() - 1));
        for (List<Object> valueList : this.values) {
            PrimitiveArrayManager.release(valueList.remove(valueList.size() - 1));
        }
    }

    @Override
    public boolean reachMaxChunkSizeThreshold() {
        return this.reachMaxChunkSizeFlag;
    }

    @Override
    public void putAlignedValues(long[] time, Object[] value, BitMap[] bitMaps, int start, int end) {
        int internalRemaining;
        this.checkExpansion();
        this.updateMaxTimeAndSorted(time, start, end);
        for (int idx = start; idx < end; idx += internalRemaining) {
            int j;
            int i;
            int inputRemaining = end - idx;
            int arrayIdx = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
            internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                this.arrayCopy(value, idx, arrayIdx, elementIdx, inputRemaining);
                for (i = 0; i < inputRemaining; ++i) {
                    this.indices.get((int)arrayIdx)[elementIdx + i] = this.rowCount;
                    for (j = 0; j < this.values.size(); ++j) {
                        if (value[j] != null && (bitMaps == null || bitMaps[j] == null || !bitMaps[j].isMarked(idx + i))) continue;
                        this.markNullValue(j, arrayIdx, elementIdx + i);
                    }
                    ++this.rowCount;
                }
                break;
            }
            System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            this.arrayCopy(value, idx, arrayIdx, elementIdx, internalRemaining);
            for (i = 0; i < internalRemaining; ++i) {
                this.indices.get((int)arrayIdx)[elementIdx + i] = this.rowCount;
                for (j = 0; j < this.values.size(); ++j) {
                    if (value[j] != null && (bitMaps == null || bitMaps[j] == null || !bitMaps[j].isMarked(idx + i))) continue;
                    this.markNullValue(j, arrayIdx, elementIdx + i);
                }
                ++this.rowCount;
            }
            this.checkExpansion();
        }
    }

    private void arrayCopy(Object[] value, int idx, int arrayIndex, int elementIndex, int remaining) {
        block8: for (int i = 0; i < this.values.size(); ++i) {
            if (value[i] == null) continue;
            List<Object> columnValues = this.values.get(i);
            switch (this.dataTypes.get(i)) {
                case TEXT: {
                    Binary[] arrayT = (Binary[])columnValues.get(arrayIndex);
                    System.arraycopy(value[i], idx, arrayT, elementIndex, remaining);
                    for (int i1 = 0; i1 < remaining; ++i1) {
                        int n = i;
                        this.memoryBinaryChunkSize[n] = this.memoryBinaryChunkSize[n] + (arrayT[elementIndex + i1] != null ? MemUtils.getBinarySize(arrayT[elementIndex + i1]) : 0L);
                    }
                    if (this.memoryBinaryChunkSize[i] <= targetChunkSize) continue block8;
                    this.reachMaxChunkSizeFlag = true;
                    continue block8;
                }
                case FLOAT: {
                    float[] arrayF = (float[])columnValues.get(arrayIndex);
                    System.arraycopy(value[i], idx, arrayF, elementIndex, remaining);
                    continue block8;
                }
                case INT32: {
                    int[] arrayI = (int[])columnValues.get(arrayIndex);
                    System.arraycopy(value[i], idx, arrayI, elementIndex, remaining);
                    continue block8;
                }
                case INT64: {
                    long[] arrayL = (long[])columnValues.get(arrayIndex);
                    System.arraycopy(value[i], idx, arrayL, elementIndex, remaining);
                    continue block8;
                }
                case DOUBLE: {
                    double[] arrayD = (double[])columnValues.get(arrayIndex);
                    System.arraycopy(value[i], idx, arrayD, elementIndex, remaining);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean[] arrayB = (boolean[])columnValues.get(arrayIndex);
                    System.arraycopy(value[i], idx, arrayB, elementIndex, remaining);
                    continue block8;
                }
            }
        }
    }

    private void markNullValue(int columnIndex, int arrayIndex, int elementIndex) {
        if (this.bitMaps == null) {
            this.bitMaps = new ArrayList<List<BitMap>>(this.dataTypes.size());
            for (int i = 0; i < this.dataTypes.size(); ++i) {
                this.bitMaps.add(null);
            }
        }
        if (this.bitMaps.get(columnIndex) == null) {
            ArrayList<BitMap> columnBitMaps = new ArrayList<BitMap>();
            for (int i = 0; i < this.values.get(columnIndex).size(); ++i) {
                columnBitMaps.add(new BitMap(PrimitiveArrayManager.ARRAY_SIZE));
            }
            this.bitMaps.set(columnIndex, columnBitMaps);
        }
        if (this.bitMaps.get(columnIndex).get(arrayIndex) == null) {
            this.bitMaps.get(columnIndex).set(arrayIndex, new BitMap(PrimitiveArrayManager.ARRAY_SIZE));
        }
        this.bitMaps.get(columnIndex).get(arrayIndex).mark(elementIndex);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.VECTOR;
    }

    public static long alignedTvListArrayMemCost(TSDataType[] types) {
        long size = 0L;
        for (TSDataType type : types) {
            if (type == null) continue;
            size += (long)PrimitiveArrayManager.ARRAY_SIZE * (long)type.getDataTypeSize();
        }
        if (size == 0L) {
            return size;
        }
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 8L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 4L;
        size += (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * (long)(2 + types.length);
        return size += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)(2 + types.length);
    }

    public static long alignedTvListArrayMemCost(List<TSDataType> types) {
        long size = 0L;
        for (TSDataType type : types) {
            if (type == null) continue;
            size += (long)PrimitiveArrayManager.ARRAY_SIZE * (long)type.getDataTypeSize();
        }
        if (size == 0L) {
            return size;
        }
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 8L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 4L;
        size += (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * (long)(2 + types.size());
        return size += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)(2 + types.size());
    }

    public static long valueListArrayMemCost(TSDataType type) {
        long size = 0L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * (long)type.getDataTypeSize();
        size += (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        return size += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    public TsBlock buildTsBlock(int floatPrecision, List<TSEncoding> encodingList, List<List<TimeRange>> deletionList) {
        TsBlockBuilder builder = new TsBlockBuilder(this.dataTypes);
        TimeColumnBuilder timeBuilder = builder.getTimeColumnBuilder();
        int validRowCount = 0;
        boolean[] timeDuplicateInfo = null;
        for (int sortedRowIndex = 0; sortedRowIndex < this.rowCount; ++sortedRowIndex) {
            int nextRowIndex;
            if (this.rowBitMap != null && this.rowBitMap.isMarked(this.getValueIndex(sortedRowIndex))) continue;
            for (nextRowIndex = sortedRowIndex + 1; nextRowIndex < this.rowCount && this.rowBitMap != null && this.rowBitMap.isMarked(this.getValueIndex(nextRowIndex)); ++nextRowIndex) {
            }
            if (nextRowIndex == this.rowCount || this.getTime(sortedRowIndex) != this.getTime(nextRowIndex)) {
                timeBuilder.writeLong(this.getTime(sortedRowIndex));
                ++validRowCount;
            } else {
                if (Objects.isNull(timeDuplicateInfo)) {
                    timeDuplicateInfo = new boolean[this.rowCount];
                }
                timeDuplicateInfo[sortedRowIndex] = true;
            }
            sortedRowIndex = nextRowIndex - 1;
        }
        for (int columnIndex = 0; columnIndex < this.dataTypes.size(); ++columnIndex) {
            int deleteCursor = 0;
            Pair lastValidPointIndexForTimeDupCheck = null;
            if (Objects.nonNull(timeDuplicateInfo)) {
                lastValidPointIndexForTimeDupCheck = new Pair((Object)Long.MIN_VALUE, null);
            }
            ColumnBuilder valueBuilder = builder.getColumnBuilder(columnIndex);
            block11: for (int sortedRowIndex = 0; sortedRowIndex < this.rowCount; ++sortedRowIndex) {
                int originRowIndex;
                if (this.rowBitMap != null && this.rowBitMap.isMarked(this.getValueIndex(sortedRowIndex))) continue;
                if (Objects.nonNull(timeDuplicateInfo)) {
                    if (!this.isNullValue(this.getValueIndex(sortedRowIndex), columnIndex)) {
                        lastValidPointIndexForTimeDupCheck.left = this.getTime(sortedRowIndex);
                        lastValidPointIndexForTimeDupCheck.right = this.getValueIndex(sortedRowIndex);
                    }
                    if (timeDuplicateInfo[sortedRowIndex]) continue;
                }
                if (this.isNullValue(originRowIndex = Objects.nonNull(lastValidPointIndexForTimeDupCheck) && this.getTime(sortedRowIndex) == ((Long)lastValidPointIndexForTimeDupCheck.left).longValue() ? ((Integer)lastValidPointIndexForTimeDupCheck.right).intValue() : this.getValueIndex(sortedRowIndex), columnIndex) || this.isPointDeleted(this.getTime(sortedRowIndex), Objects.isNull(deletionList) ? null : deletionList.get(columnIndex), deleteCursor)) {
                    valueBuilder.appendNull();
                    continue;
                }
                switch (this.dataTypes.get(columnIndex)) {
                    case BOOLEAN: {
                        valueBuilder.writeBoolean(this.getBooleanByValueIndex(originRowIndex, columnIndex));
                        continue block11;
                    }
                    case INT32: {
                        valueBuilder.writeInt(this.getIntByValueIndex(originRowIndex, columnIndex));
                        continue block11;
                    }
                    case INT64: {
                        valueBuilder.writeLong(this.getLongByValueIndex(originRowIndex, columnIndex));
                        continue block11;
                    }
                    case FLOAT: {
                        valueBuilder.writeFloat(this.roundValueWithGivenPrecision(this.getFloatByValueIndex(originRowIndex, columnIndex), floatPrecision, encodingList.get(columnIndex)));
                        continue block11;
                    }
                    case DOUBLE: {
                        valueBuilder.writeDouble(this.roundValueWithGivenPrecision(this.getDoubleByValueIndex(originRowIndex, columnIndex), floatPrecision, encodingList.get(columnIndex)));
                        continue block11;
                    }
                    case TEXT: {
                        valueBuilder.writeBinary(this.getBinaryByValueIndex(originRowIndex, columnIndex));
                        continue block11;
                    }
                }
            }
        }
        builder.declarePositions(validRowCount);
        return builder.build();
    }

    @Override
    protected void writeValidValuesIntoTsBlock(TsBlockBuilder builder, int floatPrecision, TSEncoding encoding, List<TimeRange> deletionList) {
        throw new UnsupportedOperationException("DataType not consistent");
    }

    @Override
    public int serializedSize() {
        int size = (1 + this.dataTypes.size()) * 1 + 8;
        size += this.rowCount * 8;
        block8: for (int columnIndex = 0; columnIndex < this.values.size(); ++columnIndex) {
            switch (this.dataTypes.get(columnIndex)) {
                case TEXT: {
                    for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
                        size += ReadWriteIOUtils.sizeToWrite((Binary)this.getBinaryByValueIndex(rowIdx, columnIndex));
                    }
                    continue block8;
                }
                case FLOAT: {
                    size += this.rowCount * 4;
                    continue block8;
                }
                case INT32: {
                    size += this.rowCount * 4;
                    continue block8;
                }
                case INT64: {
                    size += this.rowCount * 8;
                    continue block8;
                }
                case DOUBLE: {
                    size += this.rowCount * 8;
                    continue block8;
                }
                case BOOLEAN: {
                    size += this.rowCount * 1;
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("DataType not consistent");
                }
            }
        }
        return size += this.rowCount * this.dataTypes.size() * 1;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(TSDataType.VECTOR, buffer);
        buffer.putInt(this.dataTypes.size());
        for (TSDataType dataType : this.dataTypes) {
            buffer.put(dataType.serialize());
        }
        buffer.putInt(this.rowCount);
        for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
            buffer.putLong(this.getTime(rowIndex));
        }
        for (int columnIndex = 0; columnIndex < this.values.size(); ++columnIndex) {
            List<Object> columnValues = this.values.get(columnIndex);
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
                int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
                switch (this.dataTypes.get(columnIndex)) {
                    case TEXT: {
                        Binary valueT = ((Binary[])columnValues.get(arrayIndex))[elementIndex];
                        if (valueT != null) {
                            WALWriteUtils.write(valueT, buffer);
                            break;
                        }
                        WALWriteUtils.write(new Binary(new byte[0]), buffer);
                        break;
                    }
                    case FLOAT: {
                        float valueF = ((float[])columnValues.get(arrayIndex))[elementIndex];
                        buffer.putFloat(valueF);
                        break;
                    }
                    case INT32: {
                        int valueI = ((int[])columnValues.get(arrayIndex))[elementIndex];
                        buffer.putInt(valueI);
                        break;
                    }
                    case INT64: {
                        long valueL = ((long[])columnValues.get(arrayIndex))[elementIndex];
                        buffer.putLong(valueL);
                        break;
                    }
                    case DOUBLE: {
                        double valueD = ((double[])columnValues.get(arrayIndex))[elementIndex];
                        buffer.putDouble(valueD);
                        break;
                    }
                    case BOOLEAN: {
                        boolean valueB = ((boolean[])columnValues.get(arrayIndex))[elementIndex];
                        WALWriteUtils.write(valueB, buffer);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("DataType not consistent");
                    }
                }
                WALWriteUtils.write(this.isNullValue(rowIndex, columnIndex), buffer);
            }
        }
    }

    public static AlignedTVList deserialize(DataInputStream stream) throws IOException {
        int dataTypeNum = stream.readInt();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>(dataTypeNum);
        for (int columnIndex = 0; columnIndex < dataTypeNum; ++columnIndex) {
            dataTypes.add(ReadWriteIOUtils.readDataType((InputStream)stream));
        }
        int rowCount = stream.readInt();
        long[] times = new long[rowCount];
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            times[rowIndex] = stream.readLong();
        }
        Object[] values = new Object[dataTypeNum];
        BitMap[] bitMaps = new BitMap[dataTypeNum];
        for (int columnIndex = 0; columnIndex < dataTypeNum; ++columnIndex) {
            Object[] valuesOfOneColumn;
            BitMap bitMap = new BitMap(rowCount);
            switch ((TSDataType)dataTypes.get(columnIndex)) {
                case TEXT: {
                    Binary[] binaryValues = new Binary[rowCount];
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        binaryValues[rowIndex] = ReadWriteIOUtils.readBinary((InputStream)stream);
                        if (!ReadWriteIOUtils.readBool((InputStream)stream)) continue;
                        bitMap.mark(rowIndex);
                    }
                    valuesOfOneColumn = binaryValues;
                    break;
                }
                case FLOAT: {
                    float[] floatValues = new float[rowCount];
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        floatValues[rowIndex] = stream.readFloat();
                        if (!ReadWriteIOUtils.readBool((InputStream)stream)) continue;
                        bitMap.mark(rowIndex);
                    }
                    valuesOfOneColumn = floatValues;
                    break;
                }
                case INT32: {
                    int[] intValues = new int[rowCount];
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        intValues[rowIndex] = stream.readInt();
                        if (!ReadWriteIOUtils.readBool((InputStream)stream)) continue;
                        bitMap.mark(rowIndex);
                    }
                    valuesOfOneColumn = intValues;
                    break;
                }
                case INT64: {
                    long[] longValues = new long[rowCount];
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        longValues[rowIndex] = stream.readLong();
                        if (!ReadWriteIOUtils.readBool((InputStream)stream)) continue;
                        bitMap.mark(rowIndex);
                    }
                    valuesOfOneColumn = longValues;
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[rowCount];
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        doubleValues[rowIndex] = stream.readDouble();
                        if (!ReadWriteIOUtils.readBool((InputStream)stream)) continue;
                        bitMap.mark(rowIndex);
                    }
                    valuesOfOneColumn = doubleValues;
                    break;
                }
                case BOOLEAN: {
                    boolean[] booleanValues = new boolean[rowCount];
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        booleanValues[rowIndex] = ReadWriteIOUtils.readBool((InputStream)stream);
                        if (!ReadWriteIOUtils.readBool((InputStream)stream)) continue;
                        bitMap.mark(rowIndex);
                    }
                    valuesOfOneColumn = booleanValues;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("DataType not consistent");
                }
            }
            values[columnIndex] = valuesOfOneColumn;
            bitMaps[columnIndex] = bitMap;
        }
        AlignedTVList tvList = AlignedTVList.newAlignedList(dataTypes);
        tvList.putAlignedValues(times, values, bitMaps, 0, rowCount);
        return tvList;
    }

    public BitMap getRowBitMap() {
        if (this.bitMaps == null) {
            return null;
        }
        for (int columnIndex = 0; columnIndex < this.values.size(); ++columnIndex) {
            if (this.values.get(columnIndex) == null || this.bitMaps.get(columnIndex) != null) continue;
            return null;
        }
        byte[] rowBitsArr = new byte[this.rowCount / 8 + 1];
        for (int row = 0; row < this.rowCount; row += 8) {
            boolean isFirstColumn = true;
            int rowBits = 0;
            for (int columnIndex = 0; columnIndex < this.values.size(); ++columnIndex) {
                int columnBits;
                List<BitMap> columnBitMaps = this.bitMaps.get(columnIndex);
                if (this.values.get(columnIndex) == null) {
                    columnBits = -1;
                } else {
                    if (columnBitMaps == null || columnBitMaps.get(row / PrimitiveArrayManager.ARRAY_SIZE) == null) {
                        rowBits = 0;
                        break;
                    }
                    columnBits = columnBitMaps.get(row / PrimitiveArrayManager.ARRAY_SIZE).getByteArray()[row % PrimitiveArrayManager.ARRAY_SIZE / 8];
                }
                if (isFirstColumn) {
                    rowBits = columnBits;
                    isFirstColumn = false;
                    continue;
                }
                rowBits = (byte)(rowBits & columnBits);
            }
            rowBitsArr[row / 8] = rowBits;
        }
        return new BitMap(this.rowCount, rowBitsArr);
    }
}

