/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALWriter;
import org.apache.iotdb.db.utils.SerializedSize;

public class WALMetaData
implements SerializedSize {
    private static final int FIXED_SERIALIZED_SIZE = 12;
    private long firstSearchIndex;
    private final List<Integer> buffersSize;
    private final Set<Long> memTablesId;

    public WALMetaData() {
        this(-1L, new ArrayList<Integer>(), new HashSet<Long>());
    }

    public WALMetaData(long firstSearchIndex, List<Integer> buffersSize, Set<Long> memTablesId) {
        this.firstSearchIndex = firstSearchIndex;
        this.buffersSize = buffersSize;
        this.memTablesId = memTablesId;
    }

    public void add(int size, long searchIndex, long memTableId) {
        if (this.buffersSize.isEmpty()) {
            this.firstSearchIndex = searchIndex;
        }
        this.buffersSize.add(size);
        this.memTablesId.add(memTableId);
    }

    public void addAll(WALMetaData metaData) {
        if (this.buffersSize.isEmpty()) {
            this.firstSearchIndex = metaData.getFirstSearchIndex();
        }
        this.buffersSize.addAll(metaData.getBuffersSize());
        this.memTablesId.addAll(metaData.getMemTablesId());
    }

    @Override
    public int serializedSize() {
        return 12 + this.buffersSize.size() * 4 + (this.memTablesId.isEmpty() ? 0 : 4 + this.memTablesId.size() * 8);
    }

    public void serialize(ByteBuffer buffer) {
        buffer.putLong(this.firstSearchIndex);
        buffer.putInt(this.buffersSize.size());
        Iterator<Number> iterator = this.buffersSize.iterator();
        while (iterator.hasNext()) {
            int size = iterator.next();
            buffer.putInt(size);
        }
        if (!this.memTablesId.isEmpty()) {
            buffer.putInt(this.memTablesId.size());
            iterator = this.memTablesId.iterator();
            while (iterator.hasNext()) {
                long memTableId = (Long)iterator.next();
                buffer.putLong(memTableId);
            }
        }
    }

    public static WALMetaData deserialize(ByteBuffer buffer) {
        long firstSearchIndex = buffer.getLong();
        int entriesNum = buffer.getInt();
        ArrayList<Integer> buffersSize = new ArrayList<Integer>(entriesNum);
        for (int i = 0; i < entriesNum; ++i) {
            buffersSize.add(buffer.getInt());
        }
        HashSet<Long> memTablesId = new HashSet<Long>();
        if (buffer.hasRemaining()) {
            int memTablesIdNum = buffer.getInt();
            for (int i = 0; i < memTablesIdNum; ++i) {
                memTablesId.add(buffer.getLong());
            }
        }
        return new WALMetaData(firstSearchIndex, buffersSize, memTablesId);
    }

    public List<Integer> getBuffersSize() {
        return this.buffersSize;
    }

    public Set<Long> getMemTablesId() {
        return this.memTablesId;
    }

    public long getFirstSearchIndex() {
        return this.firstSearchIndex;
    }

    public static WALMetaData readFromWALFile(File logFile, FileChannel channel) throws IOException {
        if (channel.size() < (long)WALWriter.MAGIC_STRING_BYTES || !WALMetaData.readTailMagic(channel).equals("WAL")) {
            throw new IOException(String.format("Broken wal file %s", logFile));
        }
        ByteBuffer metadataSizeBuf = ByteBuffer.allocate(4);
        long position = channel.size() - (long)WALWriter.MAGIC_STRING_BYTES - 4L;
        channel.read(metadataSizeBuf, position);
        metadataSizeBuf.flip();
        int metadataSize = metadataSizeBuf.getInt();
        ByteBuffer metadataBuf = ByteBuffer.allocate(metadataSize);
        channel.read(metadataBuf, position - (long)metadataSize);
        metadataBuf.flip();
        WALMetaData metaData = WALMetaData.deserialize(metadataBuf);
        if (metaData.memTablesId.isEmpty()) {
            int offset = 1;
            for (int size : metaData.buffersSize) {
                channel.position(offset);
                ByteBuffer buffer = ByteBuffer.allocate(8);
                channel.read(buffer);
                buffer.clear();
                metaData.memTablesId.add(buffer.getLong());
                offset += size;
            }
        }
        return metaData;
    }

    private static String readTailMagic(FileChannel channel) throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate(WALWriter.MAGIC_STRING_BYTES);
        channel.read(magicStringBytes, channel.size() - (long)WALWriter.MAGIC_STRING_BYTES);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }
}

