/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.allocation;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.dataregion.wal.allocation.NodeAllocationStrategy;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALFakeNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeAllocationStrategy
implements NodeAllocationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNodeAllocationStrategy.class);
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    protected FolderManager folderManager;

    protected AbstractNodeAllocationStrategy() {
        try {
            this.folderManager = new FolderManager(Arrays.asList(commonConfig.getWalDirs()), DirectoryStrategyType.SEQUENCE_STRATEGY);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Fail to create wal node allocation strategy because all disks of wal folders are full.", (Throwable)((Object)e));
        }
    }

    protected IWALNode createWALNode(String identifier) {
        String folder;
        try {
            folder = this.folderManager.getNextFolder();
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Fail to create wal node because all disks of wal folders are full.", (Throwable)((Object)e));
            return WALFakeNode.getFailureInstance((Exception)((Object)e));
        }
        folder = folder + File.separator + identifier;
        return this.createWALNode(identifier, folder);
    }

    protected IWALNode createWALNode(String identifier, String folder) {
        try {
            return new WALNode(identifier, folder);
        }
        catch (FileNotFoundException e) {
            logger.error("Fail to create wal node", (Throwable)e);
            return WALFakeNode.getFailureInstance(e);
        }
    }

    protected IWALNode createWALNode(String identifier, String folder, long startFileVersion, long startSearchIndex) {
        try {
            return new WALNode(identifier, folder, startFileVersion, startSearchIndex);
        }
        catch (FileNotFoundException e) {
            logger.error("Fail to create wal node", (Throwable)e);
            return WALFakeNode.getFailureInstance(e);
        }
    }
}

