/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.DiskAlignedChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskAlignedChunkMetadataLoader
implements IChunkMetadataLoader {
    private final TsFileResource resource;
    private final QueryContext context;
    private final Filter globalTimeFilter;
    private final List<List<Modification>> pathModifications;
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public DiskAlignedChunkMetadataLoader(TsFileResource resource, QueryContext context, Filter globalTimeFilter, List<List<Modification>> pathModifications) {
        this.resource = resource;
        this.context = context;
        this.globalTimeFilter = globalTimeFilter;
        this.pathModifications = pathModifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        long t1 = System.nanoTime();
        try {
            List alignedChunkMetadataList = ((AlignedTimeSeriesMetadata)timeSeriesMetadata).getCopiedChunkMetadataList();
            if (alignedChunkMetadataList.size() > 1) {
                long t2 = System.nanoTime();
                alignedChunkMetadataList.removeIf(alignedChunkMetaData -> this.globalTimeFilter != null && this.globalTimeFilter.canSkip((IMetadata)alignedChunkMetaData) || alignedChunkMetaData.getStartTime() > alignedChunkMetaData.getEndTime());
                if (this.context.isDebug()) {
                    DEBUG_LOGGER.info("After removed by filter Chunk meta data list is: ");
                    alignedChunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
                }
                SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("chunk_metadata_filter_aligned_disk", System.nanoTime() - t2);
            }
            long t3 = System.nanoTime();
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("Modifications size is {} for file Path: {} ", (Object)this.pathModifications.size(), (Object)this.resource.getTsFilePath());
                this.pathModifications.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            ModificationUtils.modifyAlignedChunkMetaData(alignedChunkMetadataList, this.pathModifications);
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("After modification Chunk meta data list is: ");
                alignedChunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("chunk_metadata_modification_aligned_disk", System.nanoTime() - t3);
            alignedChunkMetadataList.forEach(chunkMetadata -> {
                if (chunkMetadata.needSetChunkLoader()) {
                    chunkMetadata.setVersion(this.resource.getVersion());
                    chunkMetadata.setClosed(this.resource.isClosed());
                    chunkMetadata.setChunkLoader((IChunkLoader)new DiskAlignedChunkLoader(this.context, this.resource));
                }
            });
            ArrayList<IChunkMetadata> arrayList = new ArrayList<IChunkMetadata>(alignedChunkMetadataList);
            return arrayList;
        }
        finally {
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("load_chunk_metadata_list_aligned_disk", System.nanoTime() - t1);
        }
    }
}

