/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractCrossSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;

public class FastCrossSpaceCompactionEstimator
extends AbstractCrossSpaceEstimator {
    @Override
    protected long calculatingMetadataMemoryCost(CompactionTaskInfo taskInfo) {
        long cost = 0L;
        cost += Math.min(taskInfo.getTotalChunkMetadataSize(), (long)(taskInfo.getFileInfoList().size() * taskInfo.getMaxChunkMetadataNumInDevice()) * taskInfo.getMaxChunkMetadataSize());
        long sizeForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
        return cost += sizeForFileWriter;
    }

    @Override
    protected long calculatingDataMemoryCost(CompactionTaskInfo taskInfo) throws IOException {
        if (taskInfo.getTotalChunkNum() == 0L) {
            return taskInfo.getModificationFileSize();
        }
        long maxConcurrentSeriesNum = Math.max(this.config.getSubCompactionTaskNum(), taskInfo.getMaxConcurrentSeriesNum());
        long averageUncompressedChunkSize = taskInfo.getTotalFileSize() * this.compressionRatio / taskInfo.getTotalChunkNum();
        long maxConcurrentSeriesSizeOfTotalFiles = averageUncompressedChunkSize * (long)taskInfo.getFileInfoList().size() * maxConcurrentSeriesNum * (long)taskInfo.getMaxChunkMetadataNumInSeries() / this.compressionRatio;
        long maxTargetChunkWriterSize = this.config.getTargetChunkSize() * maxConcurrentSeriesNum;
        long targetChunkWriterSize = Math.min(maxConcurrentSeriesSizeOfTotalFiles, maxTargetChunkWriterSize);
        long maxConcurrentChunkSizeFromSourceFile = averageUncompressedChunkSize * maxConcurrentSeriesNum * (long)this.calculatingMaxOverlapFileNumInSubCompactionTask(taskInfo.getResources());
        return targetChunkWriterSize + maxConcurrentChunkSizeFromSourceFile + taskInfo.getModificationFileSize();
    }
}

