/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairProgress;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTaskRecoverLogParser;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTimePartition;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTimePartitionScanTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsortedFileRepairTaskScheduler
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsortedFileRepairTaskScheduler.class);
    private final Set<RepairTimePartition> allTimePartitionFiles = new HashSet<RepairTimePartition>();
    private RepairLogger repairLogger;
    private boolean initSuccess = false;
    private boolean isRecoverStoppedTask = false;
    private long repairTaskTime;
    private RepairProgress repairProgress;

    public UnsortedFileRepairTaskScheduler(List<DataRegion> dataRegions, boolean isRecoverStorageEngine) {
        this.initRepairDataTask(dataRegions, isRecoverStorageEngine, this.getOrCreateRepairLogDir());
    }

    public UnsortedFileRepairTaskScheduler(List<DataRegion> dataRegions, boolean isRecoverStorageEngine, File logFileDir) {
        this.initRepairDataTask(dataRegions, isRecoverStorageEngine, logFileDir);
    }

    private void initRepairDataTask(List<DataRegion> dataRegions, boolean isRecoverStorageEngine, File logFileDir) {
        try {
            this.repairLogger = new RepairLogger(logFileDir, isRecoverStorageEngine);
        }
        catch (Exception e) {
            try {
                LOGGER.error("[RepairScheduler] Failed to create repair logger", (Throwable)e);
                this.repairLogger.close();
            }
            catch (IOException closeException) {
                LOGGER.error("[RepairScheduler] Failed to close repair logger", (Throwable)closeException);
            }
            return;
        }
        File logFile = this.repairLogger.getLogFile();
        RepairTaskRecoverLogParser recoverLogParser = new RepairTaskRecoverLogParser(logFile);
        if (this.repairLogger.isNeedRecoverFromLogFile()) {
            try {
                recoverLogParser.parse();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.repairTaskTime = recoverLogParser.getRepairDataTaskStartTime();
        this.collectTimePartitions(dataRegions);
        if (this.repairLogger.isNeedRecoverFromLogFile()) {
            try {
                this.recoverRepairProgress(recoverLogParser);
            }
            catch (Exception e) {
                LOGGER.error("[RepairScheduler] Failed to parse repair log file {}", (Object)logFile.getAbsolutePath(), (Object)e);
                return;
            }
        }
        try {
            this.repairLogger.recordRepairTaskStartTimeIfLogFileEmpty(this.repairTaskTime);
        }
        catch (IOException e) {
            LOGGER.error("[RepairScheduler] Failed to record repair task start time in log file {}", (Object)logFile.getAbsolutePath(), (Object)e);
            return;
        }
        this.repairProgress = new RepairProgress(this.allTimePartitionFiles.size());
        this.initSuccess = true;
        this.isRecoverStoppedTask = this.repairLogger.isPreviousTaskStopped();
    }

    private File getOrCreateRepairLogDir() {
        File logFileDir = new File(IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "repair");
        if (!logFileDir.exists()) {
            logFileDir.mkdirs();
        }
        return logFileDir;
    }

    private void recoverRepairProgress(RepairTaskRecoverLogParser recoverLogParser) {
        LOGGER.info("[RepairScheduler] recover unfinished repair schedule task from log file: {}", (Object)recoverLogParser.getRepairLogFilePath());
        Map<RepairTimePartition, Set<String>> repairedTimePartitionWithCannotRepairFiles = recoverLogParser.getRepairedTimePartitionsWithCannotRepairFiles();
        for (RepairTimePartition timePartition : this.allTimePartitionFiles) {
            Set<String> cannotRepairFiles = repairedTimePartitionWithCannotRepairFiles.remove(timePartition);
            if (cannotRepairFiles == null) continue;
            timePartition.setRepaired(true);
            if (cannotRepairFiles.isEmpty()) continue;
            List<TsFileResource> resources = timePartition.getAllFileSnapshot();
            for (TsFileResource resource : resources) {
                if (resource.getStatus() != TsFileResourceStatus.NORMAL || !cannotRepairFiles.contains(resource.getTsFile().getName())) continue;
                resource.setTsFileRepairStatus(TsFileRepairStatus.NEED_TO_REPAIR);
            }
        }
        for (RepairTimePartition timePartition : this.allTimePartitionFiles) {
            if (timePartition.isRepaired() || timePartition.needRepair()) continue;
            timePartition.setRepaired(true);
        }
    }

    private void collectTimePartitions(List<DataRegion> dataRegions) {
        for (DataRegion dataRegion : dataRegions) {
            if (dataRegion == null) continue;
            List<Long> timePartitions = dataRegion.getTimePartitions();
            for (long timePartition : timePartitions) {
                this.allTimePartitionFiles.add(new RepairTimePartition(dataRegion, timePartition, this.repairTaskTime));
            }
        }
    }

    @Override
    public void run() {
        try {
            if (!this.checkConditionsToStartRepairTask()) {
                return;
            }
            LOGGER.info("[RepairScheduler] Wait compaction schedule task finish");
            CompactionScheduleTaskManager.getInstance().stopCompactionScheduleTasks();
            try {
                LOGGER.info("[RepairScheduler] Wait all running compaction task finish");
                CompactionTaskManager.getInstance().waitAllCompactionFinish();
                this.startTimePartitionScanTasks();
                LOGGER.info("[RepairScheduler] Repair task finished");
            }
            finally {
                CompactionScheduleTaskManager.getInstance().startScheduleTasks();
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            LOGGER.error("[RepairScheduler] Meet error when execute repair schedule task", (Throwable)e);
        }
        finally {
            try {
                this.repairLogger.close();
            }
            catch (Exception e) {
                LOGGER.error("[RepairScheduler] Failed to close repair logger {}", (Object)this.repairLogger.getRepairLogFilePath(), (Object)e);
            }
            CompactionScheduleTaskManager.getRepairTaskManagerInstance().markRepairTaskFinish();
        }
    }

    private boolean checkConditionsToStartRepairTask() throws InterruptedException {
        if (this.isRecoverStoppedTask) {
            return false;
        }
        if (!this.initSuccess) {
            LOGGER.info("[RepairScheduler] Failed to init repair schedule task");
            return false;
        }
        for (RepairTimePartition timePartition : this.allTimePartitionFiles) {
            if (timePartition.isRepaired()) continue;
            return true;
        }
        LOGGER.info("[RepairScheduler] All time partitions have been repaired, skip repair task");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimePartitionScanTasks() throws InterruptedException {
        CompactionScheduleTaskManager.RepairDataTaskManager repairDataTaskManager = CompactionScheduleTaskManager.getRepairTaskManagerInstance();
        try {
            for (RepairTimePartition timePartition : this.allTimePartitionFiles) {
                if (timePartition.isRepaired()) {
                    LOGGER.info("[RepairScheduler][{}][{}] skip repair time partition {} because it is repaired", new Object[]{timePartition.getDatabaseName(), timePartition.getDataRegionId(), timePartition.getTimePartitionId()});
                    this.repairProgress.incrementRepairedTimePartitionNum();
                    continue;
                }
                LOGGER.info("[RepairScheduler] submit a repair time partition scan task {}-{}-{}", new Object[]{timePartition.getDatabaseName(), timePartition.getDataRegionId(), timePartition.getTimePartitionId()});
                repairDataTaskManager.submitRepairScanTask(new RepairTimePartitionScanTask(timePartition, this.repairLogger, this.repairProgress));
            }
        }
        finally {
            repairDataTaskManager.waitRepairTaskFinish();
        }
    }
}

