/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.RepairUnsortedFileCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairDataFileScanUtil;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairProgress;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTimePartition;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.UnsortedFileRepairTaskScheduler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairTimePartitionScanTask
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsortedFileRepairTaskScheduler.class);
    private final RepairTimePartition repairTimePartition;
    private final RepairLogger repairLogger;
    private final RepairProgress progress;
    private static final Lock submitRepairFileTaskLock = new ReentrantLock();

    public RepairTimePartitionScanTask(RepairTimePartition repairTimePartition, RepairLogger repairLogger, RepairProgress progress) {
        this.repairTimePartition = repairTimePartition;
        this.repairLogger = repairLogger;
        this.progress = progress;
    }

    @Override
    public Void call() {
        try {
            this.scanTimePartitionFiles();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private void scanTimePartitionFiles() throws InterruptedException {
        LOGGER.info("[RepairScheduler][{}][{}] start scan repair time partition {}", new Object[]{this.repairTimePartition.getDatabaseName(), this.repairTimePartition.getDataRegionId(), this.repairTimePartition.getTimePartitionId()});
        this.checkInternalUnsortedFileAndRepair(this.repairTimePartition);
        this.checkOverlapInSequenceSpaceAndRepair(this.repairTimePartition);
        this.finishRepairTimePartition(this.repairTimePartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInternalUnsortedFileAndRepair(RepairTimePartition timePartition) throws InterruptedException {
        List sourceFiles = Stream.concat(timePartition.getSeqFileSnapshot().stream(), timePartition.getUnSeqFileSnapshot().stream()).collect(Collectors.toList());
        CountDownLatch latch = new CountDownLatch(sourceFiles.size());
        for (TsFileResource sourceFile : sourceFiles) {
            this.checkTaskStatusAndMayStop();
            sourceFile.readLock();
            try {
                if (sourceFile.getStatus() != TsFileResourceStatus.NORMAL) {
                    latch.countDown();
                    continue;
                }
                LOGGER.info("[RepairScheduler] start check tsfile: {}", (Object)sourceFile);
                RepairDataFileScanUtil scanUtil = new RepairDataFileScanUtil(sourceFile);
                scanUtil.scanTsFile();
                this.checkTaskStatusAndMayStop();
                if (scanUtil.isBrokenFile()) {
                    LOGGER.warn("[RepairScheduler] {} is skipped because it is broken", (Object)sourceFile);
                    sourceFile.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
                    latch.countDown();
                    continue;
                }
                if (!scanUtil.hasUnsortedData()) {
                    latch.countDown();
                    continue;
                }
            }
            finally {
                sourceFile.readUnlock();
                continue;
            }
            LOGGER.info("[RepairScheduler] {} need to repair because it has internal unsorted data", (Object)sourceFile);
            TsFileManager tsFileManager = timePartition.getTsFileManager();
            RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(timePartition.getTimePartitionId(), timePartition.getTsFileManager(), sourceFile, latch, sourceFile.isSeq(), tsFileManager.getNextCompactionTaskId());
            if (this.submitRepairFileTaskSafely(task)) continue;
            latch.countDown();
        }
        latch.await();
    }

    private void checkOverlapInSequenceSpaceAndRepair(RepairTimePartition timePartition) throws InterruptedException {
        TsFileManager tsFileManager = timePartition.getTsFileManager();
        List<TsFileResource> seqList = tsFileManager.getTsFileListSnapshot(timePartition.getTimePartitionId(), true);
        List<TsFileResource> overlapFiles = RepairDataFileScanUtil.checkTimePartitionHasOverlap(seqList);
        for (TsFileResource overlapFile : overlapFiles) {
            this.checkTaskStatusAndMayStop();
            CountDownLatch latch = new CountDownLatch(1);
            RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(timePartition.getTimePartitionId(), timePartition.getTsFileManager(), overlapFile, latch, true, false, tsFileManager.getNextCompactionTaskId());
            LOGGER.info("[RepairScheduler] {} need to repair because it is overlapped with other files", (Object)overlapFile);
            if (!this.submitRepairFileTaskSafely(task)) continue;
            latch.await();
        }
    }

    private boolean submitRepairFileTaskSafely(RepairUnsortedFileCompactionTask task) throws InterruptedException {
        submitRepairFileTaskLock.lock();
        try {
            while (CompactionTaskManager.getInstance().isWaitingQueueFull()) {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            boolean bl = CompactionTaskManager.getInstance().addTaskToWaitingQueue(task);
            return bl;
        }
        finally {
            submitRepairFileTaskLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRepairTimePartition(RepairTimePartition timePartition) {
        try {
            RepairLogger repairLogger = this.repairLogger;
            synchronized (repairLogger) {
                this.repairLogger.recordRepairedTimePartition(timePartition);
            }
        }
        catch (Exception e) {
            LOGGER.error("[RepairScheduler][{}][{}] failed to record repair log for time partition {}", new Object[]{timePartition.getDatabaseName(), timePartition.getDataRegionId(), timePartition.getTimePartitionId(), e});
        }
        LOGGER.info("[RepairScheduler][{}][{}] time partition {} has been repaired, progress: {}/{}", new Object[]{timePartition.getDatabaseName(), timePartition.getDataRegionId(), timePartition.getTimePartitionId(), this.progress.incrementRepairedTimePartitionNum(), this.progress.getTotalTimePartitionNum()});
    }

    private void checkTaskStatusAndMayStop() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }
}

