/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.PageLoader;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;

public class InstantPageLoader
extends PageLoader {
    private ByteBuffer pageData;

    public InstantPageLoader() {
    }

    public InstantPageLoader(PageHeader pageHeader, ByteBuffer pageData, CompressionType compressionType, TSDataType dataType, TSEncoding encoding, List<TimeRange> deleteIntervalList, ModifiedStatus modifiedStatus) {
        super(pageHeader, compressionType, dataType, encoding, deleteIntervalList, modifiedStatus);
        this.pageData = pageData;
    }

    @Override
    public ByteBuffer getCompressedData() {
        return this.pageData;
    }

    @Override
    public ByteBuffer getUnCompressedData() throws IOException {
        byte[] unCompressedData = new byte[this.pageHeader.getUncompressedSize()];
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor((CompressionType)this.compressionType);
        unCompressor.uncompress(this.pageData.array(), 0, this.pageHeader.getCompressedSize(), unCompressedData, 0);
        return ByteBuffer.wrap(unCompressedData);
    }

    @Override
    public void flushToTimeChunkWriter(AlignedChunkWriterImpl alignedChunkWriter) throws PageException {
        alignedChunkWriter.writePageHeaderAndDataIntoTimeBuff(this.pageData, this.pageHeader);
        this.clear();
    }

    @Override
    public void flushToValueChunkWriter(AlignedChunkWriterImpl alignedChunkWriter, int valueColumnIndex) throws IOException, PageException {
        if (this.isEmpty()) {
            alignedChunkWriter.getValueChunkWriterByIndex(valueColumnIndex).writeEmptyPageToPageBuffer();
        } else {
            alignedChunkWriter.getValueChunkWriterByIndex(valueColumnIndex).writePageHeaderAndDataIntoBuff(this.pageData, this.pageHeader);
            this.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.pageHeader == null || this.pageData == null || this.pageHeader.getUncompressedSize() == 0 || this.modifiedStatus == ModifiedStatus.ALL_DELETED;
    }

    @Override
    public void clear() {
        this.deleteIntervalList = null;
        this.pageHeader = null;
        this.pageData = null;
    }
}

