/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.PageLoader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public abstract class ChunkLoader {
    protected ChunkMetadata chunkMetadata;
    protected ModifiedStatus modifiedStatus;

    protected ChunkLoader(ChunkMetadata chunkMetadata) {
        this.chunkMetadata = chunkMetadata;
        this.calculateModifiedStatus();
    }

    protected ChunkLoader() {
    }

    private void calculateModifiedStatus() {
        this.modifiedStatus = ModifiedStatus.NONE_DELETED;
        if (this.chunkMetadata == null || this.chunkMetadata.getStatistics().getCount() == 0L) {
            return;
        }
        ChunkMetadata chunkMetadata = this.getChunkMetadata();
        List deleteIntervalList = chunkMetadata.getDeleteIntervalList();
        if (deleteIntervalList == null || deleteIntervalList.isEmpty()) {
            return;
        }
        long startTime = chunkMetadata.getStartTime();
        long endTime = chunkMetadata.getEndTime();
        TimeRange chunkTimeRange = new TimeRange(startTime, endTime);
        for (TimeRange timeRange : deleteIntervalList) {
            if (timeRange.contains(chunkTimeRange)) {
                this.modifiedStatus = ModifiedStatus.ALL_DELETED;
                break;
            }
            if (!timeRange.overlaps(chunkTimeRange)) continue;
            this.modifiedStatus = ModifiedStatus.PARTIAL_DELETED;
        }
    }

    protected ModifiedStatus calculatePageModifiedStatus(PageHeader pageHeader) {
        if (this.modifiedStatus != ModifiedStatus.PARTIAL_DELETED) {
            return this.modifiedStatus;
        }
        ModifiedStatus pageModifiedStatus = ModifiedStatus.NONE_DELETED;
        List deleteIntervalList = this.chunkMetadata.getDeleteIntervalList();
        long startTime = pageHeader.getStartTime();
        long endTime = pageHeader.getEndTime();
        TimeRange pageTimeRange = new TimeRange(startTime, endTime);
        for (TimeRange timeRange : deleteIntervalList) {
            if (timeRange.contains(pageTimeRange)) {
                pageModifiedStatus = ModifiedStatus.ALL_DELETED;
                break;
            }
            if (!timeRange.overlaps(pageTimeRange)) continue;
            pageModifiedStatus = ModifiedStatus.PARTIAL_DELETED;
        }
        return pageModifiedStatus;
    }

    public ChunkMetadata getChunkMetadata() {
        return this.chunkMetadata;
    }

    public ModifiedStatus getModifiedStatus() {
        return this.modifiedStatus;
    }

    public abstract Chunk getChunk() throws IOException;

    public abstract boolean isEmpty();

    public abstract ChunkHeader getHeader() throws IOException;

    public abstract List<PageLoader> getPages() throws IOException;

    public abstract void clear();
}

