/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;

public class Template
implements Serializable {
    private int id;
    private String name;
    private boolean isDirectAligned;
    private Map<String, IMeasurementSchema> schemaMap;

    public Template() {
        this.schemaMap = new ConcurrentHashMap<String, IMeasurementSchema>();
    }

    public Template(String name, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IllegalPathException {
        this(name, measurements, dataTypes, encodings, compressors, false);
    }

    public Template(String name, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) throws IllegalPathException {
        this.isDirectAligned = isAligned;
        this.schemaMap = new ConcurrentHashMap<String, IMeasurementSchema>();
        this.name = name;
        for (int i = 0; i < measurements.size(); ++i) {
            if (this.schemaMap.containsKey(measurements.get(i))) {
                throw new IllegalPathException("Path duplicated: " + measurements.get(i));
            }
            MeasurementSchema schema = new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i));
            this.schemaMap.put(schema.getMeasurementId(), (IMeasurementSchema)schema);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, IMeasurementSchema> getSchemaMap() {
        return this.schemaMap;
    }

    public boolean hasSchema(String suffixPath) {
        return this.schemaMap.containsKey(suffixPath);
    }

    public IMeasurementSchema getSchema(String measurementId) {
        return this.schemaMap.get(measurementId);
    }

    public boolean isDirectAligned() {
        return this.isDirectAligned;
    }

    public int getMeasurementNumber() {
        return this.schemaMap.size();
    }

    private IMeasurementSchema constructSchema(String nodeName, TSDataType dataType, TSEncoding encoding, CompressionType compressor) {
        return new MeasurementSchema(nodeName, dataType, encoding, compressor);
    }

    public void addMeasurements(String[] measurements, TSDataType[] dataTypes, TSEncoding[] encodings, CompressionType[] compressors) throws IllegalPathException {
        for (String measurement : measurements) {
            if (!this.schemaMap.containsKey(measurement)) continue;
            throw new IllegalPathException(measurement, "path already exists");
        }
        for (int i = 0; i < measurements.length; ++i) {
            IMeasurementSchema schema = this.constructSchema(measurements[i], dataTypes[i], encodings[i], compressors[i]);
            this.schemaMap.put(measurements[i], schema);
        }
    }

    public void addMeasurement(String measurement, TSDataType dataType, TSEncoding encoding, CompressionType compressionType) {
        this.schemaMap.put(measurement, this.constructSchema(measurement, dataType, encoding, compressionType));
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)this.id, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Boolean)this.isDirectAligned, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.schemaMap.size(), (ByteBuffer)buffer);
        for (Map.Entry<String, IMeasurementSchema> entry : this.schemaMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)buffer);
            entry.getValue().partialSerializeTo(buffer);
        }
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.id, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isDirectAligned, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.schemaMap.size(), (OutputStream)outputStream);
        for (Map.Entry<String, IMeasurementSchema> entry : this.schemaMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            entry.getValue().partialSerializeTo(outputStream);
        }
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.serialize(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.id = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.isDirectAligned = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        int schemaSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.schemaMap = new ConcurrentHashMap<String, IMeasurementSchema>(schemaSize);
        for (int i = 0; i < schemaSize; ++i) {
            String schemaName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            byte flag = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
            MeasurementSchema measurementSchema = null;
            if (flag == 0) {
                measurementSchema = MeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer);
            } else if (flag == 1) {
                measurementSchema = VectorMeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer);
            }
            this.schemaMap.put(schemaName, (IMeasurementSchema)measurementSchema);
        }
    }

    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        if (t == null || this.getClass() != t.getClass()) {
            return false;
        }
        Template that = (Template)t;
        return this.name.equals(that.name) && this.schemaMap.equals(that.schemaMap);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.schemaMap).toHashCode();
    }
}

