/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.AlignedResourceByPathUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MeasurementResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;

public abstract class ResourceByPathUtils {
    public static ResourceByPathUtils getResourceInstance(PartialPath path) {
        if (path instanceof AlignedPath) {
            return new AlignedResourceByPathUtils(path);
        }
        if (path instanceof MeasurementPath) {
            return new MeasurementResourceByPathUtils(path);
        }
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public abstract ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> var1, List<IChunkMetadata> var2) throws IOException;

    public abstract ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(QueryContext var1, IMemTable var2, List<Pair<Modification, IMemTable>> var3, long var4) throws QueryProcessException, IOException;

    public abstract List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter var1, TsFileResource var2, QueryContext var3);

    protected List<Modification> getModificationsForMemtable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        boolean foundMemtable = false;
        for (Pair<Modification, IMemTable> entry : modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((Modification)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }
}

