/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaPageOverflowException;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionCachedMetric;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.RecordUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.IPageManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.PageIOChannel;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.PagePool;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.SchemaPageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageManager
implements IPageManager {
    protected static final Logger logger = LoggerFactory.getLogger(PageManager.class);
    protected final PagePool pagePool = new PagePool();
    protected final PageIOChannel pageIOChannel;
    protected final Map<Long, SchemaPageContext> threadContexts = new ConcurrentHashMap<Long, SchemaPageContext>();
    protected final AtomicInteger lastPageIndex;
    private SchemaRegionCachedMetric metric = null;

    PageManager(FileChannel channel, File pmtFile, int lastPageIndex, String logPath) throws IOException, MetadataException {
        this.lastPageIndex = lastPageIndex >= 0 ? new AtomicInteger(lastPageIndex) : new AtomicInteger(0);
        this.pageIOChannel = IoTDBDescriptor.getInstance().getConfig().getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") ? new PageIOChannel(channel, pmtFile, false, logPath) : new PageIOChannel(channel, pmtFile, true, logPath);
        if (lastPageIndex < 0) {
            ISegmentedPage rootPage = ISchemaPage.initSegmentedPage(ByteBuffer.allocate(16384), 0);
            rootPage.allocNewSegment((short)16350);
            this.pagePool.put(rootPage);
            rootPage.syncPageBuffer();
            rootPage.flushPageToChannel(channel);
        }
    }

    @Override
    public void writeMNode(ICachedMNode node) throws MetadataException, IOException {
        SchemaPageContext cxt = new SchemaPageContext();
        this.threadContexts.put(Thread.currentThread().getId(), cxt);
        this.pagePool.cacheGuardian();
        this.entrantLock(node, cxt);
        try {
            this.writeNewChildren(node, cxt);
            this.writeUpdatedChildren(node, cxt);
            this.flushDirtyPages(cxt);
        }
        finally {
            this.releaseLocks(cxt);
            this.pagePool.releaseReferent(cxt);
            this.threadContexts.remove(Thread.currentThread().getId(), cxt);
        }
    }

    protected void releaseLocks(SchemaPageContext cxt) {
        for (int i : cxt.lockTraces) {
            cxt.referredPages.get(i).getLock().writeLock().unlock();
        }
    }

    protected void entrantLock(ICachedMNode node, SchemaPageContext cxt) throws IOException, MetadataException {
        int initPageIndex = SchemaFile.getPageIndex(SchemaFile.getNodeAddress(node));
        if (node.isDatabase()) {
            if (initPageIndex < 0) {
                return;
            }
            ISchemaPage page = this.getPageInstance(initPageIndex, cxt);
            page.getLock().writeLock().lock();
            cxt.traceLock(page);
            cxt.indexBuckets.sortIntoBucket(page, (short)-1);
        } else {
            int parIndex = SchemaFile.getPageIndex(SchemaFile.getNodeAddress((ICachedMNode)node.getParent()));
            int minPageIndex = Math.min(initPageIndex, parIndex);
            int maxPageIndex = Math.max(initPageIndex, parIndex);
            ISchemaPage page = this.getPageInstance(initPageIndex, cxt);
            if (page.getAsInternalPage() != null) {
                page.getLock().writeLock().lock();
                cxt.traceLock(page);
                cxt.indexBuckets.sortIntoBucket(page, (short)-1);
                return;
            }
            if (minPageIndex >= 0) {
                page = this.getPageInstance(minPageIndex, cxt);
                page.getLock().writeLock().lock();
                cxt.traceLock(page);
                cxt.indexBuckets.sortIntoBucket(page, (short)-1);
            }
            if (minPageIndex != maxPageIndex && maxPageIndex >= 0) {
                page = this.getPageInstance(maxPageIndex, cxt);
                page.getLock().writeLock().lock();
                cxt.traceLock(page);
                cxt.indexBuckets.sortIntoBucket(page, (short)-1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeNewChildren(ICachedMNode node, SchemaPageContext cxt) throws MetadataException, IOException {
        long curSegAddr = SchemaFile.getNodeAddress(node);
        for (Map.Entry entry : ICachedMNodeContainer.getCachedMNodeContainer(node).getNewChildBuffer().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
            int subIndex;
            String alias;
            ICachedMNode child = (ICachedMNode)entry.getValue();
            if (!child.isMeasurement()) {
                alias = null;
                if (SchemaFile.getNodeAddress(child) >= 0L) throw new MetadataException("A child in newChildBuffer shall not have segmentAddress.");
                short estSegSize = PageManager.estimateSegmentSize(child);
                long glbIndex = this.preAllocateSegment(estSegSize, cxt);
                SchemaFile.setNodeAddress(child, glbIndex);
            } else {
                alias = child.getAsMeasurementMNode().getAlias() == null ? null : child.getAsMeasurementMNode().getAlias();
            }
            ByteBuffer childBuffer = RecordUtils.node2Buffer(child);
            long actualAddress = this.getTargetSegmentAddress(curSegAddr, (String)entry.getKey(), cxt);
            ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(actualAddress), cxt);
            try {
                curPage.getAsSegmentedPage().write(SchemaFile.getSegIndex(actualAddress), (String)entry.getKey(), childBuffer);
                this.interleavedFlush(curPage, cxt);
                cxt.markDirty(curPage);
                subIndex = this.subIndexRootPage(curSegAddr, cxt);
                if (alias == null || subIndex < 0) continue;
                this.insertSubIndexEntry(subIndex, alias, (String)entry.getKey(), cxt);
            }
            catch (SchemaPageOverflowException e) {
                if (curPage.getAsSegmentedPage().getSegmentSize(SchemaFile.getSegIndex(actualAddress)) == 16350) {
                    this.multiPageInsertOverflowOperation(curPage, (String)entry.getKey(), childBuffer, cxt);
                    subIndex = this.subIndexRootPage(curSegAddr, cxt);
                    if (node.isDevice() && subIndex < 0) {
                        this.buildSubIndex(node, cxt);
                        continue;
                    }
                    if (alias == null) continue;
                    this.insertSubIndexEntry(subIndex, alias, (String)entry.getKey(), cxt);
                    continue;
                }
                short actSegId = SchemaFile.getSegIndex(actualAddress);
                short newSegSize = PageManager.reEstimateSegSize(curPage.getAsSegmentedPage().getSegmentSize(actSegId) + childBuffer.capacity(), ICachedMNodeContainer.getCachedMNodeContainer(node).getNewChildBuffer().entrySet().size());
                ISegmentedPage newPage = this.getMinApplSegmentedPageInMem(newSegSize, cxt);
                curSegAddr = newPage.transplantSegment(curPage.getAsSegmentedPage(), actSegId, newSegSize);
                newPage.write(SchemaFile.getSegIndex(curSegAddr), (String)entry.getKey(), childBuffer);
                curPage.getAsSegmentedPage().deleteSegment(actSegId);
                cxt.indexBuckets.sortIntoBucket(curPage, (short)-1);
                SchemaFile.setNodeAddress(node, curSegAddr);
                this.updateParentalRecord((ICachedMNode)node.getParent(), node.getName(), curSegAddr, cxt);
                cxt.markDirty(curPage);
            }
        }
    }

    private void writeUpdatedChildren(ICachedMNode node, SchemaPageContext cxt) throws MetadataException, IOException {
        long curSegAddr = SchemaFile.getNodeAddress(node);
        for (Map.Entry<String, ICachedMNode> entry : ICachedMNodeContainer.getCachedMNodeContainer(node).getUpdatedChildBuffer().entrySet()) {
            int subIndex;
            boolean insertNewSubEntry;
            boolean removeOldSubEntry;
            ICachedMNode oldChild;
            ICachedMNode child = entry.getValue();
            long actualAddress = this.getTargetSegmentAddress(curSegAddr, entry.getKey(), cxt);
            ByteBuffer childBuffer = RecordUtils.node2Buffer(child);
            ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(actualAddress), cxt);
            if (curPage.getAsSegmentedPage().read(SchemaFile.getSegIndex(actualAddress), entry.getKey()) == null) {
                throw new MetadataException(String.format("Node[%s] has no child[%s] in pbtree file.", node.getName(), entry.getKey()));
            }
            String alias = child.isMeasurement() && child.getAsMeasurementMNode().getAlias() != null ? child.getAsMeasurementMNode().getAlias() : null;
            String oldAlias = node.isDevice() ? ((oldChild = curPage.getAsSegmentedPage().read(SchemaFile.getSegIndex(actualAddress), entry.getKey())).isMeasurement() ? oldChild.getAsMeasurementMNode().getAlias() : null) : null;
            if (alias == null && oldAlias != null) {
                removeOldSubEntry = true;
                insertNewSubEntry = false;
            } else if (alias != null && oldAlias == null) {
                removeOldSubEntry = false;
                insertNewSubEntry = true;
            } else if (alias != null && alias.compareTo(oldAlias) != 0) {
                removeOldSubEntry = true;
                insertNewSubEntry = true;
            } else {
                removeOldSubEntry = false;
                insertNewSubEntry = false;
            }
            try {
                curPage.getAsSegmentedPage().update(SchemaFile.getSegIndex(actualAddress), entry.getKey(), childBuffer);
                this.interleavedFlush(curPage, cxt);
                cxt.markDirty(curPage);
                subIndex = this.subIndexRootPage(curSegAddr, cxt);
                if (subIndex < 0) continue;
                if (removeOldSubEntry) {
                    this.removeSubIndexEntry(subIndex, oldAlias, cxt);
                }
                if (!insertNewSubEntry) continue;
                this.insertSubIndexEntry(subIndex, alias, entry.getKey(), cxt);
            }
            catch (SchemaPageOverflowException e) {
                if (curPage.getAsSegmentedPage().getSegmentSize(SchemaFile.getSegIndex(actualAddress)) == 16350) {
                    this.multiPageUpdateOverflowOperation(curPage, entry.getKey(), childBuffer, cxt);
                    subIndex = this.subIndexRootPage(curSegAddr, cxt);
                    if (node.isDevice() && subIndex < 0) {
                        this.buildSubIndex(node, cxt);
                        continue;
                    }
                    if (!insertNewSubEntry && !removeOldSubEntry) continue;
                    if (removeOldSubEntry) {
                        this.removeSubIndexEntry(subIndex, oldAlias, cxt);
                    }
                    if (!insertNewSubEntry) continue;
                    this.insertSubIndexEntry(subIndex, alias, entry.getKey(), cxt);
                    continue;
                }
                short actSegId = SchemaFile.getSegIndex(actualAddress);
                short newSegSiz = PageManager.reEstimateSegSize(curPage.getAsSegmentedPage().getSegmentSize(actSegId) + childBuffer.capacity());
                ISegmentedPage newPage = this.getMinApplSegmentedPageInMem(newSegSiz, cxt);
                curSegAddr = newPage.transplantSegment(curPage.getAsSegmentedPage(), actSegId, newSegSiz);
                curPage.getAsSegmentedPage().deleteSegment(actSegId);
                cxt.indexBuckets.sortIntoBucket(curPage, (short)-1);
                newPage.update(SchemaFile.getSegIndex(curSegAddr), entry.getKey(), childBuffer);
                SchemaFile.setNodeAddress(node, curSegAddr);
                this.updateParentalRecord((ICachedMNode)node.getParent(), node.getName(), curSegAddr, cxt);
                cxt.markDirty(curPage);
            }
        }
    }

    protected abstract long getTargetSegmentAddress(long var1, String var3, SchemaPageContext var4) throws IOException, MetadataException;

    protected abstract void multiPageInsertOverflowOperation(ISchemaPage var1, String var2, ByteBuffer var3, SchemaPageContext var4) throws MetadataException, IOException;

    protected abstract void multiPageUpdateOverflowOperation(ISchemaPage var1, String var2, ByteBuffer var3, SchemaPageContext var4) throws MetadataException, IOException;

    protected abstract void buildSubIndex(ICachedMNode var1, SchemaPageContext var2) throws MetadataException, IOException;

    protected abstract void insertSubIndexEntry(int var1, String var2, String var3, SchemaPageContext var4) throws MetadataException, IOException;

    protected abstract void removeSubIndexEntry(int var1, String var2, SchemaPageContext var3) throws MetadataException, IOException;

    protected abstract String searchSubIndexAlias(int var1, String var2, SchemaPageContext var3) throws MetadataException, IOException;

    public synchronized void flushDirtyPages(SchemaPageContext cxt) throws IOException {
        if (cxt.dirtyCnt == 0) {
            return;
        }
        this.pageIOChannel.flushMultiPages(cxt);
        this.pagePool.appendBucketIndex(cxt);
        if (this.metric != null) {
            this.metric.recordFlushPageNum(cxt.referredPages.size());
        }
    }

    @Deprecated
    private void interleavedFlush(ISchemaPage page, SchemaPageContext cxt) throws IOException {
        if (cxt.lastLeafPage == null || cxt.lastLeafPage.getPageIndex() == page.getPageIndex()) {
            return;
        }
        ++cxt.interleavedFlushCnt;
        if (this.metric != null) {
            this.metric.recordFlushPageNum(1);
        }
        this.pageIOChannel.flushSinglePage(cxt.lastLeafPage);
        --cxt.dirtyCnt;
        if (cxt.lockTraces.contains(cxt.lastLeafPage.getPageIndex())) {
            cxt.lastLeafPage.getLock().writeLock().unlock();
            cxt.lockTraces.remove(cxt.lastLeafPage.getPageIndex());
        }
        cxt.lastLeafPage.decrementAndGetRefCnt();
        cxt.referredPages.remove(cxt.lastLeafPage.getPageIndex());
        this.pagePool.remove(cxt.lastLeafPage.getPageIndex());
        cxt.lastLeafPage = page.getAsSegmentedPage();
    }

    @Override
    public int getLastPageIndex() {
        return this.lastPageIndex.get();
    }

    @Override
    public void clear() throws IOException, MetadataException {
        this.pagePool.clear();
        this.lastPageIndex.set(0);
        this.pageIOChannel.renewLogWriter();
    }

    @Override
    public void inspect(PrintWriter pw) throws IOException, MetadataException {
        SchemaPageContext cxt = new SchemaPageContext();
        for (int i = 0; i <= this.lastPageIndex.get(); ++i) {
            String pageContent = this.getPageInstance(i, cxt).inspect();
            pw.print("---------------------\n");
            pw.print(pageContent);
            pw.print("\n");
        }
    }

    @Override
    public void close() throws IOException {
        this.pageIOChannel.closeLogWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISchemaPage getPageInstance(int pageIdx, SchemaPageContext cxt) throws IOException, MetadataException {
        if (pageIdx > this.lastPageIndex.get()) {
            throw new MetadataException(String.format("Page index %d out of range.", pageIdx));
        }
        if (cxt != null && cxt.referredPages.containsKey(pageIdx)) {
            return cxt.referredPages.get(pageIdx);
        }
        this.pagePool.lock();
        try {
            ISchemaPage page = this.pagePool.get(pageIdx);
            if (page != null) {
                cxt.refer(page);
                ISchemaPage iSchemaPage = page;
                return iSchemaPage;
            }
            ByteBuffer newBuf = ByteBuffer.allocate(16384);
            if (this.metric != null) {
                this.metric.recordLoadPageNum(1);
            }
            this.pageIOChannel.loadFromFileToBuffer(newBuf, pageIdx);
            page = ISchemaPage.loadSchemaPage(newBuf);
            cxt.refer(page);
            this.pagePool.put(page);
            ISchemaPage iSchemaPage = page;
            return iSchemaPage;
        }
        finally {
            this.pagePool.unlock();
        }
    }

    private long preAllocateSegment(short size, SchemaPageContext cxt) throws IOException, MetadataException {
        ISegmentedPage page = this.getMinApplSegmentedPageInMem(size, cxt);
        return SchemaFile.getGlobalIndex(page.getPageIndex(), page.allocNewSegment(size));
    }

    protected ISchemaPage replacePageInCache(ISchemaPage page, SchemaPageContext cxt) {
        cxt.markDirty(page, true);
        this.pagePool.put(page);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISegmentedPage getMinApplSegmentedPageInMem(short size, SchemaPageContext cxt) {
        ISchemaPage targetPage = cxt.indexBuckets.getNearestFitPage(size, false);
        if (targetPage != null) {
            cxt.indexBuckets.sortIntoBucket(targetPage, size);
            return targetPage.getAsSegmentedPage();
        }
        this.pagePool.lock();
        try {
            targetPage = this.pagePool.getNearestFitPage(size);
            if (targetPage != null) {
                cxt.markDirty(targetPage);
                cxt.traceLock(targetPage);
                cxt.indexBuckets.sortIntoBucket(targetPage, size);
                ISegmentedPage iSegmentedPage = targetPage.getAsSegmentedPage();
                return iSegmentedPage;
            }
            targetPage = this.allocNewSegmentedPage(cxt);
            cxt.indexBuckets.sortIntoBucket(targetPage, size);
            ISegmentedPage iSegmentedPage = targetPage.getAsSegmentedPage();
            return iSegmentedPage;
        }
        finally {
            this.pagePool.unlock();
        }
    }

    protected ISchemaPage allocNewSegmentedPage(SchemaPageContext cxt) {
        ISegmentedPage newPage = ISchemaPage.initSegmentedPage(ByteBuffer.allocate(16384), this.lastPageIndex.incrementAndGet());
        cxt.markDirty(newPage);
        newPage.getLock().writeLock().lock();
        cxt.traceLock(newPage);
        this.pagePool.put(newPage);
        return newPage;
    }

    protected ISchemaPage registerAsNewPage(ISchemaPage page, SchemaPageContext cxt) {
        page.setPageIndex(this.lastPageIndex.incrementAndGet());
        this.pagePool.put(page);
        cxt.markDirty(page);
        return page;
    }

    private void updateParentalRecord(ICachedMNode parent, String key, long newSegAddr, SchemaPageContext cxt) throws IOException, MetadataException {
        if (parent == null || ((ICachedMNode)parent.getChild(key)).isDatabase()) {
            throw new MetadataException("Root page shall not be migrated.");
        }
        long parSegAddr = parent.getParent() == null ? 0L : SchemaFile.getNodeAddress(parent);
        parSegAddr = this.getTargetSegmentAddress(parSegAddr, key, cxt);
        ISchemaPage page = this.getPageInstance(SchemaFile.getPageIndex(parSegAddr), cxt);
        ((SegmentedPage)page).updateRecordSegAddr(SchemaFile.getSegIndex(parSegAddr), key, newSegAddr);
        cxt.markDirty(page);
    }

    private int subIndexRootPage(long addr, SchemaPageContext cxt) throws IOException, MetadataException {
        return this.getPageInstance(SchemaFile.getPageIndex(addr), cxt).getSubIndex();
    }

    private static long getPageAddress(int pageIndex) {
        return (0xFFFFFFFFL & (long)pageIndex) * 16384L + (long)SchemaFileConfig.FILE_HEADER_SIZE;
    }

    private static short estimateSegmentSize(ICachedMNode node) {
        int childNum = node.getChildren().size();
        if (childNum < SchemaFileConfig.SEG_SIZE_METRIC[0]) {
            int totalSize = 25 + 6 * childNum;
            for (ICachedMNode child : node.getChildren().values()) {
                totalSize += child.getName().getBytes().length + RecordUtils.getRecordLength(child);
            }
            return (short)totalSize > SchemaFileConfig.SEG_MIN_SIZ ? (short)totalSize : SchemaFileConfig.SEG_MIN_SIZ;
        }
        for (int tier = SchemaFileConfig.SEG_SIZE_LST.length - 1; tier > 0; --tier) {
            if (childNum <= SchemaFileConfig.SEG_SIZE_METRIC[tier]) continue;
            return SchemaFileConfig.SEG_SIZE_LST[tier];
        }
        return SchemaFileConfig.SEG_SIZE_LST[0];
    }

    private static short reEstimateSegSize(int expSize, int batchSize) throws MetadataException {
        if (batchSize < SchemaFileConfig.SEG_SIZE_METRIC[0]) {
            return PageManager.reEstimateSegSize(expSize);
        }
        int base_tier = 0;
        for (int i = 0; i < SchemaFileConfig.SEG_SIZE_LST.length; ++i) {
            if (SchemaFileConfig.SEG_SIZE_LST[i] < expSize) continue;
            base_tier = i;
            break;
        }
        for (int tier = SchemaFileConfig.SEG_SIZE_LST.length - 1; tier >= base_tier; --tier) {
            if (batchSize <= SchemaFileConfig.SEG_SIZE_METRIC[tier]) continue;
            return SchemaFileConfig.SEG_SIZE_LST[tier];
        }
        return SchemaFileConfig.SEG_SIZE_LST[base_tier];
    }

    private static short reEstimateSegSize(int expSize) throws MetadataException {
        if (expSize > 16350) {
            throw new MetadataException("Single record larger than half page is not supported in SchemaFile now.");
        }
        for (short size : SchemaFileConfig.SEG_SIZE_LST) {
            if (expSize >= size) continue;
            return size;
        }
        return 16350;
    }

    public String checkAllContexts() {
        StringBuilder builder = new StringBuilder();
        for (SchemaPageContext cxt : this.threadContexts.values()) {
            builder.append(String.format("cxt[%d] has %d pages, %d lock trace\n", cxt.threadID, cxt.referredPages.size(), cxt.lockTraces.size()));
        }
        return builder.toString();
    }

    public static String checkContextLock(SchemaPageContext cxt) {
        StringBuilder builder = new StringBuilder();
        for (ISchemaPage page : cxt.referredPages.values()) {
            builder.append(String.format("page:%d, wl:%d, rl:%d, trace:%b, dirty:%b;\n", page.getPageIndex(), ((ReentrantReadWriteLock)page.getLock()).getWriteHoldCount(), ((ReentrantReadWriteLock)page.getLock()).getReadLockCount(), cxt.lockTraces.contains(page.getPageIndex()), page.isDirtyPage()));
        }
        return builder.toString();
    }

    public long getTargetSegmentAddressOnTest(long curSegAddr, String recKey) throws IOException, MetadataException {
        return this.getTargetSegmentAddress(curSegAddr, recKey, new SchemaPageContext());
    }

    public ISchemaPage getPageInstanceOnTest(int pageIdx) throws IOException, MetadataException {
        SchemaPageContext cxt = new SchemaPageContext();
        return this.getPageInstance(pageIdx, cxt);
    }

    @Override
    public void setMetric(SchemaRegionCachedMetric metric) {
        this.metric = metric;
    }
}

