/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.apache.iotdb.commons.schema.tree.SchemaIterator;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementInBlackListException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.template.DifferentTemplateException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionCachedMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.CachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.PBTreeFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.EntityCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MeasurementCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.counter.EntityCounter;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.updater.EntityUpdater;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.updater.MeasurementUpdater;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowDevicesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowNodesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowDevicesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowNodesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.TimeseriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl.SchemaReaderLimitOffsetWrapper;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl.TimeseriesReaderWithViewFetch;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaFormatUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.filter.DeviceFilterVisitor;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTreeBelowSGCachedImpl {
    private static final Logger logger = LoggerFactory.getLogger(MTreeBelowSGCachedImpl.class);
    private final CachedMTreeStore store;
    private volatile ICachedMNode storageGroupMNode;
    private final ICachedMNode rootNode;
    private final Function<IMeasurementMNode<ICachedMNode>, Map<String, String>> tagGetter;
    private final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
    private final int levelOfSG;
    private final CachedSchemaRegionStatistics regionStatistics;

    public MTreeBelowSGCachedImpl(PartialPath storageGroupPath, Function<IMeasurementMNode<ICachedMNode>, Map<String, String>> tagGetter, Runnable flushCallback, final Consumer<IMeasurementMNode<ICachedMNode>> measurementProcess, final Consumer<IDeviceMNode<ICachedMNode>> deviceProcess, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, SchemaRegionCachedMetric metric) throws MetadataException, IOException {
        this.tagGetter = tagGetter;
        this.regionStatistics = regionStatistics;
        this.store = PBTreeFactory.getInstance().createNewCachedMTreeStore(storageGroupPath, schemaRegionId, regionStatistics, metric, flushCallback);
        this.storageGroupMNode = this.store.getRoot();
        this.storageGroupMNode.setParent((ICachedMNode)this.storageGroupMNode.getParent());
        this.rootNode = this.store.generatePrefix(storageGroupPath);
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
        try (MNodeCollector<Void, ICachedMNode> collector = new MNodeCollector<Void, ICachedMNode>(this.rootNode, new PartialPath(this.storageGroupMNode.getFullPath()), (IMTreeStore)this.store, true, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMNode(ICachedMNode node) {
                if (node.isMeasurement()) {
                    measurementProcess.accept(node.getAsMeasurementMNode());
                } else if (node.isDevice()) {
                    deviceProcess.accept(node.getAsDeviceMNode());
                }
                return null;
            }
        };){
            collector.traverse();
        }
    }

    private MTreeBelowSGCachedImpl(PartialPath storageGroupPath, CachedMTreeStore store, final Consumer<IMeasurementMNode<ICachedMNode>> measurementProcess, final Consumer<IDeviceMNode<ICachedMNode>> deviceProcess, Function<IMeasurementMNode<ICachedMNode>, Map<String, String>> tagGetter, CachedSchemaRegionStatistics regionStatistics) throws MetadataException {
        this.store = store;
        this.regionStatistics = regionStatistics;
        this.storageGroupMNode = store.getRoot();
        this.rootNode = store.generatePrefix(storageGroupPath);
        this.levelOfSG = this.storageGroupMNode.getPartialPath().getNodeLength() - 1;
        this.tagGetter = tagGetter;
        try (MNodeCollector<Void, ICachedMNode> collector = new MNodeCollector<Void, ICachedMNode>(this.rootNode, new PartialPath(this.storageGroupMNode.getFullPath()), (IMTreeStore)this.store, true, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMNode(ICachedMNode node) {
                if (node.isMeasurement()) {
                    measurementProcess.accept(node.getAsMeasurementMNode());
                } else if (node.isDevice()) {
                    deviceProcess.accept(node.getAsDeviceMNode());
                }
                return null;
            }
        };){
            collector.traverse();
        }
    }

    public void clear() {
        this.store.clear();
        this.storageGroupMNode = null;
    }

    public boolean createSnapshot(File snapshotDir) {
        return this.store.createSnapshot(snapshotDir);
    }

    public static MTreeBelowSGCachedImpl loadFromSnapshot(File snapshotDir, String storageGroupFullPath, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, SchemaRegionCachedMetric metric, Consumer<IMeasurementMNode<ICachedMNode>> measurementProcess, Consumer<IDeviceMNode<ICachedMNode>> deviceProcess, Function<IMeasurementMNode<ICachedMNode>, Map<String, String>> tagGetter, Runnable flushCallback) throws IOException, MetadataException {
        return new MTreeBelowSGCachedImpl(new PartialPath(storageGroupFullPath), PBTreeFactory.getInstance().createCachedMTreeStoreFromSnapshot(snapshotDir, storageGroupFullPath, schemaRegionId, regionStatistics, metric, flushCallback), measurementProcess, deviceProcess, tagGetter, regionStatistics);
    }

    public IMeasurementMNode<ICachedMNode> createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        IMeasurementMNode<ICachedMNode> measurementMNode = this.createTimeseriesWithPinnedReturn(path, dataType, encoding, compressor, props, alias);
        this.unPinMNode((ICachedMNode)measurementMNode.getAsMNode());
        return measurementMNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode<ICachedMNode> createTimeseriesWithPinnedReturn(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        ICachedMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        try {
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                IMeasurementMNode iMeasurementMNode;
                ICachedMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
                try {
                    IDeviceMNode<ICachedMNode> entityMNode;
                    MetaFormatUtils.checkTimeseriesProps(path.getFullPath(), props);
                    String leafName = path.getMeasurement();
                    if (alias != null && this.store.hasChild(device, alias)) {
                        throw new AliasAlreadyExistException(path.getFullPath(), alias);
                    }
                    if (this.store.hasChild(device, leafName)) {
                        throw new PathAlreadyExistException(path.getFullPath());
                    }
                    if (device.isDevice() && device.getAsDeviceMNode().isAlignedNullable() != null && device.getAsDeviceMNode().isAligned()) {
                        throw new AlignedTimeseriesException("timeseries under this device is aligned, please use createAlignedTimeseries or change device.", device.getFullPath());
                    }
                    if (device.isDevice()) {
                        entityMNode = device.getAsDeviceMNode();
                    } else {
                        entityMNode = this.store.setToEntity(device);
                        device = (ICachedMNode)entityMNode.getAsMNode();
                    }
                    if (entityMNode.isAlignedNullable() == null) {
                        entityMNode.setAligned(Boolean.valueOf(false));
                    }
                    IMeasurementMNode measurementMNode = this.nodeFactory.createMeasurementMNode(entityMNode, leafName, (IMeasurementSchema)new MeasurementSchema(leafName, dataType, encoding, compressor, props), alias);
                    this.store.addChild((ICachedMNode)entityMNode.getAsMNode(), leafName, (ICachedMNode)measurementMNode.getAsMNode());
                    if (alias != null) {
                        entityMNode.addAlias(alias, measurementMNode);
                    }
                    iMeasurementMNode = measurementMNode;
                    this.unPinMNode(device);
                }
                catch (Throwable throwable) {
                    this.unPinMNode(device);
                    throw throwable;
                }
                return iMeasurementMNode;
            }
        }
        finally {
            if (deviceParent != null) {
                this.unPinMNode(deviceParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMeasurementMNode<ICachedMNode>> createAlignedTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList) throws MetadataException {
        ArrayList<IMeasurementMNode<ICachedMNode>> measurementMNodeList = new ArrayList<IMeasurementMNode<ICachedMNode>>();
        MetaFormatUtils.checkSchemaMeasurementNames(measurements);
        ICachedMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        try {
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                ArrayList<IMeasurementMNode<ICachedMNode>> arrayList;
                ICachedMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
                try {
                    IDeviceMNode<ICachedMNode> entityMNode;
                    for (int i = 0; i < measurements.size(); ++i) {
                        if (this.store.hasChild(device, measurements.get(i))) {
                            throw new PathAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i));
                        }
                        if (aliasList == null || aliasList.get(i) == null || !this.store.hasChild(device, aliasList.get(i))) continue;
                        throw new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), aliasList.get(i));
                    }
                    if (device.isDevice() && device.getAsDeviceMNode().isAlignedNullable() != null && !device.getAsDeviceMNode().isAligned()) {
                        throw new AlignedTimeseriesException("Timeseries under this device is not aligned, please use createTimeseries or change device.", devicePath.getFullPath());
                    }
                    if (device.isDevice()) {
                        entityMNode = device.getAsDeviceMNode();
                    } else {
                        entityMNode = this.store.setToEntity(device);
                        entityMNode.setAligned(Boolean.valueOf(true));
                        device = (ICachedMNode)entityMNode.getAsMNode();
                    }
                    if (entityMNode.isAlignedNullable() == null) {
                        entityMNode.setAligned(Boolean.valueOf(true));
                    }
                    for (int i = 0; i < measurements.size(); ++i) {
                        IMeasurementMNode measurementMNode = this.nodeFactory.createMeasurementMNode(entityMNode, measurements.get(i), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i)), aliasList == null ? null : aliasList.get(i));
                        this.store.addChild((ICachedMNode)entityMNode.getAsMNode(), measurements.get(i), (ICachedMNode)measurementMNode.getAsMNode());
                        if (aliasList != null && aliasList.get(i) != null) {
                            entityMNode.addAlias(aliasList.get(i), measurementMNode);
                        }
                        measurementMNodeList.add((IMeasurementMNode<ICachedMNode>)measurementMNode);
                    }
                    arrayList = measurementMNodeList;
                    this.unPinMNode(device);
                }
                catch (Throwable throwable) {
                    this.unPinMNode(device);
                    throw throwable;
                }
                return arrayList;
            }
        }
        finally {
            if (deviceParent != null) {
                this.unPinMNode(deviceParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeAlias(String alias, PartialPath fullPath) throws MetadataException {
        IMeasurementMNode<ICachedMNode> measurementMNode = this.getMeasurementMNode(fullPath);
        try {
            if (alias != null && !alias.equals(measurementMNode.getAlias())) {
                MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
                synchronized (mTreeBelowSGCachedImpl) {
                    IDeviceMNode device = ((ICachedMNode)measurementMNode.getParent()).getAsDeviceMNode();
                    ICachedMNode cachedMNode = this.store.getChild((ICachedMNode)device.getAsMNode(), alias);
                    if (cachedMNode != null) {
                        this.unPinMNode(cachedMNode);
                        throw new MetadataException("The alias is duplicated with the name or alias of other measurement.");
                    }
                    if (measurementMNode.getAlias() != null) {
                        device.deleteAliasChild(measurementMNode.getAlias());
                    }
                    device.addAlias(alias, measurementMNode);
                    this.setAlias(measurementMNode, alias);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unPinMNode((ICachedMNode)measurementMNode.getAsMNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        ICachedMNode device;
        try {
            device = this.getNodeByPath(devicePath);
        }
        catch (MetadataException e) {
            return Collections.emptyMap();
        }
        try {
            if (!device.isDevice()) {
                Map<Integer, MetadataException> e = Collections.emptyMap();
                return e;
            }
            HashMap<Integer, MetadataException> failingMeasurementMap = new HashMap<Integer, MetadataException>();
            for (int i = 0; i < measurementList.size(); ++i) {
                ICachedMNode node = null;
                try {
                    node = this.store.getChild(device, measurementList.get(i));
                    if (node != null) {
                        if (node.isMeasurement()) {
                            if (node.getAsMeasurementMNode().isPreDeleted()) {
                                failingMeasurementMap.put(i, new MeasurementInBlackListException(devicePath.concatNode(measurementList.get(i))));
                            } else {
                                failingMeasurementMap.put(i, new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), node.getAsMeasurementMNode().getMeasurementPath()));
                            }
                        } else {
                            failingMeasurementMap.put(i, new PathAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i)));
                        }
                    }
                    if (aliasList != null && aliasList.get(i) != null && this.store.hasChild(device, aliasList.get(i))) {
                        failingMeasurementMap.put(i, new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), aliasList.get(i)));
                    }
                    if (node == null) continue;
                    this.unPinMNode(node);
                    continue;
                }
                catch (MetadataException e) {
                    try {
                        failingMeasurementMap.put(i, e);
                        if (node == null) continue;
                        this.unPinMNode(node);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (node != null) {
                            this.unPinMNode(node);
                        }
                        throw throwable;
                    }
                }
            }
            HashMap<Integer, MetadataException> hashMap = failingMeasurementMap;
            return hashMap;
        }
        finally {
            this.unPinMNode(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedMNode checkAndAutoCreateInternalPath(PartialPath devicePath) throws MetadataException {
        String[] nodeNames = devicePath.getNodes();
        MetaFormatUtils.checkTimeseries(devicePath);
        if (nodeNames.length == this.levelOfSG + 1) {
            return null;
        }
        ICachedMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodeNames.length - 1; ++i) {
                String childName = nodeNames[i];
                ICachedMNode child = this.store.getChild(cur, childName);
                if (child == null) {
                    child = this.store.addChild(cur, childName, (ICachedMNode)this.nodeFactory.createInternalMNode((IMNode)cur, childName));
                }
                if (!(cur = child).isMeasurement()) continue;
                throw new PathAlreadyExistException(cur.getFullPath());
            }
            this.pinMNode(cur);
            ICachedMNode iCachedMNode = cur;
            return iCachedMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    private ICachedMNode checkAndAutoCreateDeviceNode(String deviceName, ICachedMNode deviceParent) throws MetadataException {
        if (deviceParent == null) {
            this.pinMNode(this.storageGroupMNode);
            return this.storageGroupMNode;
        }
        ICachedMNode device = this.store.getChild(deviceParent, deviceName);
        if (device == null) {
            device = this.store.addChild(deviceParent, deviceName, (ICachedMNode)this.nodeFactory.createInternalMNode((IMNode)deviceParent, deviceName));
        }
        if (device.isMeasurement()) {
            throw new PathAlreadyExistException(device.getFullPath());
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode<ICachedMNode> deleteTimeseries(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMeasurementMNode<ICachedMNode> deletedNode = this.getMeasurementMNode(path);
        ICachedMNode parent = (ICachedMNode)deletedNode.getParent();
        MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
        synchronized (mTreeBelowSGCachedImpl) {
            this.store.deleteChild(parent, path.getMeasurement());
            if (deletedNode.getAlias() != null) {
                parent.getAsDeviceMNode().deleteAliasChild(deletedNode.getAlias());
            }
        }
        this.deleteAndUnpinEmptyInternalMNode((IDeviceMNode<ICachedMNode>)parent.getAsDeviceMNode());
        return deletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAndUnpinEmptyInternalMNode(IDeviceMNode<ICachedMNode> entityMNode) throws MetadataException {
        MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl;
        ICachedMNode curNode = (ICachedMNode)entityMNode.getAsMNode();
        if (!entityMNode.isUseTemplate()) {
            mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                boolean hasMeasurement = false;
                boolean hasNonViewMeasurement = false;
                try (IMNodeIterator<ICachedMNode> iterator = this.store.getChildrenIterator(curNode);){
                    while (iterator.hasNext()) {
                        ICachedMNode child = (ICachedMNode)iterator.next();
                        this.unPinMNode(child);
                        if (!child.isMeasurement()) continue;
                        hasMeasurement = true;
                        if (child.getAsMeasurementMNode().isLogicalView()) continue;
                        hasNonViewMeasurement = true;
                        break;
                    }
                }
                if (!hasMeasurement) {
                    curNode = this.store.setToInternal((IDeviceMNode)entityMNode);
                } else if (!hasNonViewMeasurement) {
                    this.store.updateMNode((ICachedMNode)entityMNode.getAsMNode(), o -> o.getAsDeviceMNode().setAligned(null));
                }
            }
        }
        while (true) {
            if (curNode.isDatabase()) {
                return;
            }
            mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                if (!this.isEmptyInternalMNode(curNode)) {
                    break;
                }
                this.store.deleteChild((ICachedMNode)curNode.getParent(), curNode.getName());
                curNode = (ICachedMNode)curNode.getParent();
            }
        }
        this.unPinMNode(curNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmptyInternalMNode(ICachedMNode node) throws MetadataException {
        try (IMNodeIterator<ICachedMNode> iterator = this.store.getChildrenIterator(node);){
            boolean bl = !"root".equals(node.getName()) && !node.isMeasurement() && (!node.isDevice() || !node.getAsDeviceMNode().isUseTemplate()) && !iterator.hasNext();
            return bl;
        }
    }

    public List<PartialPath> constructSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<ICachedMNode> updater = new MeasurementUpdater<ICachedMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<ICachedMNode> node) throws MetadataException {
                this.store.updateMNode((ICachedMNode)node.getAsMNode(), o -> o.getAsMeasurementMNode().setPreDeleted(true));
                result.add(this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode())));
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> rollbackSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<ICachedMNode> updater = new MeasurementUpdater<ICachedMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<ICachedMNode> node) throws MetadataException {
                this.store.updateMNode((ICachedMNode)node.getAsMNode(), o -> o.getAsMeasurementMNode().setPreDeleted(false));
                result.add(this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode())));
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> getPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (MeasurementCollector<Void, ICachedMNode> collector = new MeasurementCollector<Void, ICachedMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<ICachedMNode> node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode())));
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public Set<PartialPath> getDevicesOfPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        try (MeasurementCollector<Void, ICachedMNode> collector = new MeasurementCollector<Void, ICachedMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<ICachedMNode> node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode())).getDevicePath());
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public void setAlias(IMeasurementMNode<ICachedMNode> measurementMNode, String alias) throws MetadataException {
        this.store.setAlias(measurementMNode, alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedMNode getDeviceNodeWithAutoCreating(PartialPath deviceId) throws MetadataException {
        String[] nodeNames = deviceId.getNodes();
        MetaFormatUtils.checkTimeseries(deviceId);
        ICachedMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
                ICachedMNode child = this.store.getChild(cur, nodeNames[i]);
                if (child == null) {
                    child = this.store.addChild(cur, nodeNames[i], (ICachedMNode)this.nodeFactory.createInternalMNode((IMNode)cur, nodeNames[i]));
                }
                cur = child;
            }
            this.pinMNode(cur);
            ICachedMNode iCachedMNode = cur;
            return iCachedMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDeviceNodeExists(PartialPath deviceId) {
        ICachedMNode deviceMNode = null;
        try {
            deviceMNode = this.getNodeByPath(deviceId);
            boolean bl = deviceMNode.isDevice();
            return bl;
        }
        catch (MetadataException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (deviceMNode != null) {
                this.unPinMNode(deviceMNode);
            }
        }
    }

    public ClusterSchemaTree fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap, final boolean withTags, final boolean withTemplate) throws MetadataException {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        try (MeasurementCollector<Void, ICachedMNode> collector = new MeasurementCollector<Void, ICachedMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<ICachedMNode> node) {
                IDeviceMNode deviceMNode = ((ICachedMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode();
                int templateId = deviceMNode.getSchemaTemplateIdWithState();
                if (withTemplate && templateId >= 0) {
                    schemaTree.appendTemplateDevice(deviceMNode.getPartialPath(), deviceMNode.isAligned(), templateId, null);
                    this.skipTemplateChildren(deviceMNode);
                } else {
                    MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                    if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                        path.setMeasurementAlias(node.getAlias());
                    }
                    if (withTags) {
                        path.setTagMap((Map)MTreeBelowSGCachedImpl.this.tagGetter.apply(node));
                    }
                    schemaTree.appendSingleMeasurementPath(path);
                }
                return null;
            }
        };){
            collector.setTemplateMap(templateMap, this.nodeFactory);
            collector.setSkipPreDeletedSchema(true);
            collector.traverse();
        }
        return schemaTree;
    }

    public ClusterSchemaTree fetchSchemaWithoutWildcard(PathPatternTree patternTree, Map<Integer, Template> templateMap, final boolean withTags, final boolean withTemplate) throws MetadataException {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        try (MeasurementCollector<Void, ICachedMNode> collector = new MeasurementCollector<Void, ICachedMNode>(this.rootNode, patternTree, (IMTreeStore)this.store, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<ICachedMNode> node) {
                IDeviceMNode deviceMNode = ((ICachedMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode();
                int templateId = deviceMNode.getSchemaTemplateIdWithState();
                if (withTemplate && templateId >= 0) {
                    schemaTree.appendTemplateDevice(deviceMNode.getPartialPath(), deviceMNode.isAligned(), templateId, null);
                    this.skipTemplateChildren(deviceMNode);
                } else {
                    MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                    path.setMeasurementAlias(node.getAlias());
                    if (withTags) {
                        path.setTagMap((Map)MTreeBelowSGCachedImpl.this.tagGetter.apply(node));
                    }
                    schemaTree.appendSingleMeasurementPath(path);
                }
                return null;
            }
        };){
            collector.setTemplateMap(templateMap, this.nodeFactory);
            collector.setSkipPreDeletedSchema(true);
            collector.traverse();
        }
        return schemaTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedMNode getNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        ICachedMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
                ICachedMNode next = this.store.getChild(cur, nodes[i]);
                if (next == null) {
                    throw new PathNotExistException(path.getFullPath(), true);
                }
                if (next.isMeasurement()) {
                    if (i == nodes.length - 1) {
                        ICachedMNode iCachedMNode = next;
                        return iCachedMNode;
                    }
                    throw new PathNotExistException(path.getFullPath(), true);
                }
                cur = next;
            }
            this.pinMNode(cur);
            ICachedMNode iCachedMNode = cur;
            return iCachedMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    public IMeasurementMNode<ICachedMNode> getMeasurementMNode(PartialPath path) throws MetadataException {
        ICachedMNode node = this.getNodeByPath(path);
        if (node.isMeasurement()) {
            return node.getAsMeasurementMNode();
        }
        this.unPinMNode(node);
        throw new MNodeTypeMismatchException(path.getFullPath(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLogicalView(PartialPath path, ViewExpression viewExpression) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        ICachedMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        try {
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                ICachedMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
                try {
                    IDeviceMNode<ICachedMNode> entityMNode;
                    String leafName = path.getMeasurement();
                    if (this.store.hasChild(device, leafName)) {
                        ICachedMNode node = (ICachedMNode)device.getChild(leafName);
                        if (node.isMeasurement()) {
                            if (node.getAsMeasurementMNode().isPreDeleted()) {
                                throw new MeasurementInBlackListException(path);
                            }
                            throw new MeasurementAlreadyExistException(path.getFullPath(), node.getAsMeasurementMNode().getMeasurementPath());
                        }
                        throw new PathAlreadyExistException(path.getFullPath());
                    }
                    if (device.isDevice()) {
                        entityMNode = device.getAsDeviceMNode();
                    } else {
                        entityMNode = this.store.setToEntity(device);
                        entityMNode.setAligned(null);
                        device = (ICachedMNode)entityMNode.getAsMNode();
                    }
                    IMeasurementMNode viewMNode = this.nodeFactory.createLogicalViewMNode(entityMNode, leafName, (IMeasurementSchema)new LogicalViewSchema(leafName, viewExpression));
                    this.store.addChild((ICachedMNode)entityMNode.getAsMNode(), leafName, (ICachedMNode)viewMNode.getAsMNode());
                    this.unPinMNode((ICachedMNode)viewMNode.getAsMNode());
                }
                finally {
                    this.unPinMNode(device);
                }
            }
        }
        finally {
            if (deviceParent != null) {
                this.unPinMNode(deviceParent);
            }
        }
    }

    public List<PartialPath> constructLogicalViewBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<ICachedMNode> updater = new MeasurementUpdater<ICachedMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<ICachedMNode> node) throws MetadataException {
                if (node.isLogicalView()) {
                    this.store.updateMNode((ICachedMNode)node.getAsMNode(), o -> o.getAsMeasurementMNode().setPreDeleted(true));
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode())));
                }
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> rollbackLogicalViewBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<ICachedMNode> updater = new MeasurementUpdater<ICachedMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<ICachedMNode> node) throws MetadataException {
                if (node.isLogicalView()) {
                    this.store.updateMNode((ICachedMNode)node.getAsMNode(), o -> o.getAsMeasurementMNode().setPreDeleted(false));
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode())));
                }
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> getPreDeletedLogicalView(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (MeasurementCollector<Void, ICachedMNode> collector = new MeasurementCollector<Void, ICachedMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<ICachedMNode> node) {
                if (node.isLogicalView() && node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode())));
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterLogicalView(PartialPath path, ViewExpression expression) throws MetadataException {
        IMeasurementMNode<ICachedMNode> leafMNode = this.getMeasurementMNode(path);
        try {
            if (!leafMNode.isLogicalView()) {
                throw new MetadataException(String.format("[%s] is no view.", path));
            }
            this.store.updateMNode((ICachedMNode)leafMNode.getAsMNode(), o -> o.getAsMeasurementMNode().setSchema((IMeasurementSchema)new LogicalViewSchema(leafMNode.getName(), expression)));
        }
        finally {
            this.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTemplate(PartialPath activatePath, Template template) throws MetadataException {
        String[] nodes = activatePath.getNodes();
        ICachedMNode cur = this.storageGroupMNode;
        try {
            IDeviceMNode<ICachedMNode> entityMNode;
            for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
                ICachedMNode child = this.store.getChild(cur, nodes[i]);
                if (child == null) {
                    throw new PathNotExistException(activatePath.getFullPath());
                }
                cur = child;
            }
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                entityMNode = cur.isDevice() ? cur.getAsDeviceMNode() : this.store.setToEntity(cur);
                if (entityMNode.isUseTemplate()) {
                    if (template.getId() == entityMNode.getSchemaTemplateId()) {
                        throw new TemplateIsInUseException(cur.getFullPath());
                    }
                    throw new DifferentTemplateException(activatePath.getFullPath(), template.getName());
                }
            }
            this.store.updateMNode((ICachedMNode)entityMNode.getAsMNode(), o -> {
                if (!entityMNode.isAligned()) {
                    entityMNode.setAligned(Boolean.valueOf(template.isDirectAligned()));
                }
                entityMNode.setUseTemplate(true);
                entityMNode.setSchemaTemplateId(template.getId());
            });
            this.regionStatistics.activateTemplate(template.getId());
        }
        finally {
            this.unPinPath(cur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTemplateWithoutCheck(PartialPath activatePath, int templateId, boolean isAligned) throws MetadataException {
        String[] nodes = activatePath.getNodes();
        ICachedMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
                ICachedMNode child = this.store.getChild(cur, nodes[i]);
                if (child == null) {
                    throw new PathNotExistException(activatePath.getFullPath());
                }
                cur = child;
            }
            IDeviceMNode<ICachedMNode> entityMNode = cur.isDevice() ? cur.getAsDeviceMNode() : this.store.setToEntity(cur);
            this.store.updateMNode((ICachedMNode)entityMNode.getAsMNode(), o -> {
                if (!entityMNode.isAligned()) {
                    entityMNode.setAligned(Boolean.valueOf(isAligned));
                }
                entityMNode.setUseTemplate(true);
                entityMNode.setSchemaTemplateId(templateId);
            });
            this.regionStatistics.activateTemplate(templateId);
        }
        finally {
            this.unPinPath(cur);
        }
    }

    public Map<PartialPath, List<Integer>> constructSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<ICachedMNode> updater = new EntityUpdater<ICachedMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<ICachedMNode> node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId())) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        this.store.updateMNode((ICachedMNode)node.getAsMNode(), o -> o.getAsDeviceMNode().preDeactivateTemplate());
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    public Map<PartialPath, List<Integer>> rollbackSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<ICachedMNode> updater = new EntityUpdater<ICachedMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<ICachedMNode> node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        this.store.updateMNode((ICachedMNode)node.getAsMNode(), o -> o.getAsDeviceMNode().rollbackPreDeactivateTemplate());
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    public Map<PartialPath, List<Integer>> deactivateTemplateInBlackList(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<ICachedMNode> collector = new EntityUpdater<ICachedMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<ICachedMNode> node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        MTreeBelowSGCachedImpl.this.regionStatistics.deactivateTemplate(node.getSchemaTemplateId());
                        this.store.updateMNode((ICachedMNode)node.getAsMNode(), o -> o.getAsDeviceMNode().deactivateTemplate());
                    }
                }
            };){
                collector.traverse();
            }
        }
        for (PartialPath path : resultTemplateSetInfo.keySet()) {
            this.deleteAndUnpinEmptyInternalMNode((IDeviceMNode<ICachedMNode>)this.getNodeByPath(path).getAsDeviceMNode());
        }
        return resultTemplateSetInfo;
    }

    public long countPathsUsingTemplate(PartialPath pathPattern, int templateId) throws MetadataException {
        try (EntityCounter<ICachedMNode> counter = new EntityCounter<ICachedMNode>(this.rootNode, pathPattern, this.store, false, SchemaConstant.ALL_MATCH_SCOPE);){
            counter.setSchemaTemplateFilter(templateId);
            long l = counter.count();
            return l;
        }
    }

    public void pinMNode(ICachedMNode node) throws MetadataException {
        this.store.pin(node);
    }

    public void unPinMNode(ICachedMNode node) {
        this.store.unPin(node);
    }

    private void unPinPath(ICachedMNode node) {
        this.store.unPinPath(node);
    }

    public void updateMNode(ICachedMNode node, Consumer<ICachedMNode> operation) {
        this.store.updateMNode(node, operation);
    }

    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(final IShowDevicesPlan showDevicesPlan) throws MetadataException {
        final EntityCollector<IDeviceSchemaInfo, ICachedMNode> collector = new EntityCollector<IDeviceSchemaInfo, ICachedMNode>(this.rootNode, showDevicesPlan.getPath(), (IMTreeStore)this.store, showDevicesPlan.isPrefixMatch(), showDevicesPlan.getScope()){

            @Override
            protected IDeviceSchemaInfo collectEntity(IDeviceMNode<ICachedMNode> node) {
                PartialPath device = this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode()));
                return new ShowDevicesResult(device.getFullPath(), node.isAlignedNullable(), node.getSchemaTemplateId());
            }
        };
        if (showDevicesPlan.usingSchemaTemplate()) {
            collector.setSchemaTemplateFilter(showDevicesPlan.getSchemaTemplateId());
        }
        ISchemaReader<IDeviceSchemaInfo> reader = new ISchemaReader<IDeviceSchemaInfo>(){
            private final DeviceFilterVisitor filterVisitor = new DeviceFilterVisitor();
            private IDeviceSchemaInfo next;

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null && collector.hasNext()) {
                    IDeviceSchemaInfo temp = (IDeviceSchemaInfo)collector.next();
                    if (!this.filterVisitor.process(showDevicesPlan.getSchemaFilter(), temp)) continue;
                    this.next = temp;
                }
                return this.next != null;
            }

            @Override
            public IDeviceSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IDeviceSchemaInfo result = this.next;
                this.next = null;
                return result;
            }
        };
        if (showDevicesPlan.getLimit() > 0L || showDevicesPlan.getOffset() > 0L) {
            return new SchemaReaderLimitOffsetWrapper<IDeviceSchemaInfo>(reader, showDevicesPlan.getLimit(), showDevicesPlan.getOffset());
        }
        return reader;
    }

    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan showTimeSeriesPlan, final Function<Long, Pair<Map<String, String>, Map<String, String>>> tagAndAttributeProvider) throws MetadataException {
        MeasurementCollector<ITimeSeriesSchemaInfo, ICachedMNode> collector = new MeasurementCollector<ITimeSeriesSchemaInfo, ICachedMNode>(this.rootNode, showTimeSeriesPlan.getPath(), (IMTreeStore)this.store, showTimeSeriesPlan.isPrefixMatch(), showTimeSeriesPlan.getScope()){

            @Override
            protected ITimeSeriesSchemaInfo collectMeasurement(final IMeasurementMNode<ICachedMNode> node) {
                return new ITimeSeriesSchemaInfo(){
                    private Pair<Map<String, String>, Map<String, String>> tagAndAttribute = null;

                    @Override
                    public String getAlias() {
                        return node.getAlias();
                    }

                    @Override
                    public IMeasurementSchema getSchema() {
                        return node.getSchema();
                    }

                    @Override
                    public Map<String, String> getTags() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.left;
                    }

                    @Override
                    public Map<String, String> getAttributes() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.right;
                    }

                    @Override
                    public boolean isUnderAlignedDevice() {
                        return ((ICachedMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode().isAligned();
                    }

                    @Override
                    public boolean isLogicalView() {
                        return node.isLogicalView();
                    }

                    @Override
                    public String getFullPath() {
                        return this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode())).getFullPath();
                    }

                    @Override
                    public PartialPath getPartialPath() {
                        return this.getPartialPathFromRootToNode((ITreeNode)((ICachedMNode)node.getAsMNode()));
                    }

                    @Override
                    public ITimeSeriesSchemaInfo snapshot() {
                        return new TimeseriesSchemaInfo(node, this.getPartialPath(), this.getTags(), this.getAttributes(), this.isUnderAlignedDevice());
                    }
                };
            }
        };
        collector.setTemplateMap(showTimeSeriesPlan.getRelatedTemplate(), this.nodeFactory);
        TimeseriesReaderWithViewFetch reader = new TimeseriesReaderWithViewFetch((SchemaIterator<ITimeSeriesSchemaInfo>)collector, showTimeSeriesPlan.getSchemaFilter(), showTimeSeriesPlan.needViewDetail());
        if (showTimeSeriesPlan.getLimit() > 0L || showTimeSeriesPlan.getOffset() > 0L) {
            return new SchemaReaderLimitOffsetWrapper<ITimeSeriesSchemaInfo>(reader, showTimeSeriesPlan.getLimit(), showTimeSeriesPlan.getOffset());
        }
        return reader;
    }

    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan showNodesPlan) throws MetadataException {
        final MNodeCollector<INodeSchemaInfo, ICachedMNode> collector = new MNodeCollector<INodeSchemaInfo, ICachedMNode>(this.rootNode, showNodesPlan.getPath(), (IMTreeStore)this.store, showNodesPlan.isPrefixMatch(), showNodesPlan.getScope()){

            @Override
            protected INodeSchemaInfo collectMNode(ICachedMNode node) {
                return new ShowNodesResult(this.getPartialPathFromRootToNode((ITreeNode)node).getFullPath(), node.getMNodeType());
            }
        };
        collector.setTargetLevel(showNodesPlan.getLevel());
        return new ISchemaReader<INodeSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                return collector.hasNext();
            }

            @Override
            public INodeSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (INodeSchemaInfo)collector.next();
            }
        };
    }
}

