/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.metric;

import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.SchemaEngineMode;
import org.apache.iotdb.db.schemaengine.metric.ISchemaEngineMetric;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaEngineStatistics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SchemaEngineMemMetric
implements ISchemaEngineMetric {
    public static final String SCHEMA_REGION_TOTAL_USAGE = "schema_region_total_usage";
    private static final String TOTAL_MEM_USAGE = "schema_region_total_mem_usage";
    private static final String MEM_CAPACITY = "schema_region_mem_capacity";
    private static final String REGION_NUMBER = "schema_region_number";
    private static final String SCHEMA_CONSENSUS = "schema_region_consensus";
    private static final String SCHEMA_ENGINE_MODE = "schema_engine_mode";
    private final MemSchemaEngineStatistics engineStatistics;

    public SchemaEngineMemMetric(MemSchemaEngineStatistics engineStatistics) {
        this.engineStatistics = engineStatistics;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, ISchemaEngineStatistics::getMemoryUsage, new String[]{Tag.NAME.toString(), SCHEMA_REGION_TOTAL_USAGE});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, ISchemaEngineStatistics::getMemoryUsage, new String[]{Tag.NAME.toString(), TOTAL_MEM_USAGE});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, ISchemaEngineStatistics::getMemoryCapacity, new String[]{Tag.NAME.toString(), MEM_CAPACITY});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, ISchemaEngineStatistics::getSchemaRegionNumber, new String[]{Tag.NAME.toString(), REGION_NUMBER});
        metricService.gauge((long)SchemaEngineMode.valueOf(CommonDescriptor.getInstance().getConfig().getSchemaEngineMode()).getCode(), Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SCHEMA_ENGINE_MODE});
        metricService.gauge((long)this.getSchemaRegionConsensusProtocol(), Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SCHEMA_CONSENSUS});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEM.toString(), new String[]{Tag.NAME.toString(), SCHEMA_REGION_TOTAL_USAGE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), TOTAL_MEM_USAGE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), MEM_CAPACITY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), REGION_NUMBER});
    }

    private int getSchemaRegionConsensusProtocol() {
        switch (IoTDBDescriptor.getInstance().getConfig().getSchemaRegionConsensusProtocolClass()) {
            case "org.apache.iotdb.consensus.ratis.RatisConsensus": {
                return 0;
            }
            case "org.apache.iotdb.consensus.simple.SimpleConsensus": {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }
}

