/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerRowReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi.UniversalUDFQueryTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;

public class UDFQueryRowTransformer
extends UniversalUDFQueryTransformer {
    protected final LayerRowReader layerRowReader;

    public UDFQueryRowTransformer(LayerRowReader layerRowReader, UDTFExecutor executor) {
        super(executor);
        this.layerRowReader = layerRowReader;
    }

    @Override
    protected YieldableState tryExecuteUDFOnce() throws Exception {
        YieldableState yieldableState = this.layerRowReader.yield();
        if (yieldableState != YieldableState.YIELDABLE) {
            return yieldableState;
        }
        if (this.layerRowReader.isCurrentNull()) {
            this.currentNull = true;
        }
        this.executor.execute(this.layerRowReader.currentRow(), this.currentNull);
        this.layerRowReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    @Override
    protected boolean executeUDFOnce() throws IOException, QueryProcessException {
        if (!this.layerRowReader.next()) {
            return false;
        }
        if (this.layerRowReader.isCurrentNull()) {
            this.currentNull = true;
        }
        this.executor.execute(this.layerRowReader.currentRow(), this.currentNull);
        this.layerRowReader.readyForNext();
        return true;
    }
}

