/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionAnalyzeVisitor;

public abstract class CartesianProductVisitor<C>
extends ExpressionAnalyzeVisitor<List<Expression>, C> {
    @Override
    public List<Expression> visitTernaryExpression(TernaryExpression ternaryExpression, C context) {
        List childResultsList = this.getResultsFromChild(ternaryExpression, context);
        return ExpressionUtils.reconstructTernaryExpressions(ternaryExpression, (List)childResultsList.get(0), (List)childResultsList.get(1), (List)childResultsList.get(2));
    }

    @Override
    public List<Expression> visitBinaryExpression(BinaryExpression binaryExpression, C context) {
        List childResultsList = this.getResultsFromChild(binaryExpression, context);
        return ExpressionUtils.reconstructBinaryExpressions(binaryExpression, (List)childResultsList.get(0), (List)childResultsList.get(1));
    }

    @Override
    public List<Expression> visitUnaryExpression(UnaryExpression unaryExpression, C context) {
        List childResultsList = this.getResultsFromChild(unaryExpression, context);
        return ExpressionUtils.reconstructUnaryExpressions(unaryExpression, (List)childResultsList.get(0));
    }

    @Override
    public List<Expression> visitCaseWhenThenExpression(CaseWhenThenExpression caseWhenThenExpression, C context) {
        List childResultsList = this.getResultsFromChild(caseWhenThenExpression, context);
        ArrayList cartesianResults = new ArrayList();
        boolean hasEmptyList = childResultsList.stream().anyMatch(List::isEmpty);
        if (!hasEmptyList) {
            ExpressionUtils.cartesianProduct(childResultsList, cartesianResults, 0, new ArrayList());
        }
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (List list : cartesianResults) {
            result.add(ExpressionUtils.reconstructCaseWhenThenExpression(caseWhenThenExpression, list));
        }
        return result;
    }

    @Override
    public List<Expression> visitNullOperand(NullOperand nullOperand, C context) {
        return Collections.singletonList(nullOperand);
    }
}

