/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.schema;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class SchemaValidator {
    public static void validate(ISchemaFetcher schemaFetcher, InsertBaseStatement insertStatement, MPPQueryContext context) {
        try {
            if (insertStatement instanceof InsertRowsStatement || insertStatement instanceof InsertMultiTabletsStatement || insertStatement instanceof InsertRowsOfOneDeviceStatement) {
                schemaFetcher.fetchAndComputeSchemaWithAutoCreate(insertStatement.getSchemaValidationList(), context);
            } else {
                schemaFetcher.fetchAndComputeSchemaWithAutoCreate(insertStatement.getSchemaValidation(), context);
            }
            insertStatement.updateAfterSchemaValidation();
        }
        catch (QueryProcessException e) {
            throw new SemanticException(e.getMessage());
        }
    }

    public static ISchemaTree validate(ISchemaFetcher schemaFetcher, List<PartialPath> devicePaths, List<String[]> measurements, List<TSDataType[]> dataTypes, List<TSEncoding[]> encodings, List<CompressionType[]> compressionTypes, List<Boolean> isAlignedList, MPPQueryContext context) {
        return schemaFetcher.fetchSchemaListWithAutoCreate(devicePaths, measurements, dataTypes, encodings, compressionTypes, isAlignedList, context);
    }
}

