/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFInformationInferrer;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class ExpressionTypeAnalyzer {
    private final Map<NodeRef<Expression>, TSDataType> expressionTypes = new LinkedHashMap<NodeRef<Expression>, TSDataType>();

    private ExpressionTypeAnalyzer() {
    }

    public static TSDataType analyzeExpression(Analysis analysis, Expression expression) {
        if (!analysis.getExpressionTypes().containsKey(NodeRef.of(expression))) {
            ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
            analyzer.analyze(expression, null);
            ExpressionTypeAnalyzer.addExpressionTypes(analysis, analyzer);
        }
        return analysis.getType(expression);
    }

    public static TSDataType analyzeExpressionForTemplatedQuery(Analysis analysis, Expression expression) {
        if (!analysis.getExpressionTypes().containsKey(NodeRef.of(expression))) {
            ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
            analyzer.analyze(expression, analysis.getDeviceTemplate().getSchemaMap());
            ExpressionTypeAnalyzer.addExpressionTypes(analysis, analyzer);
        }
        return analysis.getType(expression);
    }

    public static void analyzeExpression(Map<NodeRef<Expression>, TSDataType> types, Expression expression) {
        ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
        analyzer.analyze(expression, null);
        types.putAll(analyzer.getExpressionTypes());
    }

    private static void addExpressionTypes(Analysis analysis, ExpressionTypeAnalyzer analyzer) {
        analysis.addTypes(analyzer.getExpressionTypes());
    }

    public TSDataType analyze(Expression expression, Map<String, IMeasurementSchema> context) {
        Visitor visitor = new Visitor();
        return visitor.process(expression, context);
    }

    public Map<NodeRef<Expression>, TSDataType> getExpressionTypes() {
        return this.expressionTypes;
    }

    private class Visitor
    extends ExpressionVisitor<TSDataType, Map<String, IMeasurementSchema>> {
        private Visitor() {
        }

        @Override
        public TSDataType process(Expression expression, Map<String, IMeasurementSchema> context) {
            TSDataType dataType = (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(expression));
            if (dataType != null) {
                return dataType;
            }
            return (TSDataType)super.process(expression, context);
        }

        @Override
        public TSDataType visitExpression(Expression expression, Map<String, IMeasurementSchema> context) {
            throw new UnsupportedOperationException("Unsupported expression type: " + expression.getClass().getName());
        }

        @Override
        public TSDataType visitInExpression(InExpression inExpression, Map<String, IMeasurementSchema> context) {
            this.process(inExpression.getExpression(), context);
            return this.setExpressionType(inExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitIsNullExpression(IsNullExpression isNullExpression, Map<String, IMeasurementSchema> context) {
            this.process(isNullExpression.getExpression(), context);
            return this.setExpressionType(isNullExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitLikeExpression(LikeExpression likeExpression, Map<String, IMeasurementSchema> context) {
            this.checkInputExpressionDataType(likeExpression.getExpression().getExpressionString(), this.process(likeExpression.getExpression(), context), TSDataType.TEXT);
            return this.setExpressionType(likeExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitRegularExpression(RegularExpression regularExpression, Map<String, IMeasurementSchema> context) {
            this.checkInputExpressionDataType(regularExpression.getExpression().getExpressionString(), this.process(regularExpression.getExpression(), context), TSDataType.TEXT);
            return this.setExpressionType(regularExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitLogicNotExpression(LogicNotExpression logicNotExpression, Map<String, IMeasurementSchema> context) {
            this.checkInputExpressionDataType(logicNotExpression.getExpression().getExpressionString(), this.process(logicNotExpression.getExpression(), context), TSDataType.BOOLEAN);
            return this.setExpressionType(logicNotExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitNegationExpression(NegationExpression negationExpression, Map<String, IMeasurementSchema> context) {
            TSDataType inputExpressionType = this.process(negationExpression.getExpression(), context);
            this.checkInputExpressionDataType(negationExpression.getExpression().getExpressionString(), inputExpressionType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            return this.setExpressionType(negationExpression, inputExpressionType);
        }

        @Override
        public TSDataType visitArithmeticBinaryExpression(ArithmeticBinaryExpression arithmeticBinaryExpression, Map<String, IMeasurementSchema> context) {
            this.checkInputExpressionDataType(arithmeticBinaryExpression.getLeftExpression().getExpressionString(), this.process(arithmeticBinaryExpression.getLeftExpression(), context), TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            this.checkInputExpressionDataType(arithmeticBinaryExpression.getRightExpression().getExpressionString(), this.process(arithmeticBinaryExpression.getRightExpression(), context), TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            return this.setExpressionType(arithmeticBinaryExpression, TSDataType.DOUBLE);
        }

        @Override
        public TSDataType visitLogicBinaryExpression(LogicBinaryExpression logicBinaryExpression, Map<String, IMeasurementSchema> context) {
            this.checkInputExpressionDataType(logicBinaryExpression.getLeftExpression().getExpressionString(), this.process(logicBinaryExpression.getLeftExpression(), context), TSDataType.BOOLEAN);
            this.checkInputExpressionDataType(logicBinaryExpression.getRightExpression().getExpressionString(), this.process(logicBinaryExpression.getRightExpression(), context), TSDataType.BOOLEAN);
            return this.setExpressionType(logicBinaryExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitCompareBinaryExpression(CompareBinaryExpression compareBinaryExpression, Map<String, IMeasurementSchema> context) {
            TSDataType leftExpressionDataType = this.process(compareBinaryExpression.getLeftExpression(), context);
            TSDataType rightExpressionDataType = this.process(compareBinaryExpression.getRightExpression(), context);
            if (leftExpressionDataType != null && rightExpressionDataType != null && !leftExpressionDataType.equals((Object)rightExpressionDataType)) {
                String leftExpressionString = compareBinaryExpression.getLeftExpression().getExpressionString();
                String rightExpressionString = compareBinaryExpression.getRightExpression().getExpressionString();
                if (TSDataType.BOOLEAN.equals((Object)leftExpressionDataType) || TSDataType.BOOLEAN.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.BOOLEAN);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.BOOLEAN);
                } else if (TSDataType.TEXT.equals((Object)leftExpressionDataType) || TSDataType.TEXT.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.TEXT);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.TEXT);
                } else {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
                }
            }
            return this.setExpressionType(compareBinaryExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitBetweenExpression(BetweenExpression betweenExpression, Map<String, IMeasurementSchema> context) {
            this.process(betweenExpression.getFirstExpression(), context);
            this.process(betweenExpression.getSecondExpression(), context);
            this.process(betweenExpression.getThirdExpression(), context);
            return this.setExpressionType(betweenExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitFunctionExpression(FunctionExpression functionExpression, Map<String, IMeasurementSchema> context) {
            List<Expression> inputExpressions = functionExpression.getExpressions();
            for (Expression expression : inputExpressions) {
                this.process(expression, context);
            }
            if (functionExpression.isBuiltInAggregationFunctionExpression()) {
                return this.setExpressionType(functionExpression, TypeInferenceUtils.getAggrDataType(functionExpression.getFunctionName(), (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(inputExpressions.get(0)))));
            }
            if (functionExpression.isBuiltInScalarFunction()) {
                return this.setExpressionType(functionExpression, TypeInferenceUtils.getBuiltInScalarFunctionDataType(functionExpression, (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(inputExpressions.get(0)))));
            }
            return this.setExpressionType(functionExpression, new UDTFInformationInferrer(functionExpression.getFunctionName()).inferOutputType(inputExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList()), inputExpressions.stream().map(f -> (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(f))).collect(Collectors.toList()), functionExpression.getFunctionAttributes()));
        }

        @Override
        public TSDataType visitTimeStampOperand(TimestampOperand timestampOperand, Map<String, IMeasurementSchema> context) {
            return this.setExpressionType(timestampOperand, TSDataType.INT64);
        }

        @Override
        public TSDataType visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Map<String, IMeasurementSchema> context) {
            if (context != null && context.containsKey(timeSeriesOperand.getOutputSymbol())) {
                return this.setExpressionType(timeSeriesOperand, context.get(timeSeriesOperand.getOutputSymbol()).getType());
            }
            return this.setExpressionType(timeSeriesOperand, timeSeriesOperand.getPath().getSeriesType());
        }

        @Override
        public TSDataType visitConstantOperand(ConstantOperand constantOperand, Map<String, IMeasurementSchema> context) {
            return this.setExpressionType(constantOperand, constantOperand.getDataType());
        }

        @Override
        public TSDataType visitNullOperand(NullOperand nullOperand, Map<String, IMeasurementSchema> context) {
            return null;
        }

        @Override
        public TSDataType visitCaseWhenThenExpression(CaseWhenThenExpression caseWhenThenExpression, Map<String, IMeasurementSchema> context) {
            HashSet<TSDataType> typeSet = new HashSet<TSDataType>();
            for (WhenThenExpression whenThenExpression : caseWhenThenExpression.getWhenThenExpressions()) {
                typeSet.add(this.process((Expression)whenThenExpression, context));
            }
            if (!(caseWhenThenExpression.getElseExpression() instanceof NullOperand)) {
                typeSet.add(this.process(caseWhenThenExpression.getElseExpression(), context));
            }
            if (typeSet.contains(TSDataType.TEXT)) {
                if (typeSet.stream().anyMatch(tsDataType -> tsDataType != TSDataType.TEXT)) {
                    throw new SemanticException("CASE expression: TEXT and other types cannot exist at the same time");
                }
                return this.setExpressionType(caseWhenThenExpression, TSDataType.TEXT);
            }
            if (typeSet.contains(TSDataType.BOOLEAN)) {
                if (typeSet.stream().anyMatch(tsDataType -> tsDataType != TSDataType.BOOLEAN)) {
                    throw new SemanticException("CASE expression: BOOLEAN and other types cannot exist at the same time");
                }
                return this.setExpressionType(caseWhenThenExpression, TSDataType.BOOLEAN);
            }
            return this.setExpressionType(caseWhenThenExpression, TSDataType.DOUBLE);
        }

        @Override
        public TSDataType visitWhenThenExpression(WhenThenExpression whenThenExpression, Map<String, IMeasurementSchema> context) {
            TSDataType whenType = this.process(whenThenExpression.getWhen(), context);
            if (!whenType.equals((Object)TSDataType.BOOLEAN)) {
                throw new SemanticException(String.format("The expression in the WHEN clause must return BOOLEAN. expression: %s, actual data type: %s.", whenThenExpression.getWhen().getExpressionString(), whenType.name()));
            }
            TSDataType thenType = this.process(whenThenExpression.getThen(), context);
            return this.setExpressionType(whenThenExpression, thenType);
        }

        private TSDataType setExpressionType(Expression expression, TSDataType type) {
            ExpressionTypeAnalyzer.this.expressionTypes.put(NodeRef.of(expression), type);
            return type;
        }

        private void checkInputExpressionDataType(String expressionString, TSDataType actual, TSDataType ... expected) {
            for (TSDataType type : expected) {
                if (actual != null && !actual.equals((Object)type)) continue;
                return;
            }
            throw new SemanticException(String.format("Invalid input expression data type. expression: %s, actual data type: %s, expected data type(s): %s.", expressionString, actual.name(), Arrays.toString(expected)));
        }
    }
}

