/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.Binary;

public class BinaryConstantFill
implements IFill {
    private final Binary value;
    private final Binary[] valueArray;

    public BinaryConstantFill(Binary value) {
        this.value = value;
        this.valueArray = new Binary[]{value};
    }

    @Override
    public Column fill(TimeColumn timeColumn, Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (!valueColumn.mayHaveNull() || size == 0) {
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            return new RunLengthEncodedColumn((Column)new BinaryColumn(1, Optional.empty(), this.valueArray), size);
        }
        Binary[] array = new Binary[size];
        for (int i = 0; i < size; ++i) {
            array[i] = valueColumn.isNull(i) ? this.value : valueColumn.getBinary(i);
        }
        return new BinaryColumn(size, Optional.empty(), array);
    }
}

