/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.iotdb.db.utils.datastructure.MergeSortHeap;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class AggregationMergeSortOperator
extends AbstractConsumeAllOperator {
    private final List<Accumulator> accumulators;
    private final List<TSDataType> dataTypes;
    private final TsBlockBuilder tsBlockBuilder;
    private final boolean[] noMoreTsBlocks;
    private final MergeSortHeap mergeSortHeap;
    private final boolean hasGroupBy;
    private boolean finished;
    private Binary lastDevice;
    private long lastTime;

    public AggregationMergeSortOperator(OperatorContext operatorContext, List<Operator> children, List<TSDataType> dataTypes, List<Accumulator> accumulators, boolean hasGroupBy, Comparator<SortKey> comparator) {
        super(operatorContext, children);
        this.dataTypes = dataTypes;
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.noMoreTsBlocks = new boolean[this.inputOperatorsCount];
        this.accumulators = accumulators;
        this.hasGroupBy = hasGroupBy;
        this.mergeSortHeap = new MergeSortHeap(this.inputOperatorsCount, comparator);
    }

    @Override
    public TsBlock next() throws Exception {
        long startTime = System.nanoTime();
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        if (!this.prepareInput()) {
            return null;
        }
        this.tsBlockBuilder.reset();
        while (!this.mergeSortHeap.isEmpty()) {
            MergeSortKey mergeSortKey = this.mergeSortHeap.poll();
            TsBlock targetBlock = mergeSortKey.tsBlock;
            int rowIndex = mergeSortKey.rowIndex;
            Binary currentDevice = targetBlock.getColumn(0).getBinary(rowIndex);
            long currentTime = targetBlock.getTimeByIndex(rowIndex);
            if (!(this.lastDevice == null || currentDevice.equals((Object)this.lastDevice) && currentTime == this.lastTime)) {
                this.outputResultToTsBlock();
            }
            this.lastDevice = currentDevice;
            this.lastTime = currentTime;
            int cnt = 1;
            for (Accumulator accumulator : this.accumulators) {
                if (accumulator.getPartialResultSize() == 2) {
                    Column first = this.hasGroupBy ? targetBlock.getColumn(cnt++).subColumn(rowIndex) : targetBlock.getColumn(cnt++);
                    Column second = this.hasGroupBy ? targetBlock.getColumn(cnt++).subColumn(rowIndex) : targetBlock.getColumn(cnt++);
                    accumulator.addIntermediate(new Column[]{first, second});
                    continue;
                }
                Column column = this.hasGroupBy ? targetBlock.getColumn(cnt++).subColumn(rowIndex) : targetBlock.getColumn(cnt++);
                accumulator.addIntermediate(new Column[]{column});
            }
            if (mergeSortKey.rowIndex == mergeSortKey.tsBlock.getPositionCount() - 1) {
                this.inputTsBlocks[mergeSortKey.inputChannelIndex] = null;
                break;
            }
            ++mergeSortKey.rowIndex;
            this.mergeSortHeap.push(mergeSortKey);
            if (System.nanoTime() - startTime <= maxRuntime && !this.tsBlockBuilder.isFull()) continue;
            break;
        }
        if (this.mergeSortHeap.isEmpty()) {
            this.outputResultToTsBlock();
        }
        return this.tsBlockBuilder.build();
    }

    private void outputResultToTsBlock() {
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        timeBuilder.writeLong(this.lastTime);
        valueColumnBuilders[0].writeBinary(this.lastDevice);
        for (int i = 1; i < this.dataTypes.size(); ++i) {
            this.accumulators.get(i - 1).outputFinal(valueColumnBuilders[i]);
        }
        this.tsBlockBuilder.declarePosition();
        this.accumulators.forEach(Accumulator::reset);
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.finished) {
            return false;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.isInputNotEmpty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (!this.canCallNext[i] || ((Operator)this.children.get(i)).hasNextWithTimer()) {
                return true;
            }
            this.handleFinishedChild(i);
        }
        return false;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || this.isInputNotEmpty(i) || this.children.get(i) == null) continue;
            ListenableFuture<?> blocked = ((Operator)this.children.get(i)).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.finished) {
            return true;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && !this.isInputNotEmpty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished;
    }

    @Override
    public void close() throws Exception {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            Operator operator = (Operator)this.children.get(i);
            if (operator == null) continue;
            operator.close();
        }
    }

    @Override
    protected void handleFinishedChild(int currentChildIndex) throws Exception {
        this.noMoreTsBlocks[currentChildIndex] = true;
        this.inputTsBlocks[currentChildIndex] = null;
        ((Operator)this.children.get(currentChildIndex)).close();
        this.children.set(currentChildIndex, null);
    }

    @Override
    protected boolean canSkipCurrentChild(int currentChildIndex) {
        return this.noMoreTsBlocks[currentChildIndex] || !this.isEmpty(currentChildIndex) || this.children.get(currentChildIndex) == null;
    }

    @Override
    protected void processCurrentInputTsBlock(int currentInputIndex) {
        this.mergeSortHeap.push(new MergeSortKey(this.inputTsBlocks[currentInputIndex], 0, currentInputIndex));
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        for (Operator operator : this.children) {
            maxPeekMemory += operator.calculateMaxReturnSize();
            maxPeekMemory += operator.calculateRetainedSizeAfterCallingNext();
        }
        for (Operator operator : this.children) {
            maxPeekMemory = Math.max(maxPeekMemory, operator.calculateMaxPeekMemory());
        }
        return Math.max(maxPeekMemory, this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
        }
        return currentRetainedSize - minChildReturnSize;
    }

    private boolean isInputNotEmpty(int index) {
        return this.inputTsBlocks[index] != null && !this.inputTsBlocks[index].isEmpty();
    }
}

