/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import io.airlift.stats.CounterStat;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.IDriver;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceExecution;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.IDriverScheduler;
import org.apache.iotdb.db.queryengine.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryRelatedResourceMetricSet;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.PipelineDriverFactory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceManager {
    private static final Logger logger = LoggerFactory.getLogger(FragmentInstanceManager.class);
    private final Map<FragmentInstanceId, FragmentInstanceContext> instanceContext;
    private final Map<FragmentInstanceId, FragmentInstanceExecution> instanceExecution;
    private final Map<QueryId, DataNodeQueryContext> dataNodeQueryContextMap;
    private final LocalExecutionPlanner planner = LocalExecutionPlanner.getInstance();
    private final IDriverScheduler scheduler = DriverScheduler.getInstance();
    private final ScheduledExecutorService instanceManagementExecutor;
    public final ExecutorService instanceNotificationExecutor;
    private final Duration infoCacheTime;
    private final CounterStat failedInstances = new CounterStat();
    private final ExecutorService intoOperationExecutor;
    private final MPPDataExchangeManager exchangeManager = MPPDataExchangeService.getInstance().getMPPDataExchangeManager();
    private static final QueryExecutionMetricSet QUERY_EXECUTION_METRIC_SET = QueryExecutionMetricSet.getInstance();

    public static FragmentInstanceManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private FragmentInstanceManager() {
        this.instanceContext = new ConcurrentHashMap<FragmentInstanceId, FragmentInstanceContext>();
        this.instanceExecution = new ConcurrentHashMap<FragmentInstanceId, FragmentInstanceExecution>();
        this.dataNodeQueryContextMap = new ConcurrentHashMap<QueryId, DataNodeQueryContext>();
        this.instanceManagementExecutor = IoTDBThreadPoolFactory.newScheduledThreadPool((int)1, (String)ThreadName.FRAGMENT_INSTANCE_MANAGEMENT.getName());
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)4, (String)ThreadName.FRAGMENT_INSTANCE_NOTIFICATION.getName());
        this.infoCacheTime = new Duration(5.0, TimeUnit.MINUTES);
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.instanceManagementExecutor, this::removeOldInstances, (long)2000L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.instanceManagementExecutor, this::cancelTimeoutFlushingInstances, (long)2000L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.intoOperationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)IoTDBDescriptor.getInstance().getConfig().getIntoOperationExecutionThreadCount(), (String)"into-operation-executor");
    }

    public FragmentInstanceInfo execDataQueryFragmentInstance(FragmentInstance instance, IDataRegionForQuery dataRegion) {
        long startTime = System.nanoTime();
        FragmentInstanceId instanceId = instance.getId();
        AtomicLong driversCount = new AtomicLong();
        try {
            SetThreadName fragmentInstanceName;
            block10: {
                fragmentInstanceName = new SetThreadName(instanceId.getFullId());
                try {
                    FragmentInstanceExecution execution = this.instanceExecution.computeIfAbsent(instanceId, id -> {
                        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, this.instanceNotificationExecutor);
                        int dataNodeFINum = instance.getDataNodeFINum();
                        DataNodeQueryContext dataNodeQueryContext = this.getOrCreateDataNodeQueryContext(instanceId.getQueryId(), dataNodeFINum);
                        FragmentInstanceContext context = this.instanceContext.computeIfAbsent(instanceId, fragmentInstanceId -> FragmentInstanceContext.createFragmentInstanceContext(fragmentInstanceId, stateMachine, instance.getSessionInfo(), dataRegion, instance.getGlobalTimePredicate(), this.dataNodeQueryContextMap));
                        try {
                            List<PipelineDriverFactory> driverFactories = this.planner.plan(instance.getFragment().getPlanNodeTree(), instance.getFragment().getTypeProvider(), context, dataNodeQueryContext);
                            ArrayList<IDriver> drivers = new ArrayList<IDriver>();
                            driverFactories.forEach(factory -> drivers.add(factory.createDriver()));
                            if (instance.isHighestPriority()) {
                                drivers.forEach(driver -> driver.setHighestPriority(true));
                            }
                            context.initializeNumOfDrivers(drivers.size());
                            ISink sink = ((IDriver)drivers.get(drivers.size() - 1)).getSink();
                            driversCount.addAndGet(drivers.size());
                            return FragmentInstanceExecution.createFragmentInstanceExecution(this.scheduler, instanceId, context, drivers, sink, stateMachine, this.failedInstances, instance.getTimeOut(), this.exchangeManager);
                        }
                        catch (Throwable t) {
                            logger.warn("error when create FragmentInstanceExecution.", t);
                            stateMachine.failed(t);
                            return null;
                        }
                    });
                    if (execution == null) break block10;
                    execution.getStateMachine().addStateChangeListener(newState -> {
                        if (newState.isDone()) {
                            this.instanceExecution.remove(instanceId);
                        }
                    });
                    FragmentInstanceInfo fragmentInstanceInfo = execution.getInstanceInfo();
                    fragmentInstanceName.close();
                    return fragmentInstanceInfo;
                }
                catch (Throwable throwable) {
                    try {
                        fragmentInstanceName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            FragmentInstanceInfo fragmentInstanceInfo = this.createFailedInstanceInfo(instanceId);
            fragmentInstanceName.close();
            return fragmentInstanceInfo;
        }
        finally {
            QueryRelatedResourceMetricSet.getInstance().updateFragmentInstanceCount(this.instanceContext.size(), this.instanceExecution.size(), driversCount.get());
            QUERY_EXECUTION_METRIC_SET.recordExecutionCost("local_execution_planner", System.nanoTime() - startTime);
        }
    }

    private DataNodeQueryContext getOrCreateDataNodeQueryContext(QueryId queryId, int dataNodeFINum) {
        return this.dataNodeQueryContextMap.computeIfAbsent(queryId, queryId1 -> new DataNodeQueryContext(dataNodeFINum));
    }

    public FragmentInstanceInfo execSchemaQueryFragmentInstance(FragmentInstance instance, ISchemaRegion schemaRegion) {
        FragmentInstanceId instanceId = instance.getId();
        FragmentInstanceExecution execution = this.instanceExecution.computeIfAbsent(instanceId, id -> {
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, this.instanceNotificationExecutor);
            FragmentInstanceContext context = this.instanceContext.computeIfAbsent(instanceId, fragmentInstanceId -> FragmentInstanceContext.createFragmentInstanceContext(fragmentInstanceId, stateMachine, instance.getSessionInfo()));
            try {
                List<PipelineDriverFactory> driverFactories = this.planner.plan(instance.getFragment().getPlanNodeTree(), context, schemaRegion);
                ArrayList<IDriver> drivers = new ArrayList<IDriver>();
                driverFactories.forEach(factory -> drivers.add(factory.createDriver()));
                context.initializeNumOfDrivers(drivers.size());
                ISink sink = ((IDriver)drivers.get(drivers.size() - 1)).getSink();
                return FragmentInstanceExecution.createFragmentInstanceExecution(this.scheduler, instanceId, context, drivers, sink, stateMachine, this.failedInstances, instance.getTimeOut(), this.exchangeManager);
            }
            catch (Throwable t) {
                logger.warn("Execute error caused by ", t);
                stateMachine.failed(t);
                return null;
            }
        });
        if (execution != null) {
            execution.getStateMachine().addStateChangeListener(newState -> {
                if (newState.isDone()) {
                    this.instanceExecution.remove(instanceId);
                }
            });
            return execution.getInstanceInfo();
        }
        return this.createFailedInstanceInfo(instanceId);
    }

    public FragmentInstanceInfo abortFragmentInstance(FragmentInstanceId fragmentInstanceId) {
        this.instanceExecution.remove(fragmentInstanceId);
        FragmentInstanceContext context = this.instanceContext.get(fragmentInstanceId);
        if (context != null) {
            context.abort();
            return context.getInstanceInfo();
        }
        return null;
    }

    public FragmentInstanceInfo cancelTask(FragmentInstanceId instanceId, boolean hasThrowable) {
        logger.debug("[CancelFI]");
        Objects.requireNonNull(instanceId, "taskId is null");
        FragmentInstanceContext context = this.instanceContext.remove(instanceId);
        if (context != null) {
            this.instanceExecution.remove(instanceId);
            if (hasThrowable) {
                context.cancel();
            } else {
                context.finished();
            }
            return context.getInstanceInfo();
        }
        return null;
    }

    public FragmentInstanceInfo getInstanceInfo(FragmentInstanceId instanceId) {
        Objects.requireNonNull(instanceId, "instanceId is null");
        FragmentInstanceContext context = this.instanceContext.get(instanceId);
        if (context == null) {
            return null;
        }
        return context.getInstanceInfo();
    }

    public CounterStat getFailedInstances() {
        return this.failedInstances;
    }

    private FragmentInstanceInfo createFailedInstanceInfo(FragmentInstanceId instanceId) {
        FragmentInstanceContext context = this.instanceContext.get(instanceId);
        return new FragmentInstanceInfo(FragmentInstanceState.FAILED, context.getEndTime(), context.getFailedCause(), context.getFailureInfoList());
    }

    private void removeOldInstances() {
        long oldestAllowedInstance = System.currentTimeMillis() - this.infoCacheTime.toMillis();
        this.instanceContext.entrySet().removeIf(entry -> {
            long endTime = ((FragmentInstanceContext)entry.getValue()).getEndTime();
            return endTime != -1L && endTime <= oldestAllowedInstance;
        });
    }

    private void cancelTimeoutFlushingInstances() {
        long now = System.currentTimeMillis();
        this.instanceExecution.forEach((key, execution) -> {
            if (execution.getStateMachine().getState() == FragmentInstanceState.FLUSHING && now - execution.getStartTime() > execution.getTimeoutInMs()) {
                execution.getStateMachine().failed(new TimeoutException("Query has executed more than " + execution.getTimeoutInMs() + "ms"));
            }
        });
    }

    public ExecutorService getIntoOperationExecutor() {
        return this.intoOperationExecutor;
    }

    private static class InstanceHolder {
        private static final FragmentInstanceManager INSTANCE = new FragmentInstanceManager();

        private InstanceHolder() {
        }
    }
}

