/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.driver;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;

public class DataDriverContext
extends DriverContext {
    private List<PartialPath> paths = new ArrayList<PartialPath>();
    private List<DataSourceOperator> sourceOperators = new ArrayList<DataSourceOperator>();

    public DataDriverContext(FragmentInstanceContext fragmentInstanceContext, int pipelineId) {
        super(fragmentInstanceContext, pipelineId);
    }

    public DataDriverContext(DataDriverContext parentContext, int pipelineId) {
        super(parentContext.getFragmentInstanceContext(), pipelineId);
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public void addSourceOperator(DataSourceOperator sourceOperator) {
        this.sourceOperators.add(sourceOperator);
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public void clearPaths() {
        this.paths = null;
    }

    public IDataRegionForQuery getDataRegion() {
        return this.getFragmentInstanceContext().getDataRegion();
    }

    public QueryDataSource getSharedQueryDataSource() throws QueryProcessException {
        return this.getFragmentInstanceContext().getSharedQueryDataSource();
    }

    public List<DataSourceOperator> getSourceOperators() {
        return this.sourceOperators;
    }

    public void clearSourceOperators() {
        this.sourceOperators = null;
    }

    @Override
    public DriverContext createSubDriverContext(int pipelineId) {
        return new DataDriverContext(this, pipelineId);
    }
}

