/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.filter;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Base64;
import java.util.UUID;
import javax.servlet.annotation.WebFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceConfig;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.rest.filter.BasicSecurityContext;
import org.apache.iotdb.db.protocol.rest.filter.User;
import org.apache.iotdb.db.protocol.rest.filter.UserCache;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.session.RestClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.rpc.TSStatusCode;

@WebFilter(value={"/*"})
@Provider
public class AuthorizationFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final UserCache userCache = UserCache.getInstance();
    IoTDBRestServiceConfig config = IoTDBRestServiceDescriptor.getInstance().getConfig();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if ("OPTIONS".equals(containerRequestContext.getMethod()) || "ping".equals(containerRequestContext.getUriInfo().getPath()) || this.config.isEnableSwagger() && "swagger.json".equals(containerRequestContext.getUriInfo().getPath())) {
            return;
        }
        if (!this.config.isEnableSwagger() && "swagger.json".equals(containerRequestContext.getUriInfo().getPath())) {
            Response resp = Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").entity((Object)"").build();
            containerRequestContext.abortWith(resp);
            return;
        }
        String authorizationHeader = containerRequestContext.getHeaderString("authorization");
        if (authorizationHeader == null) {
            Response resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.INIT_AUTH_ERROR.getStatusCode())).message(TSStatusCode.INIT_AUTH_ERROR.name())).build();
            containerRequestContext.abortWith(resp);
            return;
        }
        User user = this.userCache.getUser(authorizationHeader);
        if (user == null) {
            user = this.checkLogin(containerRequestContext, authorizationHeader);
            if (user == null) {
                return;
            }
            this.userCache.setUser(authorizationHeader, user);
        }
        String sessionid = UUID.randomUUID().toString();
        if (SESSION_MANAGER.getCurrSession() == null) {
            RestClientSession restClientSession = new RestClientSession(sessionid);
            restClientSession.setUsername(user.getUsername());
            SESSION_MANAGER.registerSession(restClientSession);
            SESSION_MANAGER.supplySession(SESSION_MANAGER.getCurrSession(), user.getUsername(), ZoneId.systemDefault().getId(), IoTDBConstant.ClientVersion.V_1_0);
        }
        BasicSecurityContext basicSecurityContext = new BasicSecurityContext(user, IoTDBRestServiceDescriptor.getInstance().getConfig().isEnableHttps());
        containerRequestContext.setSecurityContext((SecurityContext)basicSecurityContext);
    }

    private User checkLogin(ContainerRequestContext containerRequestContext, String authorizationHeader) {
        byte[] decodedBytes = Base64.getDecoder().decode(authorizationHeader.replace("Basic ", ""));
        String decoded = new String(decodedBytes);
        String[] split = decoded.split(":");
        if (split.length != 2) {
            Response resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.ILLEGAL_PARAMETER.getStatusCode())).message("Illegal format of authorization header.")).build();
            containerRequestContext.abortWith(resp);
            return null;
        }
        User user = new User();
        user.setUsername(split[0]);
        user.setPassword(split[1]);
        TSStatus tsStatus = AuthorityChecker.checkUser(split[0], split[1]);
        if (tsStatus.code != 200) {
            Response resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.WRONG_LOGIN_PASSWORD.getStatusCode())).message(TSStatusCode.WRONG_LOGIN_PASSWORD.name())).build();
            containerRequestContext.abortWith(resp);
            return null;
        }
        return user;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (SESSION_MANAGER.getCurrSession() != null && SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()) != null) {
            SESSION_MANAGER.removeCurrSession();
        }
    }
}

