/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.stage;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskConnectorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.task.stage.PipeTaskStage;
import org.apache.iotdb.db.pipe.execution.executor.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.task.subtask.connector.PipeConnectorSubtaskManager;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeTaskConnectorStage
extends PipeTaskStage {
    private final String pipeName;
    private final int dataRegionId;
    protected final PipeParameters pipeConnectorParameters;
    protected String connectorSubtaskId;

    public PipeTaskConnectorStage(String pipeName, long creationTime, PipeParameters pipeConnectorParameters, TConsensusGroupId dataRegionId, PipeConnectorSubtaskExecutor executor) {
        this.pipeName = pipeName;
        this.dataRegionId = dataRegionId.getId();
        this.pipeConnectorParameters = pipeConnectorParameters;
        this.connectorSubtaskId = PipeConnectorSubtaskManager.instance().register(executor, pipeConnectorParameters, new PipeTaskConnectorRuntimeEnvironment(this.pipeName, creationTime, this.dataRegionId));
    }

    public void createSubtask() throws PipeException {
    }

    public void startSubtask() throws PipeException {
        PipeConnectorSubtaskManager.instance().start(this.connectorSubtaskId);
    }

    public void stopSubtask() throws PipeException {
        PipeConnectorSubtaskManager.instance().stop(this.connectorSubtaskId);
    }

    public void dropSubtask() throws PipeException {
        PipeConnectorSubtaskManager.instance().deregister(this.pipeName, this.dataRegionId, this.connectorSubtaskId);
    }

    public BoundedBlockingPendingQueue<Event> getPipeConnectorPendingQueue() {
        return PipeConnectorSubtaskManager.instance().getPipeConnectorPendingQueue(this.connectorSubtaskId);
    }
}

