/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.builder;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.execution.executor.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.execution.executor.PipeProcessorSubtaskExecutor;
import org.apache.iotdb.db.pipe.task.PipeDataNodeTask;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskConnectorStage;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskExtractorStage;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskProcessorStage;

public abstract class PipeDataNodeTaskBuilder {
    private final PipeStaticMeta pipeStaticMeta;
    private final TConsensusGroupId regionId;
    private final PipeTaskMeta pipeTaskMeta;
    protected final PipeProcessorSubtaskExecutor processorExecutor;
    protected final PipeConnectorSubtaskExecutor connectorExecutor;

    protected PipeDataNodeTaskBuilder(PipeStaticMeta pipeStaticMeta, TConsensusGroupId regionId, PipeTaskMeta pipeTaskMeta, PipeProcessorSubtaskExecutor processorExecutor, PipeConnectorSubtaskExecutor connectorExecutor) {
        this.pipeStaticMeta = pipeStaticMeta;
        this.regionId = regionId;
        this.pipeTaskMeta = pipeTaskMeta;
        this.processorExecutor = processorExecutor;
        this.connectorExecutor = connectorExecutor;
    }

    public PipeDataNodeTask build() {
        PipeTaskExtractorStage extractorStage = new PipeTaskExtractorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.pipeStaticMeta.getExtractorParameters(), this.regionId, this.pipeTaskMeta);
        PipeTaskConnectorStage connectorStage = new PipeTaskConnectorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.pipeStaticMeta.getConnectorParameters(), this.regionId, this.connectorExecutor);
        PipeTaskProcessorStage processorStage = new PipeTaskProcessorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.pipeStaticMeta.getProcessorParameters(), this.regionId, extractorStage.getEventSupplier(), connectorStage.getPipeConnectorPendingQueue(), this.processorExecutor);
        return new PipeDataNodeTask(this.pipeStaticMeta.getPipeName(), this.regionId, extractorStage, processorStage, connectorStage);
    }
}

