/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.builder;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.PipeTask;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.task.builder.PipeDataNodeTaskDataRegionBuilder;
import org.apache.iotdb.db.pipe.task.builder.PipeDataNodeTaskSchemaRegionBuilder;

public class PipeDataNodeBuilder {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final PipeMeta pipeMeta;

    public PipeDataNodeBuilder(PipeMeta pipeMeta) {
        this.pipeMeta = pipeMeta;
    }

    public Map<TConsensusGroupId, PipeTask> build() {
        PipeStaticMeta pipeStaticMeta = this.pipeMeta.getStaticMeta();
        PipeRuntimeMeta pipeRuntimeMeta = this.pipeMeta.getRuntimeMeta();
        HashMap<TConsensusGroupId, PipeTask> consensusGroupIdToPipeTaskMap = new HashMap<TConsensusGroupId, PipeTask>();
        for (Map.Entry consensusGroupIdToPipeTaskMeta : pipeRuntimeMeta.getConsensusGroupId2TaskMetaMap().entrySet()) {
            TConsensusGroupId consensusGroupId = (TConsensusGroupId)consensusGroupIdToPipeTaskMeta.getKey();
            PipeTaskMeta pipeTaskMeta = (PipeTaskMeta)consensusGroupIdToPipeTaskMeta.getValue();
            switch (consensusGroupId.getType()) {
                case DataRegion: {
                    if (pipeTaskMeta.getLeaderDataNodeId() != CONFIG.getDataNodeId()) break;
                    consensusGroupIdToPipeTaskMap.put(consensusGroupId, new PipeDataNodeTaskDataRegionBuilder(pipeStaticMeta, consensusGroupId, pipeTaskMeta).build());
                    break;
                }
                case SchemaRegion: {
                    if (pipeTaskMeta.getLeaderDataNodeId() != CONFIG.getDataNodeId()) break;
                    consensusGroupIdToPipeTaskMap.put(consensusGroupId, new PipeDataNodeTaskSchemaRegionBuilder(pipeStaticMeta, consensusGroupId, pipeTaskMeta).build());
                    break;
                }
            }
        }
        return consensusGroupIdToPipeTaskMap;
    }
}

