/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.progress.committer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.metric.PipeEventCommitMetrics;
import org.apache.iotdb.db.pipe.progress.committer.PipeEventCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCommitManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCommitManager.class);
    private final Map<String, PipeEventCommitter> eventCommitterMap = new ConcurrentHashMap<String, PipeEventCommitter>();

    public void register(String pipeName, int dataRegionId, String pipePluginName) {
        if (pipeName == null || pipePluginName == null) {
            return;
        }
        String committerKey = PipeEventCommitManager.generateCommitterKey(pipeName, dataRegionId);
        if (this.eventCommitterMap.containsKey(committerKey)) {
            LOGGER.warn("Pipe with same name is already registered on this data region, overwriting: {}", (Object)committerKey);
        }
        PipeEventCommitter eventCommitter = new PipeEventCommitter(pipeName, dataRegionId);
        this.eventCommitterMap.put(committerKey, eventCommitter);
        PipeEventCommitMetrics.getInstance().register(eventCommitter, committerKey);
        LOGGER.info("Pipe committer registered for pipe on data region: {}", (Object)committerKey);
    }

    public void deregister(String pipeName, int dataRegionId) {
        String committerKey = PipeEventCommitManager.generateCommitterKey(pipeName, dataRegionId);
        this.eventCommitterMap.remove(committerKey);
        PipeEventCommitMetrics.getInstance().deregister(committerKey);
        LOGGER.info("Pipe committer deregistered for pipe on data region: {}", (Object)committerKey);
    }

    public void enrichWithCommitterKeyAndCommitId(EnrichedEvent event, int dataRegionId) {
        if (event == null || event instanceof PipeHeartbeatEvent || event.getPipeName() == null) {
            return;
        }
        String committerKey = PipeEventCommitManager.generateCommitterKey(event.getPipeName(), dataRegionId);
        PipeEventCommitter committer = this.eventCommitterMap.get(committerKey);
        if (committer == null) {
            return;
        }
        event.setCommitterKeyAndCommitId(committerKey, committer.generateCommitId());
    }

    public void commit(EnrichedEvent event, String committerKey) {
        if (event == null || event instanceof PipeHeartbeatEvent || event.getCommitId() <= -1L || committerKey == null) {
            return;
        }
        PipeEventCommitter committer = this.eventCommitterMap.get(committerKey);
        if (committer == null) {
            return;
        }
        committer.commit(event);
    }

    private static String generateCommitterKey(String pipeName, int dataRegionId) {
        return String.format("%s_%s", pipeName, dataRegionId);
    }

    private PipeEventCommitManager() {
    }

    public static PipeEventCommitManager getInstance() {
        return PipeEventCommitManagerHolder.INSTANCE;
    }

    private static class PipeEventCommitManagerHolder {
        private static final PipeEventCommitManager INSTANCE = new PipeEventCommitManager();

        private PipeEventCommitManagerHolder() {
        }
    }
}

