/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.TabletInsertionDataContainer;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInsertNodeTabletInsertionEvent
extends EnrichedEvent
implements TabletInsertionEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInsertNodeTabletInsertionEvent.class);
    private final WALEntryHandler walEntryHandler;
    private final ProgressIndex progressIndex;
    private final boolean isAligned;
    private final boolean isGeneratedByPipe;
    private TabletInsertionDataContainer dataContainer;

    public PipeInsertNodeTabletInsertionEvent(WALEntryHandler walEntryHandler, ProgressIndex progressIndex, boolean isAligned, boolean isGeneratedByPipe) {
        this(walEntryHandler, progressIndex, isAligned, isGeneratedByPipe, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private PipeInsertNodeTabletInsertionEvent(WALEntryHandler walEntryHandler, ProgressIndex progressIndex, boolean isAligned, boolean isGeneratedByPipe, String pipeName, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        super(pipeName, pipeTaskMeta, pattern, startTime, endTime);
        this.walEntryHandler = walEntryHandler;
        this.progressIndex = progressIndex;
        this.isAligned = isAligned;
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    public InsertNode getInsertNode() throws WALPipeException {
        return this.walEntryHandler.getInsertNode();
    }

    public ByteBuffer getByteBuffer() throws WALPipeException {
        return this.walEntryHandler.getByteBuffer();
    }

    public InsertNode getInsertNodeViaCacheIfPossible() {
        return this.walEntryHandler.getInsertNodeViaCacheIfPossible();
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.wal().pin(this.walEntryHandler);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for memtable %d error. Holder Message: %s", this.walEntryHandler.getMemTableId(), holderMessage), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.wal().unpin(this.walEntryHandler);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for memtable %d error. Holder Message: %s", this.walEntryHandler.getMemTableId(), holderMessage), (Throwable)e);
            return false;
        }
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return this.progressIndex == null ? MinimumProgressIndex.INSTANCE : this.progressIndex;
    }

    @Override
    public PipeInsertNodeTabletInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        return new PipeInsertNodeTabletInsertionEvent(this.walEntryHandler, this.progressIndex, this.isAligned, this.isGeneratedByPipe, pipeName, pipeTaskMeta, pattern, startTime, endTime);
    }

    @Override
    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    @Override
    public boolean mayEventTimeOverlappedWithTimeRange() {
        try {
            InsertNode insertNode = this.getInsertNode();
            if (insertNode instanceof InsertRowNode) {
                long timestamp = ((InsertRowNode)insertNode).getTime();
                return this.startTime <= timestamp && timestamp <= this.endTime;
            }
            if (insertNode instanceof InsertTabletNode) {
                long[] timestamps = ((InsertTabletNode)insertNode).getTimes();
                if (Objects.isNull(timestamps) || timestamps.length == 0) {
                    return false;
                }
                return this.startTime <= timestamps[timestamps.length - 1] && timestamps[0] <= this.endTime;
            }
            throw new UnSupportedDataTypeException(String.format("InsertNode type %s is not supported.", insertNode.getClass().getName()));
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when determining the event time of PipeInsertNodeTabletInsertionEvent({}) overlaps with the time range: [{}, {}]. Returning true to ensure data integrity.", new Object[]{this, this.startTime, this.endTime, e});
            return true;
        }
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        try {
            if (this.dataContainer == null) {
                this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.getInsertNode(), this.getPattern());
            }
            return this.dataContainer.processRowByRow(consumer);
        }
        catch (Exception e) {
            throw new PipeException("Process row by row error.", (Throwable)e);
        }
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        try {
            if (this.dataContainer == null) {
                this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.getInsertNode(), this.getPattern());
            }
            return this.dataContainer.processTablet(consumer);
        }
        catch (Exception e) {
            throw new PipeException("Process tablet error.", (Throwable)e);
        }
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public Tablet convertToTablet() {
        try {
            if (this.dataContainer == null) {
                this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.getInsertNode(), this.getPattern());
            }
            return this.dataContainer.convertToTablet();
        }
        catch (Exception e) {
            throw new PipeException("Convert to tablet error.", (Throwable)e);
        }
    }

    public TabletInsertionEvent parseEventWithPatternOrTime() {
        return new PipeRawTabletInsertionEvent(this.convertToTablet(), this.isAligned, this.pipeName, this.pipeTaskMeta, this, true);
    }

    @Override
    public String toString() {
        return String.format("PipeInsertNodeTabletInsertionEvent{walEntryHandler=%s, progressIndex=%s, isAligned=%s, isGeneratedByPipe=%s, dataContainer=%s}", this.walEntryHandler, this.progressIndex, this.isAligned, this.isGeneratedByPipe, this.dataContainer) + " - " + super.toString();
    }
}

