/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.builder.IoTDBThriftAsyncPipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTabletBatchEventHandler
implements AsyncMethodCallback<TPipeTransferResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletBatchEventHandler.class);
    private final List<Long> requestCommitIds;
    private final List<Event> events;
    private final TPipeTransferReq req;
    private final IoTDBThriftAsyncConnector connector;

    public PipeTransferTabletBatchEventHandler(IoTDBThriftAsyncPipeTransferBatchReqBuilder batchBuilder, IoTDBThriftAsyncConnector connector) throws IOException {
        this.requestCommitIds = batchBuilder.deepcopyRequestCommitIds();
        this.events = batchBuilder.deepcopyEvents();
        this.req = batchBuilder.toTPipeTransferReq();
        this.connector = connector;
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException {
        client.pipeTransfer(this.req, (AsyncMethodCallback)this);
    }

    public void onComplete(TPipeTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeTransferResp is null")));
            return;
        }
        if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            for (Event event : this.events) {
                if (!(event instanceof EnrichedEvent)) continue;
                ((EnrichedEvent)event).decreaseReferenceCount(PipeTransferTabletBatchEventHandler.class.getName(), true);
            }
        } else {
            this.onError((Exception)((Object)new PipeException(response.getStatus().getMessage())));
        }
    }

    public void onError(Exception exception) {
        LOGGER.warn("Failed to transfer TabletInsertionEvent batch {} (request commit ids={}).", new Object[]{this.events, this.requestCommitIds, exception});
        for (Event event : this.events) {
            this.connector.addFailureEventToRetryQueue(event);
        }
    }
}

