/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.IoTDBConnector;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.builder.IoTDBThriftAsyncPipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncClientManager;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletBatchEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletInsertNodeEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletRawEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTsFileInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBThriftSyncConnector;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftAsyncConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftAsyncConnector.class);
    private static final String THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT = "Failed to borrow client from client pool or exception occurred when sending to receiver.";
    private static final String THRIFT_ERROR_FORMATTER_WITH_ENDPOINT = "Failed to borrow client from client pool or exception occurred when sending to receiver %s:%s.";
    private IoTDBThriftAsyncClientManager clientManager;
    private final IoTDBThriftSyncConnector retryConnector = new IoTDBThriftSyncConnector();
    private final PriorityBlockingQueue<Event> retryEventQueue = new PriorityBlockingQueue<Event>(11, Comparator.comparing(e -> e instanceof EnrichedEvent ? ((EnrichedEvent)e).getCommitId() : 0L));
    private IoTDBThriftAsyncPipeTransferBatchReqBuilder tabletBatchBuilder;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        this.retryConnector.validate(validator);
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] == false && (Boolean)args[1] == false && (Boolean)args[2] == false, "Only 'iotdb-thrift-ssl-sink' supports SSL transmission currently.", new Object[]{parameters.getBooleanOrDefault("sink.ssl.enable", false), parameters.hasAttribute("sink.ssl.trust-store-path"), parameters.hasAttribute("sink.ssl.trust-store-pwd")});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        PipeParameters retryParameters = new PipeParameters(new HashMap(parameters.getAttribute()));
        retryParameters.getAttribute().put("sink.batch.enable", "false");
        retryParameters.getAttribute().put("connector.batch.enable", "false");
        this.retryConnector.customize(retryParameters, configuration);
        this.clientManager = new IoTDBThriftAsyncClientManager(this.nodeUrls, parameters.getBooleanOrDefault(Arrays.asList("sink.leader-cache.enable", "connector.leader-cache.enable"), true));
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new IoTDBThriftAsyncPipeTransferBatchReqBuilder(parameters);
        }
    }

    public synchronized void handshake() throws Exception {
        this.retryConnector.handshake();
    }

    public void heartbeat() {
        this.retryConnector.heartbeat();
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary();
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Current event: {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (((EnrichedEvent)tabletInsertionEvent).shouldParsePatternOrTime()) {
            if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.transfer(((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).parseEventWithPatternOrTime());
            } else {
                this.transfer(((PipeRawTabletInsertionEvent)tabletInsertionEvent).parseEventWithPatternOrTime());
            }
            return;
        }
        if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent && ((PipeRawTabletInsertionEvent)tabletInsertionEvent).hasNoNeedParsingAndIsEmpty()) {
            return;
        }
        if (this.isTabletBatchModeEnabled) {
            if (this.tabletBatchBuilder.onEvent(tabletInsertionEvent)) {
                PipeTransferTabletBatchEventHandler pipeTransferTabletBatchEventHandler = new PipeTransferTabletBatchEventHandler(this.tabletBatchBuilder, this);
                this.transfer(pipeTransferTabletBatchEventHandler);
                this.tabletBatchBuilder.onSuccess();
            }
        } else if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            TPipeTransferReq pipeTransferReq = Objects.isNull(insertNode) ? PipeTransferTabletBinaryReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer()) : PipeTransferTabletInsertNodeReq.toTPipeTransferReq(insertNode);
            PipeTransferTabletInsertNodeEventHandler pipeTransferInsertNodeReqHandler = new PipeTransferTabletInsertNodeEventHandler(pipeInsertNodeTabletInsertionEvent, pipeTransferReq, this);
            this.transfer(pipeTransferInsertNodeReqHandler);
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)tabletInsertionEvent;
            PipeTransferTabletRawReq pipeTransferTabletRawReq = PipeTransferTabletRawReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned());
            PipeTransferTabletRawEventHandler pipeTransferTabletReqHandler = new PipeTransferTabletRawEventHandler(pipeRawTabletInsertionEvent, (TPipeTransferReq)pipeTransferTabletRawReq, this);
            this.transfer(pipeTransferTabletReqHandler);
        }
    }

    private void transfer(PipeTransferTabletBatchEventHandler pipeTransferTabletBatchEventHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferTabletBatchEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTabletBatchEventHandler.onError(ex);
        }
    }

    private void transfer(PipeTransferTabletInsertNodeEventHandler pipeTransferInsertNodeReqHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferInsertNodeReqHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferInsertNodeReqHandler.onError(ex);
        }
    }

    private void transfer(PipeTransferTabletRawEventHandler pipeTransferTabletReqHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferTabletReqHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTabletReqHandler.onError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        if (!pipeTsFileInsertionEvent.waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)pipeTsFileInsertionEvent.getTsFile());
            return;
        }
        if (pipeTsFileInsertionEvent.shouldParsePatternOrTime()) {
            try {
                for (TabletInsertionEvent event : pipeTsFileInsertionEvent.toTabletInsertionEvents()) {
                    this.transfer(event);
                }
            }
            finally {
                pipeTsFileInsertionEvent.close();
            }
            return;
        }
        if (!pipeTsFileInsertionEvent.getTsFile().exists()) {
            throw new FileNotFoundException(pipeTsFileInsertionEvent.getTsFile().getAbsolutePath());
        }
        PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler = new PipeTransferTsFileInsertionEventHandler(pipeTsFileInsertionEvent, this);
        this.transfer(pipeTransferTsFileInsertionEventHandler);
    }

    private void transfer(PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferTsFileInsertionEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTsFileInsertionEventHandler.onError(ex);
        }
    }

    public void transfer(Event event) throws Exception {
        this.transferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    public void updateLeaderCache(String deviceId, TEndPoint endPoint) {
        this.clientManager.updateLeaderCache(deviceId, endPoint);
    }

    private void logOnClientException(AsyncPipeDataTransferServiceClient client, Exception e) {
        if (client == null) {
            LOGGER.warn(THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT, (Throwable)e);
        } else {
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER_WITH_ENDPOINT, client.getIp(), client.getPort()), (Throwable)e);
        }
    }

    private synchronized void transferQueuedEventsIfNecessary() throws Exception {
        while (!this.retryEventQueue.isEmpty()) {
            Event polledEvent;
            Event peekedEvent = this.retryEventQueue.peek();
            if (peekedEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.retryConnector.transfer((PipeInsertNodeTabletInsertionEvent)peekedEvent);
            } else if (peekedEvent instanceof PipeRawTabletInsertionEvent) {
                this.retryConnector.transfer((PipeRawTabletInsertionEvent)peekedEvent);
            } else if (peekedEvent instanceof PipeTsFileInsertionEvent) {
                this.retryConnector.transfer((PipeTsFileInsertionEvent)peekedEvent);
            } else {
                LOGGER.warn("IoTDBThriftAsyncConnector does not support transfer generic event: {}.", (Object)peekedEvent);
            }
            if (peekedEvent instanceof EnrichedEvent) {
                ((EnrichedEvent)peekedEvent).decreaseReferenceCount(IoTDBThriftAsyncConnector.class.getName(), true);
            }
            if ((polledEvent = this.retryEventQueue.poll()) != peekedEvent) {
                LOGGER.error("The event polled from the queue is not the same as the event peeked from the queue. Peeked event: {}, polled event: {}.", (Object)peekedEvent, (Object)polledEvent);
            }
            if (polledEvent == null) continue;
            LOGGER.info("Polled event {} from retry queue.", (Object)polledEvent);
        }
    }

    private void transferBatchedEventsIfNecessary() throws IOException {
        if (!this.isTabletBatchModeEnabled || this.tabletBatchBuilder.isEmpty()) {
            return;
        }
        this.transfer(new PipeTransferTabletBatchEventHandler(this.tabletBatchBuilder, this));
        this.tabletBatchBuilder.onSuccess();
    }

    public synchronized void addFailureEventToRetryQueue(Event event) {
        this.retryEventQueue.offer(event);
        LOGGER.info("Added event {} to retry queue.", (Object)event);
    }

    public synchronized void discardEventsOfPipe(String pipeNameToDrop) {
        this.retryEventQueue.removeIf(event -> event instanceof EnrichedEvent && pipeNameToDrop.equals(((EnrichedEvent)event).getPipeName()));
    }

    public synchronized void close() throws Exception {
        this.retryConnector.close();
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
    }

    public int getRetryEventQueueSize() {
        return this.retryEventQueue.size();
    }
}

