/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderCacheManager.class);
    private static final PipeConfig CONFIG = PipeConfig.getInstance();
    private final AtomicDouble memoryUsageCheatFactor = new AtomicDouble(1.0);
    private final Cache<String, TEndPoint> device2endpoint;
    private final ConcurrentHashMap<TEndPoint, TEndPoint> endPoints = new ConcurrentHashMap();

    public LeaderCacheManager() {
        long initMemorySizeInBytes = PipeResourceManager.memory().getTotalMemorySizeInBytes() / 10L;
        long maxMemorySizeInBytes = (long)((float)PipeResourceManager.memory().getTotalMemorySizeInBytes() * CONFIG.getPipeLeaderCacheMemoryUsagePercentage());
        PipeMemoryBlock allocatedMemoryBlock = PipeResourceManager.memory().tryAllocate(initMemorySizeInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 1L)).setShrinkCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.set(this.memoryUsageCheatFactor.get() * ((double)oldMemory.longValue() / (double)newMemory.longValue()));
            LOGGER.info("LeaderCacheManager.allocatedMemoryBlock has shrunk from {} to {}.", oldMemory, newMemory);
        }).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, maxMemorySizeInBytes)).setExpandCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.set(this.memoryUsageCheatFactor.get() / ((double)newMemory.longValue() / (double)oldMemory.longValue()));
            LOGGER.info("LeaderCacheManager.allocatedMemoryBlock has expanded from {} to {}.", oldMemory, newMemory);
        });
        this.device2endpoint = Caffeine.newBuilder().maximumWeight(allocatedMemoryBlock.getMemoryUsageInBytes()).weigher((device, endPoint) -> {
            long weightInLong = (long)((double)device.getBytes().length * this.memoryUsageCheatFactor.get());
            if (weightInLong <= 0L) {
                return Integer.MAX_VALUE;
            }
            int weightInInt = (int)weightInLong;
            return (long)weightInInt != weightInLong ? Integer.MAX_VALUE : weightInInt;
        }).recordStats().build();
    }

    public TEndPoint getLeaderEndPoint(String deviceId) {
        return deviceId == null ? null : (TEndPoint)this.device2endpoint.getIfPresent((Object)deviceId);
    }

    public void updateLeaderEndPoint(String deviceId, TEndPoint endPoint) {
        TEndPoint endPointFromMap = this.endPoints.putIfAbsent(endPoint, endPoint);
        if (endPointFromMap != null) {
            this.device2endpoint.put((Object)deviceId, (Object)endPointFromMap);
        } else {
            this.device2endpoint.put((Object)deviceId, (Object)endPoint);
        }
    }
}

