/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine.dataregion;

import java.util.LinkedList;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ComparableConsensusRequest;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.IoTProgressIndex;
import org.apache.iotdb.consensus.common.request.BatchIndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.DeserializedBatchIndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.IoTConsensusRequest;
import org.apache.iotdb.db.consensus.statemachine.dataregion.DataRegionStateMachine;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTConsensusDataRegionStateMachine
extends DataRegionStateMachine {
    public static final Logger LOGGER = LoggerFactory.getLogger(IoTConsensusDataRegionStateMachine.class);

    public IoTConsensusDataRegionStateMachine(DataRegion region) {
        super(region);
    }

    @Override
    public TSStatus write(IConsensusRequest request) {
        try {
            if (request instanceof DeserializedBatchIndexedConsensusRequest) {
                LinkedList<TSStatus> subStatus = new LinkedList<TSStatus>();
                for (IConsensusRequest consensusRequest : ((DeserializedBatchIndexedConsensusRequest)request).getInsertNodes()) {
                    subStatus.add(this.write((PlanNode)consensusRequest));
                }
                return new TSStatus().setSubStatus(subStatus);
            }
            return this.write((PlanNode)request);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @Override
    public IConsensusRequest deserializeRequest(IConsensusRequest request) {
        PlanNode result;
        if (request instanceof IndexedConsensusRequest) {
            IndexedConsensusRequest indexedRequest = (IndexedConsensusRequest)request;
            result = this.grabInsertNode(indexedRequest);
        } else if (request instanceof BatchIndexedConsensusRequest) {
            BatchIndexedConsensusRequest batchRequest = (BatchIndexedConsensusRequest)request;
            DeserializedBatchIndexedConsensusRequest deserializedRequest = new DeserializedBatchIndexedConsensusRequest(batchRequest.getStartSyncIndex(), batchRequest.getEndSyncIndex(), batchRequest.getRequests().size());
            for (IndexedConsensusRequest indexedRequest : batchRequest.getRequests()) {
                PlanNode planNode = this.grabInsertNode(indexedRequest);
                if (planNode instanceof ComparableConsensusRequest) {
                    IoTProgressIndex ioTProgressIndex = new IoTProgressIndex(Integer.valueOf(batchRequest.getSourcePeerId()), Long.valueOf(indexedRequest.getSyncIndex()));
                    ((ComparableConsensusRequest)planNode).setProgressIndex((ProgressIndex)ioTProgressIndex);
                }
                deserializedRequest.add((IConsensusRequest)planNode);
            }
            result = deserializedRequest;
        } else {
            result = this.getPlanNode(request);
        }
        return result;
    }

    @Override
    protected PlanNode getPlanNode(IConsensusRequest request) {
        PlanNode node;
        if (request instanceof ByteBufferConsensusRequest) {
            node = PlanNodeType.deserialize(request.serializeToByteBuffer());
        } else if (request instanceof IoTConsensusRequest) {
            node = WALEntry.deserializeForConsensus(request.serializeToByteBuffer());
        } else if (request instanceof PlanNode) {
            node = (PlanNode)request;
        } else {
            LOGGER.error("Unexpected IConsensusRequest : {}", (Object)request);
            throw new IllegalArgumentException("Unexpected IConsensusRequest!");
        }
        return node;
    }
}

