/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.reporter.JmxReporter;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class AbstractMetricManager {
    protected static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    private static final String ALREADY_EXISTS = " is already used for a different type of name";
    protected Map<String, MetricInfo.MetaInfo> nameToMetaInfo = new ConcurrentHashMap<String, MetricInfo.MetaInfo>();
    protected Map<MetricInfo, IMetric> metrics = new ConcurrentHashMap<MetricInfo, IMetric>();
    protected JmxReporter bindJmxReporter = null;

    protected AbstractMetricManager() {
    }

    private void notifyReporterOnAdd(IMetric metric, MetricInfo metricInfo) {
        Optional.ofNullable(this.bindJmxReporter).ifPresent(x -> this.bindJmxReporter.registerMetric(metric, metricInfo));
    }

    private void notifyReporterOnRemove(IMetric metric, MetricInfo metricInfo) {
        Optional.ofNullable(this.bindJmxReporter).ifPresent(x -> this.bindJmxReporter.unregisterMetric(metric, metricInfo));
    }

    public Counter getOrCreateCounter(String name, MetricLevel metricLevel, String ... tags) {
        if (this.invalid(metricLevel, name, tags)) {
            return DoNothingMetricManager.DO_NOTHING_COUNTER;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.COUNTER, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Counter counter = this.createCounter();
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            this.notifyReporterOnAdd(counter, metricInfo);
            return counter;
        });
        if (metric instanceof Counter) {
            return (Counter)metric;
        }
        throw new IllegalArgumentException(metricInfo + ALREADY_EXISTS);
    }

    protected abstract Counter createCounter();

    public <T> AutoGauge createAutoGauge(String name, MetricLevel metricLevel, T obj, ToDoubleFunction<T> mapper, String ... tags) {
        if (this.invalid(metricLevel, name, tags)) {
            return DoNothingMetricManager.DO_NOTHING_AUTO_GAUGE;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.AUTO_GAUGE, name, tags);
        AutoGauge gauge = this.createAutoGauge(obj, mapper);
        this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
        this.metrics.put(metricInfo, gauge);
        this.notifyReporterOnAdd(gauge, metricInfo);
        return gauge;
    }

    protected abstract <T> AutoGauge createAutoGauge(T var1, ToDoubleFunction<T> var2);

    public AutoGauge getAutoGauge(String name, MetricLevel metricLevel, String ... tags) {
        if (this.invalid(metricLevel, name, tags)) {
            return DoNothingMetricManager.DO_NOTHING_AUTO_GAUGE;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.AUTO_GAUGE, name, tags);
        IMetric metric = this.metrics.get(metricInfo);
        if (metric == null) {
            return DoNothingMetricManager.DO_NOTHING_AUTO_GAUGE;
        }
        if (metric instanceof AutoGauge) {
            return (AutoGauge)metric;
        }
        throw new IllegalArgumentException(metricInfo + ALREADY_EXISTS);
    }

    public Gauge getOrCreateGauge(String name, MetricLevel metricLevel, String ... tags) {
        if (this.invalid(metricLevel, name, tags)) {
            return DoNothingMetricManager.DO_NOTHING_GAUGE;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.GAUGE, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Gauge gauge = this.createGauge();
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            this.notifyReporterOnAdd(gauge, metricInfo);
            return gauge;
        });
        if (metric instanceof Gauge) {
            return (Gauge)metric;
        }
        throw new IllegalArgumentException(metricInfo + ALREADY_EXISTS);
    }

    protected abstract Gauge createGauge();

    public Rate getOrCreateRate(String name, MetricLevel metricLevel, String ... tags) {
        if (this.invalid(metricLevel, name, tags)) {
            return DoNothingMetricManager.DO_NOTHING_RATE;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.RATE, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Rate rate = this.createRate();
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            this.notifyReporterOnAdd(rate, metricInfo);
            return rate;
        });
        if (metric instanceof Rate) {
            return (Rate)metric;
        }
        throw new IllegalArgumentException(metricInfo + ALREADY_EXISTS);
    }

    protected abstract Rate createRate();

    public Histogram getOrCreateHistogram(String name, MetricLevel metricLevel, String ... tags) {
        if (this.invalid(metricLevel, name, tags)) {
            return DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.HISTOGRAM, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Histogram histogram = this.createHistogram(metricInfo);
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            this.notifyReporterOnAdd(histogram, metricInfo);
            return histogram;
        });
        if (metric instanceof Histogram) {
            return (Histogram)metric;
        }
        throw new IllegalArgumentException(metricInfo + ALREADY_EXISTS);
    }

    protected abstract Histogram createHistogram(MetricInfo var1);

    public Timer getOrCreateTimer(String name, MetricLevel metricLevel, String ... tags) {
        if (this.invalid(metricLevel, name, tags)) {
            return DoNothingMetricManager.DO_NOTHING_TIMER;
        }
        MetricInfo metricInfo = new MetricInfo(MetricType.TIMER, name, tags);
        IMetric metric = this.metrics.computeIfAbsent(metricInfo, key -> {
            Timer timer = this.createTimer();
            this.nameToMetaInfo.put(name, metricInfo.getMetaInfo());
            this.notifyReporterOnAdd(timer, metricInfo);
            return timer;
        });
        if (metric instanceof Timer) {
            return (Timer)metric;
        }
        throw new IllegalArgumentException(metricInfo + ALREADY_EXISTS);
    }

    protected abstract Timer createTimer();

    public Counter count(long delta, String name, MetricLevel metricLevel, String ... tags) {
        Counter counter = this.getOrCreateCounter(name, metricLevel, tags);
        counter.inc(delta);
        return counter;
    }

    public Gauge gauge(long value, String name, MetricLevel metricLevel, String ... tags) {
        Gauge gauge = this.getOrCreateGauge(name, metricLevel, tags);
        gauge.set(value);
        return gauge;
    }

    public Rate rate(long value, String name, MetricLevel metricLevel, String ... tags) {
        Rate rate = this.getOrCreateRate(name, metricLevel, tags);
        rate.mark(value);
        return rate;
    }

    public Histogram histogram(long value, String name, MetricLevel metricLevel, String ... tags) {
        Histogram histogram = this.getOrCreateHistogram(name, metricLevel, tags);
        histogram.update(value);
        return histogram;
    }

    public Timer timer(long delta, TimeUnit timeUnit, String name, MetricLevel metricLevel, String ... tags) {
        Timer timer = this.getOrCreateTimer(name, metricLevel, tags);
        timer.update(delta, timeUnit);
        return timer;
    }

    public List<Pair<String, String[]>> getAllMetricKeys() {
        ArrayList<Pair<String, String[]>> keys = new ArrayList<Pair<String, String[]>>(this.metrics.size());
        this.metrics.keySet().forEach(k -> keys.add(k.toStringArray()));
        return keys;
    }

    public Map<MetricInfo, IMetric> getAllMetrics() {
        return this.metrics;
    }

    public Map<MetricInfo, IMetric> getMetricsByType(MetricType metricType) {
        HashMap<MetricInfo, IMetric> result = new HashMap<MetricInfo, IMetric>();
        for (Map.Entry<MetricInfo, IMetric> entry : this.metrics.entrySet()) {
            if (entry.getKey().getMetaInfo().getType() != metricType) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void remove(MetricType type, String name, String ... tags) {
        MetricInfo metricInfo = new MetricInfo(type, name, tags);
        if (this.metrics.containsKey(metricInfo)) {
            if (type == metricInfo.getMetaInfo().getType()) {
                this.notifyReporterOnRemove(this.metrics.get(metricInfo), metricInfo);
                this.nameToMetaInfo.remove(metricInfo.getName());
                this.metrics.remove(metricInfo);
                this.removeMetric(type, metricInfo);
            } else {
                throw new IllegalArgumentException(metricInfo + " failed to remove because the mismatch of type. ");
            }
        }
    }

    protected abstract void removeMetric(MetricType var1, MetricInfo var2);

    public boolean isEnableMetricInGivenLevel(MetricLevel metricLevel) {
        return MetricLevel.higherOrEqual(metricLevel, METRIC_CONFIG.getMetricLevel());
    }

    public void setBindJmxReporter(JmxReporter reporter) {
        this.bindJmxReporter = reporter;
    }

    protected boolean stop() {
        this.metrics = new ConcurrentHashMap<MetricInfo, IMetric>();
        this.nameToMetaInfo = new ConcurrentHashMap<String, MetricInfo.MetaInfo>();
        return this.stopFramework();
    }

    protected abstract boolean stopFramework();

    private boolean invalid(MetricLevel metricLevel, String name, String ... tags) {
        if (!this.isEnableMetricInGivenLevel(metricLevel)) {
            return true;
        }
        MetricInfo.MetaInfo metaInfo = this.nameToMetaInfo.get(name);
        if (metaInfo == null) {
            return false;
        }
        return !metaInfo.hasSameKey(tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMetricManager that = (AbstractMetricManager)o;
        return Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.metrics);
    }
}

