/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import io.airlift.slice.SizeOf;
import java.util.Arrays;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumn;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class LongColumnBuilder
implements ColumnBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongColumnBuilder.class).instanceSize();
    public static final LongColumn NULL_VALUE_BLOCK = new LongColumn(0, 1, new boolean[]{true}, new long[1]);
    private final ColumnBuilderStatus columnBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private long[] values = new long[0];
    private long retainedSizeInBytes;

    public LongColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.columnBuilderStatus = columnBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    public ColumnBuilder writeLong(long value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(9);
        }
        return this;
    }

    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Long) {
            this.writeLong((Long)value);
            return this;
        }
        throw new UnSupportedDataTypeException("LongColumn only support Long data type");
    }

    public ColumnBuilder write(Column column, int index) {
        return this.writeLong(column.getLong(index));
    }

    public ColumnBuilder writeTsPrimitiveType(TsPrimitiveType value) {
        return this.writeLong(value.getLong());
    }

    public ColumnBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(9);
        }
        return this;
    }

    public Column build() {
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedColumn(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new LongColumn(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    public TSDataType getDataType() {
        return TSDataType.INT64;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new LongColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((long[])this.values);
        if (this.columnBuilderStatus != null) {
            this.retainedSizeInBytes += (long)ColumnBuilderStatus.INSTANCE_SIZE;
        }
    }
}

