/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import org.apache.iotdb.tsfile.exception.NullFieldException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class Field {
    private final TSDataType dataType;
    private boolean boolV;
    private int intV;
    private long longV;
    private float floatV;
    private double doubleV;
    private Binary binaryV;

    public Field(TSDataType dataType) {
        this.dataType = dataType;
    }

    public static Field copy(Field field) {
        Field out = new Field(field.dataType);
        if (out.dataType != null) {
            switch (out.dataType) {
                case DOUBLE: {
                    out.setDoubleV(field.getDoubleV());
                    break;
                }
                case FLOAT: {
                    out.setFloatV(field.getFloatV());
                    break;
                }
                case INT64: {
                    out.setLongV(field.getLongV());
                    break;
                }
                case INT32: {
                    out.setIntV(field.getIntV());
                    break;
                }
                case BOOLEAN: {
                    out.setBoolV(field.getBoolV());
                    break;
                }
                case TEXT: {
                    out.setBinaryV(field.getBinaryV());
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(out.dataType.toString());
                }
            }
        }
        return out;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public boolean getBoolV() {
        if (this.dataType == null) {
            throw new NullFieldException();
        }
        return this.boolV;
    }

    public void setBoolV(boolean boolV) {
        this.boolV = boolV;
    }

    public int getIntV() {
        if (this.dataType == null) {
            throw new NullFieldException();
        }
        return this.intV;
    }

    public void setIntV(int intV) {
        this.intV = intV;
    }

    public long getLongV() {
        if (this.dataType == null) {
            throw new NullFieldException();
        }
        return this.longV;
    }

    public void setLongV(long longV) {
        this.longV = longV;
    }

    public float getFloatV() {
        if (this.dataType == null) {
            throw new NullFieldException();
        }
        return this.floatV;
    }

    public void setFloatV(float floatV) {
        this.floatV = floatV;
    }

    public double getDoubleV() {
        if (this.dataType == null) {
            throw new NullFieldException();
        }
        return this.doubleV;
    }

    public void setDoubleV(double doubleV) {
        this.doubleV = doubleV;
    }

    public Binary getBinaryV() {
        if (this.dataType == null) {
            throw new NullFieldException();
        }
        return this.binaryV;
    }

    public void setBinaryV(Binary binaryV) {
        this.binaryV = binaryV;
    }

    public String getStringValue() {
        if (this.dataType == null) {
            return "null";
        }
        switch (this.dataType) {
            case BOOLEAN: {
                return String.valueOf(this.boolV);
            }
            case INT32: {
                return String.valueOf(this.intV);
            }
            case INT64: {
                return String.valueOf(this.longV);
            }
            case FLOAT: {
                return String.valueOf(this.floatV);
            }
            case DOUBLE: {
                return String.valueOf(this.doubleV);
            }
            case TEXT: {
                return this.binaryV.toString();
            }
        }
        throw new UnSupportedDataTypeException(this.dataType.toString());
    }

    public String toString() {
        return this.getStringValue();
    }

    public Object getObjectValue(TSDataType dataType) {
        if (this.dataType == null) {
            return null;
        }
        switch (dataType) {
            case DOUBLE: {
                return this.getDoubleV();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloatV());
            }
            case INT64: {
                return this.getLongV();
            }
            case INT32: {
                return this.getIntV();
            }
            case BOOLEAN: {
                return this.getBoolV();
            }
            case TEXT: {
                return this.getBinaryV();
            }
        }
        throw new UnSupportedDataTypeException(dataType.toString());
    }

    public static Field getField(Object value, TSDataType dataType) {
        if (value == null) {
            return null;
        }
        Field field = new Field(dataType);
        switch (dataType) {
            case INT32: {
                field.setIntV((Integer)value);
                break;
            }
            case INT64: {
                field.setLongV((Long)value);
                break;
            }
            case FLOAT: {
                field.setFloatV(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                field.setDoubleV((Double)value);
                break;
            }
            case BOOLEAN: {
                field.setBoolV((Boolean)value);
                break;
            }
            case TEXT: {
                field.setBinaryV((Binary)value);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(dataType.toString());
            }
        }
        return field;
    }

    public static void setTsPrimitiveValue(TsPrimitiveType value, Field field) {
        switch (value.getDataType()) {
            case BOOLEAN: {
                field.setBoolV(value.getBoolean());
                break;
            }
            case INT32: {
                field.setIntV(value.getInt());
                break;
            }
            case INT64: {
                field.setLongV(value.getLong());
                break;
            }
            case FLOAT: {
                field.setFloatV(value.getFloat());
                break;
            }
            case DOUBLE: {
                field.setDoubleV(value.getDouble());
                break;
            }
            case TEXT: {
                field.setBinaryV(value.getBinary());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("UnSupported" + value.getDataType());
            }
        }
    }
}

