/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class PipeEnrichedPlan
extends ConfigPhysicalPlan {
    private ConfigPhysicalPlan innerPlan;

    public PipeEnrichedPlan() {
        super(ConfigPhysicalPlanType.PipeEnriched);
    }

    public PipeEnrichedPlan(ConfigPhysicalPlan innerPlan) {
        super(ConfigPhysicalPlanType.PipeEnriched);
        this.innerPlan = innerPlan;
    }

    public ConfigPhysicalPlan getInnerPlan() {
        return this.innerPlan;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.write(this.innerPlan.serializeToByteBuffer().array());
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.innerPlan = ConfigPhysicalPlan.Factory.create(buffer);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeEnrichedPlan that = (PipeEnrichedPlan)obj;
        return this.innerPlan.equals(that.innerPlan);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.innerPlan);
    }

    public String toString() {
        return "PipeEnrichedPlan{innerPlan='" + this.innerPlan + "'}";
    }
}

