/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GetSeriesSlotListPlan
extends ConfigPhysicalPlan {
    private String database;
    private TConsensusGroupType partitionType;

    public GetSeriesSlotListPlan() {
        super(ConfigPhysicalPlanType.GetSeriesSlotList);
    }

    public GetSeriesSlotListPlan(String database, TConsensusGroupType partitionType) {
        this();
        this.database = database;
        this.partitionType = partitionType;
    }

    public String getDatabase() {
        return this.database;
    }

    public TConsensusGroupType getPartitionType() {
        return this.partitionType;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        stream.writeInt(this.partitionType.ordinal());
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.database = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.partitionType = TConsensusGroupType.findByValue((int)buffer.getInt());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSeriesSlotListPlan that = (GetSeriesSlotListPlan)o;
        return this.database.equals(that.database) && this.partitionType.equals((Object)that.partitionType);
    }

    @Override
    public int hashCode() {
        int hashcode = 1;
        hashcode = hashcode * 31 + Objects.hash(this.database);
        hashcode = hashcode * 31 + Objects.hash(this.partitionType.ordinal());
        return hashcode;
    }
}

