/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.AbstractAsyncRPCHandler;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTSStatusRPCHandler
extends AbstractAsyncRPCHandler<TSStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTSStatusRPCHandler.class);

    public AsyncTSStatusRPCHandler(DataNodeRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TSStatus> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TSStatus response) {
        this.responseMap.put(this.requestId, response);
        if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.dataNodeLocationMap.remove(this.requestId);
            LOGGER.info("Successfully {} on DataNode: {}", (Object)this.requestType, (Object)this.formattedTargetLocation);
        } else {
            LOGGER.error("Failed to {} on DataNode: {}, response: {}", new Object[]{this.requestType, this.formattedTargetLocation, response});
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Failed to " + (Object)((Object)this.requestType) + " on DataNode: " + this.formattedTargetLocation + ", exception: " + e.getMessage();
        LOGGER.error(errorMsg);
        this.responseMap.put(this.requestId, new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
        this.countDownLatch.countDown();
    }
}

