/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PathPatternNode<V, VSerializer extends Serializer<V>> {
    private final String name;
    private final Map<String, PathPatternNode<V, VSerializer>> children;
    private Set<V> valueSet;
    private boolean mark = false;
    private final VSerializer serializer;

    public PathPatternNode(String name, VSerializer serializer) {
        this.name = name;
        this.children = new HashMap<String, PathPatternNode<V, VSerializer>>();
        this.serializer = serializer;
    }

    public PathPatternNode(String name, Supplier<? extends Set<V>> supplier, VSerializer serialize) {
        this.name = name;
        this.children = new HashMap<String, PathPatternNode<V, VSerializer>>();
        this.valueSet = supplier.get();
        this.serializer = serialize;
    }

    public String getName() {
        return this.name;
    }

    public PathPatternNode<V, VSerializer> getChildren(String nodeName) {
        return this.children.getOrDefault(nodeName, null);
    }

    public List<PathPatternNode<V, VSerializer>> getMatchChildren(String nodeName) {
        ArrayList<PathPatternNode<V, VSerializer>> res = new ArrayList<PathPatternNode<V, VSerializer>>();
        if (this.children.containsKey(nodeName)) {
            res.add(this.children.get(nodeName));
        }
        if (this.children.containsKey("*")) {
            res.add(this.children.get("*"));
        }
        if (this.children.containsKey("**")) {
            res.add(this.children.get("**"));
        }
        return res;
    }

    public Map<String, PathPatternNode<V, VSerializer>> getChildren() {
        return this.children;
    }

    public void addChild(PathPatternNode<V, VSerializer> tmpNode) {
        this.children.put(tmpNode.getName(), tmpNode);
    }

    public void deleteChild(PathPatternNode<V, VSerializer> tmpNode) {
        this.children.remove(tmpNode.getName());
    }

    public void appendValue(V value, BiConsumer<V, Set<V>> remappingFunction) {
        remappingFunction.accept(value, this.valueSet);
    }

    public void deleteValue(V value, BiConsumer<V, Set<V>> remappingFunction) {
        remappingFunction.accept(value, this.valueSet);
    }

    public Collection<V> getValues() {
        return this.valueSet;
    }

    public boolean isPathPattern() {
        return this.mark || this.isLeaf();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isWildcard() {
        return PathPatternUtil.hasWildcard(this.name);
    }

    public boolean isMultiLevelWildcard() {
        return this.name.equals("**");
    }

    public void markPathPattern(boolean mark) {
        this.mark = mark;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPatternNode that = (PathPatternNode)o;
        return this.mark == that.mark && Objects.equals(this.name, that.name) && Objects.equals(this.children, that.children) && Objects.equals(this.valueSet, that.valueSet);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.children, this.valueSet, this.mark);
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)buffer);
        if (this.valueSet == null) {
            ReadWriteIOUtils.write((int)(this.mark ? -1 : -2), (ByteBuffer)buffer);
        } else {
            ReadWriteIOUtils.write((int)this.valueSet.size(), (ByteBuffer)buffer);
            for (V value : this.valueSet) {
                this.serializer.write(value, buffer);
            }
        }
        ReadWriteIOUtils.write((int)this.children.size(), (ByteBuffer)buffer);
        this.serializeChildren(buffer);
    }

    void serializeChildren(ByteBuffer buffer) {
        for (PathPatternNode<V, VSerializer> childNode : this.children.values()) {
            childNode.serialize(buffer);
        }
    }

    public void serialize(PublicBAOS outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        if (this.valueSet == null) {
            ReadWriteIOUtils.write((int)(this.mark ? -1 : -2), (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write((int)this.valueSet.size(), (OutputStream)outputStream);
            for (V value : this.valueSet) {
                this.serializer.write(value, outputStream);
            }
        }
        ReadWriteIOUtils.write((int)this.children.size(), (OutputStream)outputStream);
        this.serializeChildren(outputStream);
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        if (this.valueSet == null) {
            ReadWriteIOUtils.write((int)(this.mark ? -1 : -2), (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write((int)this.valueSet.size(), (OutputStream)outputStream);
            for (V value : this.valueSet) {
                this.serializer.write(value, outputStream);
            }
        }
        ReadWriteIOUtils.write((int)this.children.size(), (OutputStream)outputStream);
        this.serializeChildren(outputStream);
    }

    void serializeChildren(PublicBAOS outputStream) throws IOException {
        for (PathPatternNode<V, VSerializer> childNode : this.children.values()) {
            childNode.serialize(outputStream);
        }
    }

    void serializeChildren(DataOutputStream outputStream) throws IOException {
        for (PathPatternNode<V, VSerializer> childNode : this.children.values()) {
            childNode.serialize(outputStream);
        }
    }

    public static <V, T extends Serializer<V>> PathPatternNode<V, T> deserializeNode(ByteBuffer buffer, T serializer, Consumer<String> nodeNameProcessor) {
        PathPatternNode<V, T> node = new PathPatternNode<V, T>(ReadWriteIOUtils.readString((ByteBuffer)buffer), serializer);
        nodeNameProcessor.accept(node.name);
        int typeOrValueSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        if (typeOrValueSize >= 0) {
            HashSet<V> valueSet = new HashSet<V>();
            for (int i = 0; i < typeOrValueSize; ++i) {
                valueSet.add(serializer.read(buffer));
            }
            node.valueSet = valueSet;
        } else if (typeOrValueSize == -1) {
            node.markPathPattern(true);
        }
        for (int childrenSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer); childrenSize > 0; --childrenSize) {
            PathPatternNode<V, T> tmpNode = PathPatternNode.deserializeNode(buffer, serializer, nodeNameProcessor);
            node.addChild(tmpNode);
        }
        return node;
    }

    public static class VoidSerializer
    implements Serializer<Void> {
        public static VoidSerializer getInstance() {
            return VoidSerializerHolder.INSTANCE;
        }

        private VoidSerializer() {
        }

        @Override
        public void write(Void unused, ByteBuffer buffer) {
        }

        @Override
        public void write(Void unused, PublicBAOS stream) {
        }

        @Override
        public void write(Void unused, DataOutputStream stream) {
        }

        @Override
        public Void read(ByteBuffer buffer) {
            return null;
        }

        private static class VoidSerializerHolder {
            private static final VoidSerializer INSTANCE = new VoidSerializer();

            private VoidSerializerHolder() {
            }
        }
    }

    public static interface Serializer<T> {
        public void write(T var1, ByteBuffer var2);

        public void write(T var1, PublicBAOS var2) throws IOException;

        public void write(T var1, DataOutputStream var2) throws IOException;

        public T read(ByteBuffer var1);
    }
}

