/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSType;

public enum SystemFileFactory {
    INSTANCE;

    private static FSType fsType;
    private static final String UNSUPPORTED_FILE_SYSTEM = "Unsupported file system: ";

    public File getFile(String pathname) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException(UNSUPPORTED_FILE_SYSTEM + fsType.name());
        }
        return new File(pathname);
    }

    public File getFile(String parent, String child) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException(UNSUPPORTED_FILE_SYSTEM + fsType.name());
        }
        return new File(parent, child);
    }

    public File getFile(File parent, String child) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException(UNSUPPORTED_FILE_SYSTEM + fsType.name());
        }
        return new File(parent, child);
    }

    public File getFile(URI uri) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException(UNSUPPORTED_FILE_SYSTEM + fsType.name());
        }
        return new File(uri);
    }

    public void makeDirIfNecessary(String dir) throws IOException {
        File directory = this.getFile(dir);
        if (directory.isFile()) {
            directory = directory.getParentFile();
        }
        if (directory.exists()) {
            return;
        }
        FileUtils.forceMkdir((File)directory);
    }

    static {
        fsType = CommonDescriptor.getInstance().getConfig().getSystemFileStorageFs();
    }
}

