/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api;

import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.udf.api.UDF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.utils.RowImpl;

public interface UDTF
extends UDF {
    public void beforeStart(UDFParameters var1, UDTFConfigurations var2) throws Exception;

    default public void transform(Row row, PointCollector collector) throws Exception {
    }

    default public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
    }

    default public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        int i;
        int colCount = columns.length;
        int rowCount = columns[0].getPositionCount();
        TSDataType[] dataTypes = new TSDataType[colCount];
        for (i = 0; i < colCount; ++i) {
            dataTypes[i] = columns[i].getDataType();
        }
        for (i = 0; i < rowCount; ++i) {
            Object[] values = new Object[colCount];
            for (int j = 0; j < colCount; ++j) {
                values[j] = columns[j].isNull(i) ? null : columns[j].getObject(i);
            }
            RowImpl row = new RowImpl(dataTypes);
            row.setRowRecord(values);
            Object res = this.transform(row);
            if (res != null) {
                builder.writeObject(res);
                continue;
            }
            builder.appendNull();
        }
    }

    default public Object transform(Row row) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public void terminate(PointCollector collector) throws Exception {
    }
}

