/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.simple;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.IllegalPeerEndpointException;
import org.apache.iotdb.consensus.exception.IllegalPeerNumException;
import org.apache.iotdb.consensus.simple.SimpleConsensusServerImpl;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleConsensus
implements IConsensus {
    private final Logger logger = LoggerFactory.getLogger(SimpleConsensus.class);
    private final TEndPoint thisNode;
    private final int thisNodeId;
    private final File storageDir;
    private final IStateMachine.Registry registry;
    private final Map<ConsensusGroupId, SimpleConsensusServerImpl> stateMachineMap = new ConcurrentHashMap<ConsensusGroupId, SimpleConsensusServerImpl>();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public SimpleConsensus(ConsensusConfig config, IStateMachine.Registry registry) {
        this.thisNode = config.getThisNodeEndPoint();
        this.thisNodeId = config.getThisNodeId();
        this.storageDir = new File(config.getStorageDir());
        this.registry = registry;
    }

    @Override
    public synchronized void start() throws IOException {
        this.initAndRecover();
    }

    private void initAndRecover() throws IOException {
        if (!this.storageDir.exists()) {
            if (!this.storageDir.mkdirs()) {
                throw new IOException(String.format("Unable to create consensus dir at %s", this.storageDir));
            }
        } else {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.storageDir.toPath());){
                for (Path path : stream) {
                    String[] items = path.getFileName().toString().split("_");
                    ConsensusGroupId consensusGroupId = ConsensusGroupId.Factory.create((int)Integer.parseInt(items[0]), (int)Integer.parseInt(items[1]));
                    SimpleConsensusServerImpl consensus = new SimpleConsensusServerImpl(new Peer(consensusGroupId, this.thisNodeId, this.thisNode), (IStateMachine)this.registry.apply(consensusGroupId));
                    this.stateMachineMap.put(consensusGroupId, consensus);
                    consensus.start();
                }
            }
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        this.stateMachineMap.values().parallelStream().forEach(SimpleConsensusServerImpl::stop);
    }

    @Override
    public TSStatus write(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        TSStatus status;
        SimpleConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        if (impl.isReadOnly()) {
            return StatusUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY);
        }
        if (groupId instanceof DataRegionId) {
            long startWriteTime = System.nanoTime();
            status = impl.write(request);
            PERFORMANCE_OVERVIEW_METRICS.recordEngineCost(System.nanoTime() - startWriteTime);
        } else {
            status = impl.write(request);
        }
        return status;
    }

    @Override
    public DataSet read(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        return Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId)).read(request);
    }

    @Override
    public void createLocalPeer(ConsensusGroupId groupId, List<Peer> peers) throws ConsensusException {
        int consensusGroupSize = peers.size();
        if (consensusGroupSize != 1) {
            throw new IllegalPeerNumException(consensusGroupSize);
        }
        if (!peers.contains(new Peer(groupId, this.thisNodeId, this.thisNode))) {
            throw new IllegalPeerEndpointException(this.thisNode, peers);
        }
        AtomicBoolean exist = new AtomicBoolean(true);
        Optional.ofNullable(this.stateMachineMap.computeIfAbsent(groupId, k -> {
            exist.set(false);
            String path = this.buildPeerDir(groupId);
            File file = new File(path);
            if (!file.mkdirs()) {
                this.logger.warn("Unable to create consensus dir for group {} at {}", (Object)groupId, (Object)path);
                return null;
            }
            SimpleConsensusServerImpl impl = new SimpleConsensusServerImpl((Peer)peers.get(0), (IStateMachine)this.registry.apply(groupId));
            impl.start();
            return impl;
        })).orElseThrow(() -> new ConsensusException(String.format("Unable to create consensus dir for group %s", groupId)));
        if (exist.get()) {
            throw new ConsensusGroupAlreadyExistException(groupId);
        }
    }

    @Override
    public void deleteLocalPeer(ConsensusGroupId groupId) throws ConsensusException {
        AtomicBoolean exist = new AtomicBoolean(false);
        this.stateMachineMap.computeIfPresent(groupId, (k, v) -> {
            exist.set(true);
            v.stop();
            FileUtils.deleteDirectory((File)new File(this.buildPeerDir(groupId)));
            return null;
        });
        if (!exist.get()) {
            throw new ConsensusGroupNotExistException(groupId);
        }
    }

    @Override
    public void addRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        throw new ConsensusException("SimpleConsensus does not support membership changes");
    }

    @Override
    public void removeRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        throw new ConsensusException("SimpleConsensus does not support membership changes");
    }

    @Override
    public void transferLeader(ConsensusGroupId groupId, Peer newLeader) throws ConsensusException {
        throw new ConsensusException("SimpleConsensus does not support leader transfer");
    }

    @Override
    public void triggerSnapshot(ConsensusGroupId groupId) throws ConsensusException {
        throw new ConsensusException("SimpleConsensus does not support snapshot trigger currently");
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        return true;
    }

    @Override
    public boolean isLeaderReady(ConsensusGroupId groupId) {
        return true;
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        if (!this.stateMachineMap.containsKey(groupId)) {
            return null;
        }
        return new Peer(groupId, this.thisNodeId, this.thisNode);
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        return new ArrayList<ConsensusGroupId>(this.stateMachineMap.keySet());
    }

    private String buildPeerDir(ConsensusGroupId groupId) {
        return this.storageDir + File.separator + groupId.getType().getValue() + "_" + groupId.getId();
    }
}

