/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.string;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFRegexMatch
implements UDTF {
    private Pattern pattern;
    private int group;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT).validate(regex -> ((String)regex).length() > 0, "regexp has to be a valid regular expression.", (Object)validator.getParameters().getStringOrDefault("regex", "")).validate(group -> (Integer)group >= 0, "group index has to be a non-negative integer.", (Object)validator.getParameters().getIntOrDefault("group", 0));
    }

    @Override
    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        this.pattern = Pattern.compile(udfParameters.getString("regex"));
        this.group = udfParameters.getIntOrDefault("group", 0);
        udtfConfigurations.setAccessStrategy(new MappableRowByRowAccessStrategy()).setOutputDataType(Type.TEXT);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        Matcher matcher = this.pattern.matcher(row.getString(0));
        if (matcher.find() && matcher.groupCount() >= this.group) {
            collector.putString(row.getTime(), matcher.group(this.group));
        }
    }

    @Override
    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(row.getString(0));
        if (matcher.find() && matcher.groupCount() >= this.group) {
            return matcher.group(this.group);
        }
        return null;
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            String str = inputs[i].toString();
            Matcher matcher = this.pattern.matcher(str);
            if (matcher.find() && matcher.groupCount() >= this.group) {
                builder.writeBinary(new Binary(matcher.group(this.group).getBytes()));
                continue;
            }
            builder.appendNull();
        }
    }
}

