/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.net.SocketException;
import org.apache.iotdb.rpc.TElasticFramedTransport;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class TimeoutChangeableTFastFramedTransport
extends TElasticFramedTransport
implements TimeoutChangeableTransport {
    private final TSocket underlyingSocket;

    public TimeoutChangeableTFastFramedTransport(TSocket underlying, int thriftDefaultBufferSize, int thriftMaxFrameSize) {
        super(underlying, thriftDefaultBufferSize, thriftMaxFrameSize);
        this.underlyingSocket = underlying;
    }

    @Override
    public void setTimeout(int timeout) {
        this.underlyingSocket.setTimeout(timeout);
    }

    @Override
    public int getTimeOut() throws SocketException {
        return this.underlyingSocket.getSocket().getSoTimeout();
    }

    @Override
    public TTransport getSocket() {
        return this.underlyingSocket;
    }

    public static class Factory
    extends TTransportFactory {
        private final int thriftDefaultBufferSize;
        protected final int thriftMaxFrameSize;

        public Factory(int thriftDefaultBufferSize, int thriftMaxFrameSize) {
            this.thriftDefaultBufferSize = thriftDefaultBufferSize;
            this.thriftMaxFrameSize = thriftMaxFrameSize;
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            if (trans instanceof TSocket) {
                return new TimeoutChangeableTFastFramedTransport((TSocket)trans, this.thriftDefaultBufferSize, this.thriftMaxFrameSize);
            }
            return new TElasticFramedTransport(trans, this.thriftDefaultBufferSize, this.thriftMaxFrameSize);
        }
    }
}

