/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.security.encrypt.AsymmetricEncryptFactory;
import org.apache.iotdb.confignode.rpc.thrift.TPathPrivilege;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUtils.class);
    private static final String ROOT_PREFIX = "root";
    private static final int MIN_LENGTH = 4;
    private static final int MAX_LENGTH = 32;
    private static final String REX_PATTERN = "^[-\\w!@#$%^&*()+=]*$";
    private static final int MAX_LENGTH_PRE = 64;
    private static final String REX_PATTERN_PRE = "^[-\\w]*$";

    private AuthUtils() {
    }

    public static void validatePasswordPre(String password) throws AuthException {
        AuthUtils.validateNameOrPasswordPre(password);
    }

    public static void validateUsernamePre(String username) throws AuthException {
        AuthUtils.validateNameOrPasswordPre(username);
    }

    public static void validateRolenamePre(String rolename) throws AuthException {
        AuthUtils.validateNameOrPasswordPre(rolename);
    }

    public static void validateNameOrPasswordPre(String str) throws AuthException {
        int length = str.length();
        if (length < 4) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The length of name or password must be greater than or equal to 4");
        }
        if (length > 64) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The length of name or password must be less than or equal to 32");
        }
        if (str.contains(" ")) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The name or password cannot contain spaces");
        }
        if (!str.matches(REX_PATTERN_PRE)) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The name or password can only contain letters, numbers, and underscores");
        }
    }

    public static void validatePassword(String password) throws AuthException {
        AuthUtils.validateNameOrPassword(password);
    }

    public static boolean validatePassword(String originPassword, String encryptPassword) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).validate(originPassword, encryptPassword);
    }

    public static void validateUsername(String username) throws AuthException {
        AuthUtils.validateNameOrPassword(username);
    }

    public static void validateRolename(String rolename) throws AuthException {
        AuthUtils.validateNameOrPassword(rolename);
    }

    public static void validateNameOrPassword(String str) throws AuthException {
        int length = str.length();
        if (length < 4) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The length of name or password must be greater than or equal to 4");
        }
        if (length > 32) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The length of name or password must be less than or equal to 32");
        }
        if (str.contains(" ")) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The name or password cannot contain spaces");
        }
        if (!str.matches(REX_PATTERN)) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The name or password can only contain letters, numbers or !@#$%^*()_+-=");
        }
    }

    public static void validatePath(PartialPath path) throws AuthException {
        if (!path.getFirstNode().equals(ROOT_PREFIX)) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, String.format("Illegal seriesPath %s, seriesPath should start with \"%s\"", path, ROOT_PREFIX));
        }
    }

    public static void validatePatternPath(PartialPath path) throws AuthException {
        AuthUtils.validatePath(path);
        if (!path.hasWildcard()) {
            return;
        }
        if (!PathPatternUtil.isMultiLevelMatchWildcard(path.getTailNode())) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, String.format("Illegal pattern path: %s, only pattern path that end with ** are supported.", path));
        }
        for (int i = 0; i < path.getNodeLength() - 1; ++i) {
            if (!PathPatternUtil.hasWildcard(path.getNodes()[i])) continue;
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, String.format("Illegal pattern path: %s, only pattern path that end with wildcards are supported.", path));
        }
    }

    public static PartialPath convertPatternPath(PartialPath path) throws IllegalPathException {
        String pathStr = new String();
        for (int i = 0; i < path.getNodeLength() && !PathPatternUtil.hasWildcard(path.getNodes()[i]); ++i) {
            pathStr = pathStr.concat(path.getNodes()[i] + ".");
        }
        pathStr = pathStr.concat("**");
        return new PartialPath(pathStr);
    }

    public static String encryptPassword(String password) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).encrypt(password);
    }

    public static boolean checkPathPrivilege(PartialPath path, int privilegeId, List<PathPrivilege> privilegeList) {
        if (privilegeList == null) {
            return false;
        }
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().matchFullPath(path) || !pathPrivilege.checkPrivilege(privilegeId)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPathPrivilegeGrantOpt(PartialPath path, int privilegeId, List<PathPrivilege> privilegeList) {
        if (privilegeList == null) {
            return false;
        }
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().matchFullPath(path) || !pathPrivilege.getPrivileges().contains(privilegeId) || !pathPrivilege.getGrantOpt().contains(privilegeId)) continue;
            return true;
        }
        return false;
    }

    public static Set<Integer> getPrivileges(PartialPath path, List<PathPrivilege> privilegeList) {
        if (privilegeList == null) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> privileges = new HashSet<Integer>();
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().matchFullPath(path)) continue;
            privileges.addAll(pathPrivilege.getPrivileges());
        }
        return privileges;
    }

    public static boolean hasPrivilegeToReovke(PartialPath path, int privilegeId, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!path.matchFullPath(pathPrivilege.getPath()) || !pathPrivilege.getPrivileges().contains(privilegeId)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPrivilege(PartialPath path, int privilegeId, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path) || !pathPrivilege.getPrivileges().contains(privilegeId)) continue;
            return true;
        }
        return false;
    }

    public static void addPrivilege(PartialPath path, int privilegeId, List<PathPrivilege> privilegeList, boolean grantOption) {
        PathPrivilege targetPathPrivilege = null;
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            targetPathPrivilege = pathPrivilege;
            break;
        }
        if (targetPathPrivilege == null) {
            targetPathPrivilege = new PathPrivilege(path);
            privilegeList.add(targetPathPrivilege);
        }
        targetPathPrivilege.grantPrivilege(privilegeId, grantOption);
    }

    public static void removePrivilege(PartialPath path, int privilegeId, List<PathPrivilege> privilegeList) {
        Iterator<PathPrivilege> it = privilegeList.iterator();
        while (it.hasNext()) {
            PathPrivilege pathPri = it.next();
            if (!path.matchFullPath(pathPri.getPath())) continue;
            pathPri.revokePrivilege(privilegeId);
            if (!pathPri.getPrivileges().isEmpty()) continue;
            it.remove();
        }
    }

    public static void removePrivilegePre(PartialPath path, int privilegeId, List<PathPrivilege> privilegeList) {
        Iterator<PathPrivilege> it = privilegeList.iterator();
        while (it.hasNext()) {
            PathPrivilege pathPri = it.next();
            if (!pathPri.getPath().equals(path)) continue;
            if (privilegeId == PriPrivilegeType.ALL.ordinal()) {
                it.remove();
                return;
            }
            pathPri.revokePrivilege(privilegeId);
            if (!pathPri.getPrivileges().isEmpty()) continue;
            it.remove();
        }
    }

    public static TPermissionInfoResp generateEmptyPermissionInfoResp() {
        TPermissionInfoResp permissionInfoResp = new TPermissionInfoResp();
        permissionInfoResp.setUserInfo(new TUserResp("", "", new ArrayList<TPathPrivilege>(), new HashSet<Integer>(), new HashSet<Integer>(), new ArrayList<String>(), false));
        HashMap<String, TRoleResp> roleInfo = new HashMap<String, TRoleResp>();
        roleInfo.put("", new TRoleResp("", new ArrayList<TPathPrivilege>(), new HashSet<Integer>(), new HashSet<Integer>()));
        permissionInfoResp.setRoleInfo(roleInfo);
        return permissionInfoResp;
    }

    public static Set<Integer> strToPermissions(String[] authorizationList) throws AuthException {
        HashSet<Integer> result = new HashSet<Integer>();
        if (authorizationList == null) {
            return result;
        }
        PrivilegeType[] types = PrivilegeType.values();
        for (String authorization : authorizationList) {
            boolean legal = false;
            for (PrivilegeType privilegeType : types) {
                if (!authorization.equalsIgnoreCase(privilegeType.name())) continue;
                result.add(privilegeType.ordinal());
                legal = true;
                break;
            }
            if (legal) continue;
            throw new AuthException(TSStatusCode.UNKNOWN_AUTH_PRIVILEGE, "No such privilege " + authorization);
        }
        return result;
    }

    public static ByteBuffer serializePartialPathList(List<PartialPath> paths) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(paths.size());
            for (PartialPath path : paths) {
                path.serialize(dataOutputStream);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to serialize PartialPath list", e);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public static List<PartialPath> deserializePartialPathList(ByteBuffer buffer) {
        int size = buffer.getInt();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (int i = 0; i < size; ++i) {
            paths.add((PartialPath)PathDeserializeUtil.deserialize(buffer));
        }
        return paths;
    }

    public static void checkAndRefreshPri(Role role) {
        if (role.getServiceReady()) {
            return;
        }
        Set<Integer> sysPriCopy = role.getSysPrivilege();
        List<PathPrivilege> priCopy = role.getPathPrivilegeList();
        role.setSysPrivilegeSet(new HashSet<Integer>());
        role.setPrivilegeList(new ArrayList<PathPrivilege>());
        for (PathPrivilege pathPri : priCopy) {
            PartialPath path = pathPri.getPath();
            for (int prePri : pathPri.getPrivileges()) {
                PriPrivilegeType type = PriPrivilegeType.values()[prePri];
                if (!type.isAccept()) continue;
                for (PrivilegeType curType : type.getSubPri()) {
                    if (curType.isPathRelevant()) {
                        try {
                            AuthUtils.validatePatternPath(path);
                        }
                        catch (AuthException e) {
                            try {
                                path = AuthUtils.convertPatternPath(path);
                            }
                            catch (IllegalPathException illegalE) {
                                String[] str = new String[]{ROOT_PREFIX, "**"};
                                path = new PartialPath(str);
                            }
                        }
                        role.addPathPrivilege(path, curType.ordinal(), false);
                        continue;
                    }
                    role.addSysPrivilege(curType.ordinal());
                }
            }
        }
        role.setServiceReady(true);
    }
}

